/* converts bsaved text screens to text files */
/* stripping off the color attributes         */
/* and some printer control characters        */

#include <stdio.h>
#include <fcntl.h>
#include <stdlib.h>
#include <io.h>
#include <string.h>

main(int argc, char **argv)
{
    FILE *fp;
    int fh;
    unsigned char bigbuffer[4000];
    unsigned char buffer[128];
    unsigned char header[7];
    int limit = 25;
    int ptr=0,rows,columns;
    unsigned char outfile[128];
    unsigned char *wordptr;

    puts("BSV2TXT by Bill Buckels 1994");

    switch(argc){

        case 3: limit=atoi(argv[2]);
                if(limit<1||limit>25)limit=25;
        case 2:


    if((fh = open(argv[1],O_RDONLY|O_BINARY)) == -1)
    {
        perror(argv[1]);
        break;
    }
    read(fh,header,7);
    read(fh,bigbuffer,4000);
    close(fh);
    if(header[0]!=(unsigned char)'\xfd')
    {
        printf("%s is not a bsaved text screen...\n",argv[1]);
        break;
    }
    strcpy(buffer,argv[1]);
    strcat(buffer,".");
    wordptr=strtok(buffer,".");
    sprintf(outfile,"%s.TXT",buffer);

   if((fp=fopen(outfile,"wb"))==NULL)
   {
    perror(outfile);break;
   }
   printf("Now creating %s\n",outfile);

   for(rows=0;rows<limit;rows++)
    {
   for(columns=0;columns!=80;columns++)
    {
       buffer[columns]=bigbuffer[ptr];
       if(buffer[columns]==0||buffer[columns]==9||buffer[columns]==0x1a||
          buffer[columns]==8||buffer[columns]==255)buffer[columns]=32;
       ptr+=2;
   }
   columns=80;
   buffer[columns]=0x00;
   while(columns>0)
    {
       columns--;
       if(buffer[columns]==' ')buffer[columns]=0x00;
       else columns=0;
   }
   if(buffer[0]!=0)fwrite(buffer,strlen(buffer),1,fp);
   fputc(13,fp);
   fputc(10,fp);
   }
   fclose(fp);
   puts("Done!");
   break;

     default :printf(
    "USAGE is \"BSV2TXT [infile.bsv] [numberoflines-optional]\"\n");
  }
  exit(0);
}
