/* ------------------------------------------------------------------------ */
/* WINROBOT.C(C) Version 2.0 CopyRight Bill Buckels 1996-1999               */
/* All Rights Reversed.                                                     */
/*                                                                          */
/* Script Driven Multiple Application Chain Launcher For Windows            */
/* Shareware Version 2.0                                                    */
/*                                                                          */
/* Source Code Agreement                                                    */
/* ---------------------                                                    */
/*                                                                          */
/* This source code is provided as-is and where-is.                         */
/*                                                                          */
/* We understand how important it is for some sites to have source code.    */
/* It allows a programmer to modify and add to the WINROBOT program if      */
/* special requirements exist.                                              */
/*                                                                          */
/* But remember that you may not produce any commercial package from the    */
/* WINROBOT source code that competes with WINROBOT in any way. And We do   */
/* not support modified versions. You will have to take care of this        */
/* yourself.                                                                */
/*                                                                          */
/* Licence Agreement                                                        */
/* -----------------                                                        */
/*                                                                          */
/* This program is the exclusive property of the author, Bill Buckels.      */
/*                                                                          */
/* If you continue to use this program you must register with Bill Buckels  */
/*                                                                          */
/* Shareware Registration is $10.00 per installed copy. Payment by Cheque   */
/* or Money Order only to the address below.                                */
/*                                                                          */
/* Bill Buckels                                                             */
/* 589 Oxford Street                                                        */
/* Winnipeg, Mb, Cdn R3M 3J2                                                */
/*                                                                          */
/* Internet: bbuckels@escape.ca                                             */
/* Website:  http://www.escape.ca/~bbuckels                                 */
/*                                                                          */
/* Warranty and Liability                                                   */
/* ----------------------                                                   */
/*                                                                          */
/* This program and its files are thought to be free of defects.            */
/* Regardless, Bill Buckels assumes no liability whatsoever for the         */
/* fitness of use of WINROBOT, or any loss or damage resulting from its     */
/* use.                                                                     */
/*                                                                          */
/* If you cannot abide by these conditions and the conditions stated in     */
/* the Licence Agreement, do not use this program.                          */
/*                                                                          */
/* We apologize for errors or omissions. They were not intentional. If      */
/* you are a registered user, and you encounter a program bug, we will      */
/* provide you with support. If you aren't registered we won't.             */
/*                                                                          */
/* Distribution                                                             */
/* ------------                                                             */
/*                                                                          */
/* You may distribute this program and its source code freely. You may      */
/* not charge any fee for this distribution, except for a reasonable        */
/* duplication fee, as in the case of Shareware Distributors.               */
/*                                                                          */
/* If you obtained this program from a Shareware bundle (like a CD) you     */
/* must still register with the author.                                     */
/*                                                                          */
/* ------------------------------------------------------------------------ */
/* Written in Large Model Microsoft C Version 6.00a                         */
/* ------------------------------------------------------------------------ */

/*

Program History

The WinRobot program is the prototype that I used for a commercial
application launcher for a special purpose application that required the
use of linear launching of mixed dos and windows applications.

It is not really a prototype at all, but a pretty good and functional
straight-line task launcher for Windows.

The program that was based on WinRobot and eventually distributed was
tweaked somehwat from this prototype. It is not called WinRobot. The
recipient paid for the tweaking of the prototype and in fairness, the
paid-for additional functionality is not present in WinRobot in respect
of their special interest.

I wrote this application during many long evenings and weekends of very
tedious programming and testing. In restrospect I should have probably
been doing something of a more recreational nature since I was paid zero.

Sadly, the product that was based on WinRobot sees very little use.

I made the decision to distribute the WinRobot prototype as Shareware
in the hope of salvaging some of its remaining potential. It is really
too good an effort to throw away.

Prototype Revision History

Prototype written for Grant Rondeau - March 16, 1995
Revised to use instance count instead of file name - March 21,1995
Revised to support FOXPRO-style Runtime Applications - March 22,1995
Revised extensively to support user options and events - March 25,1995
Added Log File and Message Box Options Between Tasks - March 26,1995
Added FORCE and MINIMIZE-MAXIMIZE Window Size KEYWORDS - March 29,1995
Also Added Companion Program WAIT.EXE for external PAUSE/STABILIZE
Added System Critical Error Check/Abort - April 19,1995
Added Conditional Branching using IF EXIST and NOT EXIST - April 26,1995
Started Adding Dos Commands and Making More DOS Compliant - April 28,1995
Added On-Line Help and Prepared For First Release - May 7,1995
Added WildCard Support For Copy and Delete Commands - July 13,1995
Added Support for Commands using if exist and if not exist - July 17, 1995
Also Added Other Changes at Grant's Request
Simplified Wildcards in the Copy Command - July 27, 1995
Prepared prototype for distribution as ShareWare - July 1996
Fixed a bug in Wait.Exe (The Command Line Args Never Worked)
Revised WAIT.EXE to include scheduling options - September 1999.
Revised Shareware to have no time limit - September 1999.

*/

#include <windows.h>
#include <commdlg.h>
#include <dde.h>
#include <lzexpand.h>
#include <dos.h>
#include <direct.h>
#include <stdio.h>
#include <fcntl.h>
#include <io.h>
#include <stdlib.h>
#include <string.h>

#define MAXBUF     512
#define MAXCAT     430
#define MAXPATH    256
#define MAXARGS    255
#define MAXNAME    128
#define MAXLABEL    64

// A limited number of DOS commands are partially supported
// We use constants for these DOS commands.

// In addition to these, the Echo and Pause commands are also simulated.
// Note that wildcards are not fully supported nor are implied path names.

#define DOS_MKDIR   1
#define DOS_RMDIR   2
#define DOS_DELETE  3
#define DOS_COPY    4
#define DOS_RENAME  5

// In addition to standard message loop processing
// We also process messages that we send to our own window
// both directly and from our timer callback messages.

#define IDM_INIT     100
#define IDM_STARTUP  101
#define IDM_ABOUT    102
#define IDM_NEXT     103
#define IDM_TASK     104
#define IDM_CHILD    105
#define IDM_TIME     106
#define IDM_FILE     107
#define IDM_HELP     200

static char szAppName[80] =
   "WinRobot V2.0 Copyright \251 Bill Buckels 1996-1999\0";
static   char szPauseBuf[80] =
   "Press OK to continue...\0";

static   struct dosdate_t logdate;
static   struct dostime_t logtime;
static   UINT wSequence = (UINT)0;
static   UINT wStartHour, wStartMinute;
static   UINT wStopHour,  wStopMinute;
static   UINT wTarget,    wCurrent;
static   UINT MAXRETRIES  =(UINT)3;
static   UINT wRetries    =(UINT)0;
static   UINT MAXDELAY    =(UINT)10000;
static   UINT MAXWAIT     =(UINT)5000;
static   DWORD dwCtime    = 0L;

HMENU    hMenu;
HANDLE   hInst,hInstChild;
HICON    hIcon;
HWND     hChild;
HMODULE  hModuleChild;
HFILE    hfSource, hfDest;
OFSTRUCT ofSource, ofDest;

static char szSourcePath[85]="\0";
static char szSourceDrive[3]="\0";
static char szSourceDir[67] ="\0";
static char szSourceRoot[9] ="\0";
static char szSourceExt[4]  ="\0";

static char szTargetPath[85]="\0";
static char szTargetDrive[3]="\0";
static char szTargetDir[67] ="\0";
static char szTargetRoot[9] ="\0";
static char szTargetExt[4]  ="\0";

static char szCurrentPath[85]="\0";
static char szCurrentDrive[3]="\0";
static char szCurrentDir[67] ="\0";
static char szCurrentRoot[9] ="\0";
static char szCurrentExt[4]  ="\0";

char *lpThanks =
         "This is a single user registration and only a single copy "
         "of WinRobot may be used on a single computer per registration.\n\n"
         "Commercial installations are required to purchase a seperate "
         "licence for every potential user of WinRobot in their company.\n"
         "Installed versions may not be re-distributed.\n\n"
         "Thank you for registering.\n\n"
         "\tBill Buckels\n"
         "\tEmail: bbuckels@escape.ca\n"
         "\tWebSite: http://www.escape.ca/~bbuckels\n\n";

char *lpNoThanks =
         "You are allowed to use WinRobot for up to "
         "30 days to evaluate its fitness for use. Then you "
         "must register or remove WinRobot from your computer.\n\n"
         "To register send a cheque or money order for $10.00 to:\n\n"
         "\tBill Buckels\n"
         "\t589 Oxford Street\n"
         "\tWinnipeg, Mb, Cdn R3M 3J2\n"
         "\tEmail: bbuckels@escape.ca\n"
         "\tWebSite: http://www.escape.ca/~bbuckels\n\n"
         "After registering, this Nag Screen will no longer appear. "
         "Your registration instructions will be emailed to you "
         "after receiving payment. "
         "Please provide an internet address with payment.";

char *lpRobotKey    = "winrobot";
char *lpRegisterTo  = "registerto";
char *lpRegisterBy  = "registerby";

static   UINT wNumKids=(UINT)0,wSibling=(UINT)0;
static   int iSaveSibling = -1;
unsigned char *lpszChild;

static   char szArgs[MAXPATH]        ="\0";
static   char szArgList[MAXARGS][MAXNAME];
static   char szChildText[MAXPATH];
static   char szChildCompare[MAXPATH];

static   char szEchoBuf[MAXBUF]      ="\0";
static   char szMessBuf[MAXBUF]      ="\0";

static   char szDirPath[MAXNAME]     ="\0";
static   char szIniFile[MAXNAME]     ="\0";

static   char szLogFile[MAXNAME]     ="\0";
static   char szLogKey[32]           ="\0";
static   char szLogSection[32]       ="\0";

static   char szQuestionFile[MAXNAME]="\0";
static   char szAnswerFile[MAXNAME]  ="\0";
static   char szStopFile[MAXNAME]    ="\0";
static   char szStartFile[MAXNAME]   ="\0";
static   char szTemp[MAXNAME]        ="\0";
static   char szSource[MAXNAME]      ="\0";
static   char szDest[MAXNAME]        ="\0";
static   char szLabel[MAXLABEL]      ="\0";
static   char szTempCommand[MAXPATH] ="\0";
static   char szDebugFile[MAXNAME]   ="\0";

char *lpHeader     ="Header";

char *lpExOptions = "Options Section Example";
char *lpOptions   = "Options";
char *lpDelay     = "Delay";
char *lpRetries   = "Retries";
char *lpWait      = "Wait";

char *lpPurgeLog        = "PurgeLog";
char *lpUseLog          = "UseLog";
char *lpPurgeQuestion   = "PurgeQuestion";
char *lpUseQuestion     = "UseQuestion";
char *lpPurgeAnswer     = "PurgeAnswer";
char *lpUseAnswer       = "UseAnswer";
char *lpPurgeStop       = "PurgeStop";
char *lpUseStop         = "UseStop";
char *lpPause           = "Pause";
char *lpAppName         = "Appname";

char *lpDebug        = "Debug";
char *lpDebugFile    = "DebugFile";
char *lpPurgeDebug   = "PurgeDebug";


char *lpExFiles      = "Files Section Example";
char *lpFiles        = "Files";
char *lpLogFile      = "LogFile";
char *lpQuestionFile = "QuestionFile";
char *lpAnswerFile   = "AnswerFile";
char *lpStopFile     = "StopFile";
char *lpStartFile    = "StartFile";

char *lpExEvents  = "Events Section Example";
char *lpEvents    = "Events";
char *lpStartTime = "StartTime";
char *lpStopTime  = "StopTime";

char *lpszUsage=
"WINROBOT.EXE launches the applications "
"that were named in the script on the command line.\n\n"
"Usage is : WinRobot [list.txt] [optional-.ini file]\n\n"
"Each Line In The Script Contains An Application Name and its Command Line "
"or a KEYWORD to modify the next line. "
"WinRobot executes each launch consecutively.\n\n"
"A Timer Interval is used to check if each application has finished "
"and if it has, the next "
"application in the list is launched, or if an EXIT KEYWORD "
"is reached, the list is terminated and the Windows session "
"is ended.\n\n"
"\tBill Buckels\n"
"\tEmail: bbuckels@escape.ca\n"
"\tWebSite: http://www.escape.ca/~bbuckels\n\n";

BOOL     HELPACTIVE = FALSE;
BOOL     DEBUG      = FALSE;
BOOL     DEBUGFILE  = FALSE;
BOOL     FORCEAPP   = FALSE;

// default settings for user profiles for file options
BOOL     bUseLog        = TRUE;
BOOL     bPurgeLog      = TRUE;

BOOL     bUseQuestion   = TRUE;
BOOL     bPurgeQuestion = TRUE;
BOOL     bUseAnswer     = FALSE;
BOOL     bPurgeAnswer   = TRUE;
BOOL     bUseStop       = TRUE;
BOOL     bPurgeStop     = TRUE;
BOOL     bPurgeDebug    = TRUE;


// global process state flags
BOOL     WAITCHILD = FALSE;
BOOL     WAITTIME  = FALSE;
BOOL     WAITFILE  = FALSE;
BOOL     STARTED   = FALSE;
BOOL     DOSEXIT   = FALSE;
BOOL     REGISTERED= FALSE;
LONG     DOSCODE   = 0L;

// internal function prototypes
LONG FAR PASCAL AboutProc(HWND);
LONG FAR PASCAL HelpProc(HWND);
LONG FAR PASCAL LogEntry(LPSTR);
LONG FAR PASCAL ElapsedTime(LPSTR);
LONG FAR PASCAL GetUserProfile(HWND);
BOOL FAR PASCAL GetUserScript(HWND);

BOOL FAR PASCAL FileExists(LPSTR);
BOOL FAR PASCAL DosCommand(LPSTR);
BOOL FAR PASCAL WinEcho(HWND,LPSTR);

BOOL FAR PASCAL AbendSession(HWND);
BOOL FAR PASCAL EndSession(HWND);
BOOL FAR PASCAL SysCommand(WORD,HWND);
LONG FAR PASCAL NextCommand(HWND);
BOOL FAR PASCAL StopFile(HWND);
BOOL FAR PASCAL StopQuestion(HWND,LPSTR,LPSTR);
LONG FAR PASCAL WaitStartChild(HWND);
LONG FAR PASCAL WaitStartTime(HWND);
LONG FAR PASCAL WaitStartFile(HWND);
LONG FAR PASCAL TimerTask(HWND);
LONG FAR PASCAL StartUp(HWND);
LONG FAR PASCAL InitWindow(HWND);
LONG FAR PASCAL InitApplication(HANDLE,HANDLE,LPSTR);
LONG FAR PASCAL MainWndProc(HWND,WORD,WORD,LONG);

LONG FAR PASCAL CopyDebugFile();


int PASCAL WinMain (HANDLE hInstance, HANDLE hPrevInstance,
                    LPSTR lpszCmdParam, int nCmdShow)
     {

    MSG         msg;

    InitApplication(hInstance,hPrevInstance,lpszCmdParam);
    while (GetMessage(&msg, NULL, 0, 0))
        {
        TranslateMessage(&msg);
        DispatchMessage(&msg);
        }
    return (msg.wParam);

}


long FAR PASCAL MainWndProc(HWND hWnd, WORD message,
                            WORD wParam, LONG lParam)
{

    switch (message)
        {

    case WM_CREATE:
        // intialize startup procedure
        PostMessage(hWnd,WM_COMMAND,IDM_INIT,0L);
        return 0L;

    case WM_SYSCOMMAND :
        // filter system commands
        if(SysCommand(wParam,hWnd)==FALSE)return 0L;
        break;

    case WM_SYSTEMERROR:
        // an application quit responding and windows terminated it
        // or a similar system error occurred
        if(AbendSession(hWnd)==TRUE)return 0L;
        break;

    case WM_COMMAND:

        switch(wParam)
        {
            case IDM_INIT   : return InitWindow(hWnd);
            case IDM_ABOUT  : return AboutProc(hWnd);
            case IDM_STARTUP: return StartUp(hWnd);
            case IDM_NEXT   : return NextCommand(hWnd);
        }
        break;

    case WM_TIMER:

        switch(wParam)
        {
            case IDM_TASK : return TimerTask(hWnd);
            case IDM_CHILD: return WaitStartChild(hWnd);
            case IDM_TIME : return WaitStartTime(hWnd);
            case IDM_FILE : return WaitStartFile(hWnd);
        }
        break;

    case WM_QUERYENDSESSION:

        // if our apps are not finished don't quit
        // and don't stop the process by posting a message...
        if(EndSession(hWnd)==FALSE)return 0L;
        LogEntry("Windows Session Ending");
        break;

	case WM_DESTROY:

        ElapsedTime("** WinRobot End Run **");
        if(WAITTIME==TRUE)KillTimer(hWnd,IDM_TIME);
        if(WAITFILE==TRUE)KillTimer(hWnd,IDM_FILE);
        if(STARTED==TRUE)
        {
            KillTimer(hWnd,IDM_TASK);

        }
        else
        {
           if(WAITCHILD==TRUE)KillTimer(hWnd,IDM_CHILD);

        }
        wNumKids  = 0;
        wSibling  = 0;
        STARTED   = FALSE;
        WAITCHILD = FALSE;
        WAITTIME  = FALSE;
        WAITFILE  = FALSE;
        if(HELPACTIVE!=FALSE)WinHelp(hWnd,"WINROBOT.HLP",HELP_QUIT,0L);
        HELPACTIVE = FALSE;
           
        // check for QuestionFile and StopFile One More Time
        if(bUseQuestion==TRUE)StopQuestion(GetFocus(),szQuestionFile,szAnswerFile);
        if(bUseStop==TRUE)StopFile(GetFocus());

        PostQuitMessage(0);
        if(DOSEXIT==TRUE)
        {
          if(!ExitWindows(DOSCODE,0))
          {
               MessageBox(GetFocus(),"Unable to exit Windows\n\n. Please "
              "Close all active Windows and try again." ,szAppName,MB_ICONHAND);
               ElapsedTime("*** Unable to exit Windows ***");
            }
        }
        return 0L;

    }
    return (DefWindowProc(hWnd, message, wParam, lParam));
}


LONG FAR PASCAL ElapsedTime(LPSTR lpszDescription)
{
        DWORD dwStopHours, dwStopMinutes, dwStopSeconds;

        dwStopHours   =  GetCurrentTime();
        dwStopHours   -= dwCtime;
        dwStopSeconds  = (dwStopHours/1000);

        dwStopHours   =  (dwStopSeconds/3600);
        dwStopSeconds -= (dwStopHours*3600);

        dwStopMinutes = (dwStopSeconds/60);
        dwStopSeconds -= (dwStopMinutes*60);

        wsprintf(szMessBuf,"%s Elapsed Time %002ld:%002ld:%002ld",
                 lpszDescription,dwStopHours,dwStopMinutes,dwStopSeconds);
        LogEntry(szMessBuf);
        
return 0L;
}


BOOL FAR PASCAL FileExists(LPSTR lpszFileName)
{
   struct find_t wild_card;

   if(lpszFileName[0]==0)return FALSE;
   if(_dos_findfirst(lpszFileName,_A_NORMAL,&wild_card)!=0)return FALSE;

return TRUE;
}

// handle DOS echo commands in the script by accumulating
// the echoed text until the next command...
// return TRUE each time a valid echo is processed...
// if the next command is a pause command display an MB_OK message box.
// if the command being processed is neither a pause nor an echo
// display the echo buffer, clear the echo buffer and return false

// these get somewhat tricky and it is possible that this command
// may fail under some circumstances since many permutations
// are possible...
BOOL FAR PASCAL WinEcho(HWND hWnd, LPSTR lpszCommand)
{
   int iCommand, i;

   strcpy(szTemp,lpszCommand);

   // we can return from our last GOSUB
   if(strcmpi(szTemp,"RETURN")==0)
   {
    if(iSaveSibling>-1)
    {
        wSibling     = iSaveSibling;
        iSaveSibling = -1;
    }
    return TRUE;
   }


   // 1. Handle a pause preceded by an echoed message.
   // 2. Handle a pause without a preceding message.
   if(strcmpi(szTemp,"pause")==0)
   {
     if(szEchoBuf[0]==0)
     {
        MessageBox(hWnd,szPauseBuf,szAppName,MB_OK);
     }
     else
     {
        wsprintf(szMessBuf,"%s\n\n%s",szEchoBuf,szPauseBuf);
        MessageBox(hWnd,szMessBuf,szAppName,MB_OK);
     }
     szEchoBuf[0]=0;
     return TRUE;

   }

   // The Yesno Command is Used for Decision Branching
   // If the answer is YES we advance an extra line
   // We use the message in the ECHO BUFFER to prompt the user
   if(strcmpi(szTemp,"yesno")==0)
   {

     if(szEchoBuf[0]!=0)
     {
       if(MessageBox(hWnd,szEchoBuf,szAppName,MB_YESNO)!=IDNO)
       {
         if(wSibling<wNumKids)wSibling+=1;
           
        }
       szEchoBuf[0]=0;
       return TRUE;
     }
   }


   // 3a. if the command is not an echo, and not a pause,
   //     display the buffer and get out of here
   i=0;
   for(;;)
   {
     if(szTemp[i]==32)szTemp[i]=0;
     if(szTemp[i]==0)break;
     i++;
     if(szTemp[i]==0)   // single level commands
     {
       if(szEchoBuf[0]!=0)MessageBox(hWnd,szEchoBuf,szAppName,MB_OK);
       szEchoBuf[0]=0;
       if(strcmpi(szTemp,"cls")==0)return TRUE;
       if(strcmpi(szTemp,"rem")==0)return TRUE;
       return FALSE;
     }
   }

   // 3b. if the command is not an echo, and not a pause,
   //    display the buffer and get out of here
   if(strcmpi(szTemp,"echo")!=0)
   {
     if(szEchoBuf[0]==0)return FALSE;
     MessageBox(hWnd,szEchoBuf,szAppName,MB_OK);
     szEchoBuf[0]=0;
     return FALSE;
   }

   // 4. otherwise accumulate the echo...
   i++;
   if(szEchoBuf[0]==0)
   {
      strcpy(szEchoBuf,(char *)&szTemp[i]);
   }
   else
   {
      if(strlen(szEchoBuf)<MAXCAT)   // don't overflow the buffer
      {
        strcat(szEchoBuf,"\n");
        strcat(szEchoBuf,(char *)&szTemp[i]);
      }
   }

return TRUE;
}


void ClearPathBuffers()
{
      // Clears the buffers used by the DOS-Like Wildcard Commands

      szSourcePath[0] =0;
      szSourceDrive[0]=0;
      szSourceDir[0]  =0;
      szSourceRoot[0] =0;
      szSourceExt[0]  =0;

      szTargetPath[0] =0;
      szTargetDrive[0]=0;
      szTargetDir[0]  =0;
      szTargetRoot[0] =0;
      szTargetExt[0]  =0;

      szCurrentPath[0] =0;
      szCurrentDrive[0]=0;
      szCurrentDir[0]  =0;
      szCurrentRoot[0] =0;
      szCurrentExt[0]  =0;

}

int BuildCopyList(char *lpszSource, char *lpszTarget)
{
      // Copies and Expands Individual or Multiple Files.
      //   Builds a CopyList using DOS-Like WildCards
      //   Then Uses This List To Copy Files
      //   n.b. We Don't Support a Multiple File Copy/Rename

      FILE *fp;
      struct find_t wild_card;
      int i;

      ClearPathBuffers();

      // don't accept null strings
      if(lpszSource[0]==0||lpszTarget[0]==0)return -1;

      // don't accept duplicate paths
      wsprintf(szSourcePath,"%s",lpszSource);
      _splitpath(szSourcePath,szSourceDrive,szSourceDir,
                            szSourceRoot,szSourceExt);

      wsprintf(szTargetPath,"%s",lpszTarget);

      if(DEBUG==TRUE)
      {
        fp=fopen("COPYDE.BUG","a");
        fprintf(fp,"s= %s\n",szSourcePath);
        fprintf(fp,"t= %s\n",szTargetPath);
      }
      if(strcmpi(szSourcePath,szTargetPath)==0)
      {
        if(DEBUG==TRUE)fclose(fp);
        return -2;
       }

       for(i=0;i<MAXNAME;i++)
       {
        if(szTargetPath[i]==0)break;
       }

       if(szTargetPath[i-1]!=92 && szTargetPath[i-1]!=':')
       {

         szTargetPath[i]=92;
         szTargetPath[i+1]= 0;
       }

       if(DEBUG == TRUE)
       {
         fprintf(fp,"length of t3 = %d\n",i);
         fprintf(fp,"s3= %s\n",szSourcePath);
         fprintf(fp,"t3= %s\n",szTargetPath);
         fclose(fp);
       }

       // if nothing to do, don't do anything...
       if(_dos_findfirst(szSourcePath,_A_NORMAL,&wild_card)!=0)return 0;

        wsprintf(szCurrentPath,"%sCOPYLIST.$$$",szTargetPath);
        if((fp=fopen(szCurrentPath,"w"))==NULL)return -4;

        // Build The Copy List
        for(;;)
        {
        // don't copy the copy list
        if(strcmpi(wild_card.name,"COPYLIST.$$$")!=0)
        {
          fprintf(fp,"%s%s%s\n",szSourceDrive,szSourceDir,wild_card.name);
          fprintf(fp,"%s%s\n",szTargetPath,wild_card.name);
         }
          if(_dos_findnext(&wild_card)!=0)break;
        }
        fclose(fp);

        // Copy The Files In The Copy List
        if((fp=fopen(szCurrentPath,"r"))==NULL)return -4;
        while(fgets(szSource,MAXNAME,fp)!=NULL)
        {
         if(fgets(szDest,MAXNAME,fp)==NULL)break;
         for(i=0;i<MAXNAME;i++)
         {
            if(szSource[i]==10||szSource[i]==13)szSource[i]=0;
            if(szDest[i]==10  ||szDest[i]==13)  szDest[i]=0;
         }
         if(strcmpi(szSource,szDest)!=0)
         {
           hfSource =LZOpenFile(szSource,&ofSource,OF_READ);
           hfDest =LZOpenFile(szDest,&ofDest,OF_CREATE);
           LZCopy(hfSource,hfDest);
           LZClose(hfSource);
           LZClose(hfDest);
         }
         }
         fclose(fp);
         if(DEBUG!=TRUE)remove(szCurrentPath);
         ClearPathBuffers();

return 0;
}

int BuildDeleteList(char *lpszSource)
{
      FILE *fp;
      struct find_t wild_card;
      int i;

      ClearPathBuffers();

      // don't accept null strings
      if(lpszSource[0]==0)return -1;
      strcpy(szSourcePath,lpszSource);
      _splitpath(szSourcePath,
                 szSourceDrive,szSourceDir,szSourceRoot,szSourceExt);

      // nothing to do so don't do anything
      wsprintf(szCurrentPath,"%s%sDELLIST.$$$",szSourceDrive,szSourceDir);
      if((fp=fopen(szCurrentPath,"w"))==NULL)return -4;

      if(_dos_findfirst(szSourcePath,_A_NORMAL,&wild_card)==0)
      {
        for(;;)
        {
          fprintf(fp,"%s%s%s\n",szSourceDrive,szSourceDir,wild_card.name);
          if(_dos_findnext(&wild_card)!=0)
          {
            fclose(fp);break;
           }
         }

         if((fp=fopen(szCurrentPath,"r"))==NULL)return -4;
         while(fgets(szSource,MAXNAME,fp)!=NULL)
         {
           for(i=0;i<MAXNAME;i++)
           {
            if(szSource[i]==10||szSource[i]==13)szSource[i]=0;
            }
           // don't remove the delete list
           if(strcmpi(szSource,szCurrentPath)!=0)remove(szSource);
         }
      }
      fclose(fp);
      if(DEBUG==TRUE)remove(szCurrentPath);
      ClearPathBuffers();

return 0;
}

BOOL FAR PASCAL DosCommand(LPSTR lpszCommand)
{

   // Partial Implementation Only of Some DOS Commands
   int iCommand, i;

   strcpy(szTemp,lpszCommand);
   i=0;
   for(;;)
   {
     if(szTemp[i]==32)szTemp[i]=0;
     if(szTemp[i]==0)break;
     i++;
     if(szTemp[i]==0)return FALSE;   // single level commands
                                     // are handled with echo and pause
   }

   strcpy(szLabel,szTemp);
   for(;;)
   {
     iCommand = DOS_MKDIR;
     if(strcmpi(szLabel,"md")==0)break;
     if(strcmpi(szLabel,"mkdir")==0)break;
     iCommand = DOS_RMDIR;
     if(strcmpi(szLabel,"rd")==0)break;
     if(strcmpi(szLabel,"rmdir")==0)break;
     iCommand = DOS_DELETE;
     if(strcmpi(szLabel,"del")==0)break;
     if(strcmpi(szLabel,"delete")==0)break;
     if(strcmpi(szLabel,"erase")==0)break;
     iCommand = DOS_RENAME;
     if(strcmpi(szLabel,"ren")==0)break;
     if(strcmpi(szLabel,"rename")==0)break;
     iCommand = DOS_COPY;
     if(strcmpi(szLabel,"copy")==0)break;
     if(strcmpi(szTemp,"cls")==0)return TRUE;
     if(strcmpi(szTemp,"rem")==0)return TRUE;
     return FALSE;
   }

   i++;
   strcpy(szSource,(char *)&szTemp[i]);
   if(szSource[0]==0)return FALSE;

   szDest[0]=0;
   i=0;
   for(;;)
   {
     if(szSource[i]==32)
     {
        szSource[i]=0;
        strcpy(szDest,(char *)&szSource[i+1]);
     }
     if(szSource[i]==0)break;
     i++;
   }

   // We Are Not Checking For Completion of These Yet. This is OK for now.
   // DOS doesn't abort processing of a batch if an error occurrs either.
   // Perhaps in a future version of WinRobot we should check for completion.
   switch(iCommand)
   {
      case DOS_MKDIR:  mkdir(szSource);
                       break;
      case DOS_RMDIR:  rmdir(szSource);
                       break;
      case DOS_DELETE: if(BuildDeleteList(szSource)!=0)return FALSE;
                       break;
      case DOS_RENAME:
                       // WildCards Are Not Supported for now
                       for(i=0;lpszCommand[i]!=0;i++)if(lpszCommand[i]=='*')return FALSE;
                       if(szDest[0]==0)return FALSE;
                       rename(szSource,szDest);
                       break;
      case DOS_COPY:
                       for(i=0;szDest[i]!=0;i++)if(szDest[i]=='*')szDest[i]=0;
                       if(BuildCopyList(szSource,szDest)!=0)return FALSE;
                       break;
    }

return TRUE;
}


BOOL FAR PASCAL EndSession(HWND hWnd)
{
   if(DOSEXIT==TRUE)return TRUE;
   FlashWindow(hWnd,FALSE);
   MessageBeep(-1);
   LogEntry("Premature Session End Request");
   if(STARTED==TRUE)
   {
       KillTimer(hWnd,IDM_TASK);
       SetTimer (hWnd, IDM_TASK,(UINT)10, NULL);
       return FALSE;
   }
   // if we are waiting for a child process to start
   // don't quit until we are ready
   if(WAITCHILD==TRUE)
   {
       KillTimer(hWnd,IDM_CHILD);
       SetTimer (hWnd, IDM_CHILD,MAXNAME, NULL);
   }
   if(WAITTIME==TRUE)
   {
       KillTimer(hWnd,IDM_TIME);
       SetTimer (hWnd, IDM_TIME,(UINT)10, NULL);
   }
   if(WAITFILE==TRUE)
   {
       KillTimer(hWnd,IDM_FILE);
       SetTimer (hWnd,IDM_FILE,(UINT)10, NULL);
   }

return FALSE;
}

BOOL FAR PASCAL AbendSession(HWND hWnd)
{

   if(MessageBox(hWnd,"A System Error Has Occurred\n\n"
                      "Do you want to terminate WinRobot?",
                      "SYTEM ERROR!",MB_YESNO)==IDNO)return FALSE;

   LogEntry("System Error End Request");
   DestroyWindow(hWnd);

return TRUE;
}


LONG FAR PASCAL InitApplication(HANDLE hInstance, HANDLE hPrevInstance,
                                LPSTR lpszCmdParam)
{

    HWND        hWnd;
    WNDCLASS    wc;
    int         i=0,j=0;

    hInst = hInstance;

    // Create The Window Class Used By WinRobot
    if (!hPrevInstance)
    {
        hIcon            = LoadIcon(hInstance, "WinRobotIcon");
        wc.style         = CS_HREDRAW | CS_VREDRAW ;
        wc.lpfnWndProc   = MainWndProc;
        wc.cbClsExtra    = 0;
        wc.cbWndExtra    = 0;
        wc.hInstance     = hInst;
        wc.hIcon         = hIcon;
        wc.hCursor       = LoadCursor(NULL, IDC_ARROW);
        wc.hbrBackground = GetStockObject(WHITE_BRUSH);
        wc.lpszMenuName  =  NULL;
        wc.lpszClassName = "WINROBOT";
        RegisterClass (&wc) ;
    }

    // parse the script filename and the ini filename
    // from the command line
    if(lpszCmdParam[0]!=0)
    {
      i=0;
      j=0;
      for(;;)
      {
       if(lpszCmdParam[i]==0||lpszCmdParam[i]==32)break;
       szArgs[i]=lpszCmdParam[i];
       i++;
      }
      szArgs[i]=0;
      while(lpszCmdParam[i]==32)i++;
      if(lpszCmdParam[i]!=0)
      {
       for(;;)
       {
         if(lpszCmdParam[i]==0||lpszCmdParam[i]==32)
         {
           szIniFile[j]=0;break;
        }
        szIniFile[j]=lpszCmdParam[i];
        i++;
        j++;
       }
      }

    }
    dwCtime = GetCurrentTime();

    // create a window without a menu
    hWnd = CreateWindow ("WINROBOT", szAppName,
        WS_MINIMIZE|WS_OVERLAPPEDWINDOW,
        CW_USEDEFAULT,
        CW_USEDEFAULT,
        CW_USEDEFAULT,
        CW_USEDEFAULT,
        NULL,
        NULL,
        hInst,
        NULL
    );
    // Run In a Minimized Window
    ShowWindow (hWnd, SW_SHOWMINIMIZED) ;
    UpdateWindow(hWnd);


return 0L;
}

LONG FAR PASCAL InitWindow(HWND hWnd)
{
    // set defaults

    wNumKids   = 0;           // no children
    wSibling   = 0;
    wSequence  = 0;
    STARTED    = FALSE;
    DOSEXIT    = FALSE;
    WAITCHILD  = FALSE;
    WAITTIME   = FALSE;
    WAITFILE   = FALSE;

    hMenu =  GetSystemMenu(hWnd,FALSE);
    AppendMenu(hMenu,MF_SEPARATOR,0,(LPSTR)NULL);
    AppendMenu (hMenu, MF_STRING, IDM_ABOUT, "&About WinRobot...");
    if(FileExists("WINROBOT.HLP")==TRUE)
    {
      AppendMenu (hMenu, MF_STRING, IDM_HELP, "&WinRobot Help...");
    }
    if(szArgs[0]!=0)PostMessage(hWnd,WM_COMMAND,IDM_STARTUP,0L);
    else PostMessage(hWnd,WM_COMMAND,IDM_ABOUT,0L);
    return 0L ;

}

LONG FAR PASCAL StartUp(HWND hWnd)
{
    int i,j;
    unsigned char *hourptr, *minptr;
    unsigned long ulToday, ulRegisterBy;

    REGISTERED= FALSE;
    STARTED   = FALSE;
    DOSEXIT   = FALSE;
    WAITCHILD = FALSE;
    WAITTIME  = FALSE;
    WAITFILE  = FALSE;
    DOSCODE   = 0L;
    wStartHour   = 0;
    wStartMinute = 0;

    // shareware distribution of July 1995 finished prototype

    // check today's date for registrations that are pastdue
    // registration date must be found and in range
    // or user name is blanked.


    _dos_getdate(&logdate);
    wsprintf(szLogSection,"%00004d%002d%002d",
                           logdate.year,logdate.month,logdate.day);

    // but check first for an online registration
    // and return without going further when complete
    if(szIniFile[0]!=0 && strcmpi(szArgs,"REGISTER")==0)
    {
      szMessBuf[0]=0;
      GetPrivateProfileString("register","name","",szMessBuf,MAXNAME,
                            szIniFile);
      if (szMessBuf[0]==0) {
        getcwd(szDirPath,MAXNAME);     // get the current directory name
        i=0;
        for(;;)
        {
          if(szDirPath[i]==0)
          {
           if(i>0)
           {
             if(szDirPath[i-1]!=92)
             {
              szDirPath[i]=92;        // end the directory name in a slash
              szDirPath[i+1]=0;
             }
           }
           break;
          }
          i++;
        }
        strcat(szDirPath,szIniFile);
        GetPrivateProfileString("register","name","",szMessBuf,MAXNAME,
                            szDirPath);
      }

      if(szMessBuf[0]!=0)
      {

        // add the registration info into win.ini
        WriteProfileString(lpRobotKey,lpRegisterTo,szMessBuf);
        WriteProfileString(lpRobotKey,lpRegisterBy,szLogSection);

         wsprintf(szLogSection,
                 "This copy of WinRobot is registered to %s.\n\n%s",
                 szMessBuf,lpThanks);
         MessageBox(hWnd,szLogSection,szAppName,MB_ICONINFORMATION);
      }
      else
      {
         wsprintf(szMessBuf,
                  "The required registration info was not found.\n\n%s",
                  lpNoThanks);
          MessageBox(hWnd,szMessBuf,szAppName,MB_ICONHAND);
      }
      DestroyWindow(hWnd);
      return 0L;

    }

    ulToday = atol(szLogSection);

    szMessBuf[0]=0;
    GetProfileString(lpRobotKey,lpRegisterBy,"",szMessBuf,MAXNAME);
    ulRegisterBy = atol(szMessBuf);

    // allow a 30 year span for the life of WINROBOT
    if(ulRegisterBy < 19960801L || ulRegisterBy > 20260801L)
    {
      logdate.month += 1;
      if(logdate.month > 12)
      {
        logdate.month   = 1;
        logdate.year   += 1;
      }
      wsprintf(szLogSection,"%00004d%002d%002d",
                            logdate.year,logdate.month,logdate.day);
      ulRegisterBy = atol(szLogSection);    // set-up registration date
      szMessBuf[0]=0;                       // blank the user name

      WriteProfileString(lpRobotKey,lpRegisterTo,szMessBuf);
      WriteProfileString(lpRobotKey,lpRegisterBy,szLogSection);
    }

    // if the registered user name is filled-in
    // then assume that they have registered...
    // ignore the date...

    szMessBuf[0]=0;
    GetProfileString(lpRobotKey,lpRegisterTo,"",szMessBuf,MAXNAME);
    if(szMessBuf[0]==0)
    {

      // if we have expired we still run...
      if(ulToday>ulRegisterBy)
      {
        wsprintf(szMessBuf,
                "This unregistered copy of WinRobot has expired!!! "
                "Unregistered users are not supported.\n\n%s",
                lpNoThanks);
        MessageBox(hWnd,szMessBuf,szAppName,MB_ICONHAND);
      }
      else {
        wsprintf(szMessBuf,
               "This copy of WinRobot is unregistered. "
               "Unregistered users are not supported.\n\n%s",
               lpNoThanks);
        MessageBox(hWnd,szMessBuf,szAppName,MB_ICONINFORMATION);
      }
    }
   else
   {
     REGISTERED = TRUE;

     // wsprintf(szLogSection,
     //    "This copy of WinRobot is registered to %s.\n\n%s",
     //     szMessBuf,lpThanks);
     // MessageBox(hWnd,szLogSection,szAppName,MB_ICONINFORMATION);
    }


    // Read/Write user profile
    GetUserProfile(hWnd);
    LogEntry(szArgs);

    // initial check for file events before starting
    if(bUseQuestion==TRUE)StopQuestion(hWnd,szQuestionFile,szAnswerFile);
    if(bUseStop==TRUE)if(StopFile(hWnd)==TRUE)return 0L;

    // Read user script
    if(GetUserScript(hWnd)==FALSE)
    {
      wsprintf(szMessBuf,"Unable to open script file %s.\n\n"
                         "Unable to continue.",szArgs);
      MessageBox(hWnd,szMessBuf,szAppName,MB_ICONHAND);
      LogEntry("Unable to open Script File");
      DestroyWindow(hWnd);
      return 0L;
    }

    szMessBuf[0]=0;
    GetPrivateProfileString(lpEvents,lpStartTime,"",szMessBuf,MAXNAME,
                            szIniFile);
    if(szMessBuf[0]!=0)
    {
        hourptr=(char *)&szMessBuf[0];
        minptr=(char *)&szMessBuf[0];
        i=0;
        for(;;)
        {
          i++;
          if(szMessBuf[i]==0)break;
          if(szMessBuf[i]==':')
          {
           i++;
           minptr=(char *)&szMessBuf[i];
           break;
          }
        }
        wStartHour    = atoi(hourptr);
        wStartMinute  = atoi(minptr);
        if(wStartHour>23||wStartMinute>59)
        {
          wsprintf(szMessBuf,"Invalid StartTime %d:002%d",
                   wStartHour,wStartMinute);
          LogEntry(szMessBuf);
          wsprintf(szMessBuf,
                  "Invalid StartTime %d:%002d in %s.\n\n"
                  "Unable to continue.",
                  wStartHour,wStartMinute,
                  szIniFile);
            MessageBox(hWnd,szMessBuf,szAppName,MB_OK);
            DestroyWindow(hWnd);
            return 0L;
        }
        wTarget = (wStartHour * 60)+wStartMinute;
        _dos_gettime(&logtime);
        wCurrent =  0;
        wCurrent += logtime.hour;
        wCurrent *= 60;
        wCurrent += logtime.minute;
        if(wCurrent >  wTarget)
        {
           wsprintf(szMessBuf,"StartTime %d:%002d is past Current Time",
                    wStartHour,wStartMinute);
           LogEntry(szMessBuf);

           wsprintf(szMessBuf,
                    "StartTime %d:%002d in %s "
                    "is past Current Time %d:%002d.\n\n"
                    "Unable to continue.",
                    wStartHour,wStartMinute,
                    szIniFile,
                    logtime.hour,logtime.minute);
           MessageBox(hWnd,szMessBuf,szAppName,MB_ICONHAND);
           DestroyWindow(hWnd);
        }
        if(wCurrent < wTarget)
        {
          wsprintf(szMessBuf,
          "WinRobot Event at %d:%002d",wStartHour,wStartMinute);
          SetWindowText(hWnd,szMessBuf);
          WAITTIME = TRUE;
          LogEntry(szMessBuf);
          SetTimer (hWnd, IDM_TIME,(UINT)10,NULL);
          return 0L;
        }
     }
     else
     {
       szMessBuf[0]=0;
       GetPrivateProfileString(lpFiles,lpStartFile,"",szMessBuf,MAXNAME,
                                szIniFile);
       if(szMessBuf[0]!=0)
       {
         strcpy(szStartFile,szMessBuf);
         LogEntry(szStartFile);
         if(FileExists(szStartFile)==FALSE)
         {

           wsprintf(szMessBuf,"%s: %s",lpStartFile,szStartFile);
           SetWindowText(hWnd,szMessBuf);
           WAITFILE = TRUE;
           LogEntry("Waiting for StartFile");
           SetTimer (hWnd, IDM_FILE,(UINT)10,NULL);
           return 0L;
         }
       }
     }

    // if we have got to here, we are processing in immediate mode
    // so execute first app in list
    PostMessage(hWnd,WM_COMMAND,IDM_NEXT,0L);

return 0L;
}

LONG FAR PASCAL WaitStartTime(HWND hWnd)
{

    WAITTIME = FALSE;
    KillTimer(hWnd,IDM_TIME);
    if(bUseStop==TRUE)if(StopFile(hWnd)==TRUE)return 0L;
    wTarget = (wStartHour * 60)+wStartMinute;
    _dos_gettime(&logtime);
    wCurrent =  0;
    wCurrent += logtime.hour;
    wCurrent *= 60;
    wCurrent += logtime.minute;
    if(wCurrent < wTarget)
    {
       WAITTIME = TRUE;
       SetTimer (hWnd, IDM_TIME,(UINT)30000, NULL);return 0L;
    }
    LogEntry("StartTime Event Occurred");
    PostMessage(hWnd,WM_COMMAND,IDM_NEXT,0L);

return 0L;
}

LONG FAR PASCAL WaitStartFile(HWND hWnd)
{
    WAITFILE = FALSE;
    KillTimer(hWnd,IDM_FILE);
    if(bUseStop==TRUE)if(StopFile(hWnd)==TRUE)return 0L;
    if(FileExists(szStartFile)==FALSE)
    {
       WAITFILE = TRUE;
       SetTimer (hWnd, IDM_FILE,MAXDELAY,NULL);return 0L;
    }
    LogEntry("StartFile Event Occurred");
    PostMessage(hWnd,WM_COMMAND,IDM_NEXT,0L);

return 0L;
}



LONG FAR PASCAL NextCommand(HWND hWnd)
{
    int i,j,iShow;
    unsigned char c;
    // check for keywords
    WAITCHILD = FALSE;
    STARTED   = FALSE;
    WAITTIME  = FALSE;
    WAITFILE  = FALSE;
    FORCEAPP  = FALSE;
    iShow     = SW_SHOW;

    if(bUseQuestion==TRUE)StopQuestion(hWnd,szQuestionFile,szAnswerFile);
    if(bUseStop==TRUE)if(StopFile(hWnd)==TRUE)return 0L;

    if(DEBUG==TRUE)LogEntry("Begin Process");
    if(DEBUGFILE == TRUE)CopyDebugFile();
    wRetries  = 0;


    for(;;)
    {
       // strip labels, white space, etc...
       // if we reach the end of the session, terminate the process
       for(;;)
       {
           if(wSibling<wNumKids)
           {
             c = szArgList[wSibling][0];
             lpszChild = (unsigned char *)&szArgList[wSibling][0];
             if(WinEcho(hWnd,lpszChild)==TRUE)
             {
                LogEntry(lpszChild);
                wSibling+=1;
                continue;
             }
             if(c==':' || c == ';' || c < '0')wSibling+=1;
             else break;
             // log comment lines as well as commands
             if(c!=0 && c!=':')LogEntry((char *)&szArgList[wSibling-1][0]);
           }
           if(wSibling<wNumKids)continue;
           LogEntry("END OF SESSION - Begin Termination Process");
           DestroyWindow(hWnd);
           return 0L;
       }
       // do the normal type of dos commands...
       lpszChild = (unsigned char *)&szArgList[wSibling][0];
       if(DosCommand(lpszChild)==TRUE)
       {
        LogEntry(lpszChild);
        wSibling+=1;
        continue;
       }

       // no IFs or GOTOs... don't waste time...
       if(toupper(c)!='I' && toupper(c)!='G')break;

       // Additional Branch logic - July 1995
       // Supplemented if exist/if not exist logic block
       // with DOS Commands...
       // Formerly Goto's only were allowed

       // check for gotos... strip comments
       szLabel[0] = 0;
       szTemp[0]  = 0;
       szTempCommand[0] = 0;

       // check for label oriented commands.
       // 1. If not exist
       // 2. If exist
       // 3. Goto

       for(i=0;i<13;i++)szMessBuf[i]=szArgList[wSibling][i];
       szMessBuf[13]=0;
       if(strcmpi(szMessBuf,"if not exist ")==0)
       {
           // 1a. get the file name
           lpszChild = (unsigned char *)&szArgList[wSibling][13];
           i=0;
           szTemp[0] = 0;
           for(;;)
           {
            if(*lpszChild==32||*lpszChild==0)break;
            szTemp[i]  =*lpszChild;
            szTemp[i+1]=0;
            *lpszChild++;i++;
           }

           // July 17, 1995 - do this first
           // =============================
           if(FileExists(szTemp)==TRUE)  // loop to the top again...
           {
            lpszChild = (unsigned char *)&szArgList[wSibling][0];
            wsprintf(szMessBuf,"%s",lpszChild);
            LogEntry(szMessBuf);
            wSibling+=1; continue;
           }

           // 1b. get the label name (jump the goto)
           while(*lpszChild==32)*lpszChild++;    // space

           // July 16, 1995 allow conditional DOS commands added
           // ==================================================
           i=0;
           szTempCommand[0]=0;
           while(*lpszChild>32)
           {
            szTempCommand[i]  =*lpszChild;
            szTempCommand[i+1]=0;
            *lpszChild++;i++;
           }

           // if this is not a goto it must be a DOS command
           // we break out of this inner loop if it is bogus...
           if(strcmpi(szTempCommand,"GOTO")!=0)
           {
            if(strcmpi(szTempCommand,"GOSUB")!=0)
            {
             strcat(szTempCommand,lpszChild);
             lpszChild = (unsigned char *)&szArgList[wSibling][0];
             if(DosCommand(szTempCommand)==TRUE)
             {
               LogEntry(lpszChild);
               wSibling+=1;
               continue;
             }
             break;
            }
            iSaveSibling = wSibling;
           }
           // July 16, 1995 allow conditional DOS commands added
           // ==================================================

           while(*lpszChild==32)*lpszChild++;    // space
           szLabel[0]=':';
           szLabel[1]= 0;
           i=1;
           for(;;)
           {
            if(*lpszChild==32||*lpszChild==0)break;
            szLabel[i]  =*lpszChild;
            szLabel[i+1]=0;
            *lpszChild++;i++;
           }
           wsprintf(szMessBuf,"%s",(unsigned char *)&szArgList[wSibling][0]);
           LogEntry(szMessBuf);
       }
       else
       {
           szMessBuf[9]=0;
           if(strcmpi(szMessBuf,"if exist ")==0)
           {
               // 1a. get the file name
               lpszChild = (unsigned char *)&szArgList[wSibling][9];
               i=0;
               for(;;)
               {
                if(*lpszChild==32||*lpszChild==0)break;
                szTemp[i]  =*lpszChild;
                szTemp[i+1]=0;
                *lpszChild++;i++;
               }

               // July 16, 1995 do this first
               if(FileExists(szTemp)==FALSE)  // loop to the top again...
               {
                lpszChild = (unsigned char *)&szArgList[wSibling][0];
                wsprintf(szMessBuf,"%s",lpszChild);
                LogEntry(szMessBuf);
                wSibling+=1; continue;
               }

               // 1b. get the label name (jump the goto)
               while(*lpszChild==32)*lpszChild++;    // space

               // July 16, 1995 allow conditional DOS commands added
               // ==================================================
               i=0;
               szTempCommand[0]=0;
               while(*lpszChild>32)
               {
                szTempCommand[i]  =*lpszChild;
                szTempCommand[i+1]=0;
                *lpszChild++;i++;
               }

               // if this is not a goto it must be a DOS command
               // we break out of this inner loop if it is...
               if(strcmpi(szTempCommand,"GOTO")!=0)
               {
                if(strcmpi(szTempCommand,"GOSUB")!=0)
                {
                 strcat(szTempCommand,lpszChild);
                 lpszChild = (unsigned char *)&szArgList[wSibling][0];
                 if(DosCommand(szTempCommand)==TRUE)
                 {
                   LogEntry(lpszChild);
                   wSibling+=1;
                   continue;
                 }
                 break;
                }
                iSaveSibling = wSibling;
               }
               // July 16, 1995 allow conditional DOS commands added
               // ==================================================

               while(*lpszChild==32)*lpszChild++;    // space
               szLabel[0]=':';
               szLabel[1]= 0;
               i=1;
               for(;;)
               {
                if(*lpszChild==32||*lpszChild==0)break;
                szLabel[i]  =*lpszChild;
                szLabel[i+1]=0;
                *lpszChild++;i++;
               }
               wsprintf(szMessBuf,"%s",
                        (unsigned char *)&szArgList[wSibling][0]);
               LogEntry(szMessBuf);
           }

      }
      // not a conditional... (maybe a goto or a gosub... if not move on.)
      if(szLabel[0]!=':')
      {
        szMessBuf[4] = 0;
        if(strcmpi(szMessBuf,"gosu")==0)
        {
          szLabel[0] =  ':';
          for(i=1;i<(MAXLABEL-1);i++)
           {
             szLabel[i]=szArgList[wSibling][i+5];szLabel[i+1]=0;
           }
          wsprintf(szMessBuf,"gosub %s",(char *)&szLabel[1]);
          LogEntry(szMessBuf);
          iSaveSibling = wSibling;
        }
        else
        {
         if(strcmpi(szMessBuf,"goto")!=0)break;
         szLabel[0] =  ':';
         for(i=1;i<(MAXLABEL-1);i++)
         {
          szLabel[i]=szArgList[wSibling][i+4];szLabel[i+1]=0;
         }
         wsprintf(szMessBuf,"goto %s",(char *)&szLabel[1]);
         LogEntry(szMessBuf);
        }
      }

      // goto the label
      for(i=0;i<wNumKids;i++)
      {
        for(j=0;j<MAXNAME;j++)szMessBuf[j]=szArgList[i][j];
        if(strcmpi(szMessBuf,szLabel)==0)
        {
          LogEntry(szMessBuf);
          wSibling = i;
          break;
        }
      }
      if(strcmpi(szMessBuf,szLabel)!=0)
        LogEntry("Label Not Found! Continuing!");
      wSibling+=1;         // go one past the label and loop...
    }

    // If we are here our command is not branch logic

    // Executable Command 1 - Check for an Exit Command...
    for(i=0;i<4;i++)szMessBuf[i]=szArgList[wSibling][i];
    szMessBuf[4]=0;
    if(strcmpi(szMessBuf,"EXIT")==0)
    {
       LogEntry("EXIT Keyword Found - Begin Termination Process");
       lpszChild = (unsigned char *)&szArgList[wSibling][4];
       for(;;)
       {
        if(*lpszChild==32||*lpszChild=='=')*lpszChild++;
        else break;
       }
       DOSCODE = atol(lpszChild);
       DOSEXIT = TRUE;
       DestroyWindow(hWnd);
       return 0L;
    }

    for(i=0;i<5;i++)szMessBuf[i]=szArgList[wSibling][i];
    szMessBuf[5]=0;
    if(strcmpi(szMessBuf,"CHILD")==0)
    {
       LogEntry("CHILD Keyword Found - Begin Child Process");
       i=0;
       for(;;)
       {
           c=szArgList[wSibling][i+5];
           if(c==32||c=='=')i++;
           else break;
       }
       j=0;
       do{
          c=szArgList[wSibling][i+5];
          szChildText[j]=toupper(c);
          i++;j++;
          }while(szChildText[j-1]!=0);
        wSibling+=1;
        if(wSibling>=wNumKids)
        {
         LogEntry("Child Process Cancelled - Unexpected End Of Script");
         DestroyWindow(hWnd);
         return 0L;
        }
       WAITCHILD = TRUE;
    }

    if(WAITCHILD==FALSE)
    {
    for(i=0;i<4;i++)szMessBuf[i]=szArgList[wSibling][i];
    szMessBuf[4]=0;
    if(strcmpi(szMessBuf,"SHOW")==0)
    {
       i=0;
       for(;;)
       {
           c=szArgList[wSibling][i+4];
           if(c==32||c=='=')i++;
           else break;
       }
       j=0;
       do{
          c=szArgList[wSibling][i+4];
          szChildText[j]=toupper(c);
          i++;j++;
          }while(szChildText[j-1]!=0);
        wSibling+=1;
        if(wSibling>=wNumKids)
        {
         LogEntry("SHOW KEYWORD Cancelled - Unexpected End Of Script");
         DestroyWindow(hWnd);
         return 0L;
        }

       if(strcmpi(szChildText,"MINIMIZE")==0)iShow=SW_SHOWMINIMIZED;
       if(strcmpi(szChildText,"MAXIMIZE")==0)iShow=SW_SHOWMAXIMIZED;
       if(strcmpi(szChildText,"NORMAL")==0)iShow=SW_NORMAL;
       if(strcmpi(szChildText,"HIDE")==0)iShow=SW_HIDE;
       strcat(szChildText," - Show Application Window");
       LogEntry(szChildText);
       szChildText[0]=0;
      }
    }

    if(WAITCHILD==FALSE && iShow==SW_SHOW)
     {
      for(i=0;i<5;i++)szMessBuf[i]=szArgList[wSibling][i];
      szMessBuf[5]=0;
      if(strcmpi(szMessBuf,"FORCE")==0)
      {
        wSibling+=1;
        if(wSibling>=wNumKids)
        {
         LogEntry("FORCE KEYWORD Cancelled - Unexpected End Of Script");
         DestroyWindow(hWnd);
         return 0L;
        }

       LogEntry("Force Application - Show Maximized");
       szChildText[0]=0;
       iShow=SW_SHOWMAXIMIZED;
       FORCEAPP=TRUE;
       }
    }

    lpszChild = (unsigned char *)&szArgList[wSibling][0];
    LogEntry(lpszChild);
    if((hInstChild=WinExec(lpszChild,iShow))<32)
       {
         WAITCHILD = FALSE;
         wsprintf(szMessBuf,
                  "Unable to execute process %s.\n\n"
                  "WinExec returned %d\n (below 32)"
                  "Unable to continue.",lpszChild,hInstChild);
         MessageBox(hWnd,szMessBuf,szAppName,MB_OK);
         LogEntry("Unable to execute");
         DestroyWindow(hWnd);
         return 0L;
        }

    if(WAITCHILD==FALSE)
    {
       if((hModuleChild=GetModuleUsage(hInstChild))==0)
       {
            wsprintf(szMessBuf,
              "Cannot Identify process %s.\n\n"
              "Unable to continue.",lpszChild);
            MessageBox(hWnd,szMessBuf,szAppName,MB_OK);
            LogEntry("Cannot Identify Process - Try CHILD Keyword in Script");
            DestroyWindow(hWnd);
            return 0L;
       }
       if(GetModuleUsage(hInstChild)<hModuleChild)
       {
         ElapsedTime("Process End");
         if(bUseQuestion==TRUE)StopQuestion(hWnd,szQuestionFile,szAnswerFile);
         if(bUseStop==TRUE)if(StopFile(hWnd)==TRUE)return 0L;
         wSibling+=1;
         if(wSibling<wNumKids)PostMessage(hWnd,WM_COMMAND,IDM_NEXT,0L);
         else DestroyWindow(hWnd);
         return 0L;
      }
       wsprintf(szMessBuf,"WinRobot %s",lpszChild);
       SetWindowText(hWnd,szMessBuf);
       // set our timer callback to every 10 seconds
       // after our initial startup time of 10ms
       if(FORCEAPP==TRUE)
       {
          FORCEAPP=FALSE;
          hChild = GetNextWindow(hWnd,GW_HWNDNEXT);
          ShowWindow(hChild,SW_SHOWMAXIMIZED);
       }
       if(GetModuleUsage(hInstChild)<hModuleChild)
       {
         ElapsedTime("Process End");
         if(bUseQuestion==TRUE)StopQuestion(hWnd,szQuestionFile,szAnswerFile);
         if(bUseStop==TRUE)if(StopFile(hWnd)==TRUE)return 0L;
         wSibling+=1;
         if(wSibling<wNumKids)PostMessage(hWnd,WM_COMMAND,IDM_NEXT,0L);
         else DestroyWindow(hWnd);
         return 0L;
      }
       STARTED = TRUE;
       SetTimer (hWnd, IDM_TASK,10,NULL);
       return 0L;
    }

    // If we are waiting for the child to be launched by
    // a Runtime instead of directly (i.e. FOXPRO)
    // give the child process a chance to begin executing.
    // We shouldn't crowd the child since the window needs
    // a chance to open even if the child is launched immediately
    wsprintf(szMessBuf,"WinRobot %s",lpszChild);
    SetWindowText(hWnd,szMessBuf);
    LogEntry("Waiting for Visible Child Process");
    LogEntry(szChildText);
    SetTimer (hWnd, IDM_CHILD,(UINT)10,NULL);
    return 0L;

}


// Default Settings For The StopFile and QuestionFile Events
// Provide a Clean-Up of Drop Files from previous WinRobot File Events.

BOOL FAR PASCAL StopFile(HWND hWnd)
{
    BOOL bRetVal=FALSE;

    if((bRetVal=StopQuestion(hWnd,szStopFile,szAnswerFile))==TRUE)
              DestroyWindow(hWnd);

return bRetVal;
}

BOOL FAR PASCAL StopQuestion(HWND hWnd,LPSTR lpszInFile, LPSTR lpszOutFile)
{
    FILE *fp;
    int i,j;
    char szBuffer[MAXNAME];
    char szTbuf[MAXNAME];
    unsigned wStyle=MB_YESNO;
    BOOL bRetVal   =FALSE;

    if(FileExists(lpszInFile)==FALSE)return FALSE;
    if((fp=fopen(lpszInFile,"r"))==NULL)return FALSE;

    if(bPurgeAnswer==TRUE)
    {
      if(FileExists(szAnswerFile)==TRUE)remove(szAnswerFile);
    }

    LogEntry("File Event");
    LogEntry(lpszInFile);
    szTbuf[0]     =0;
    szMessBuf[0]  =0;
    if(fgets(szBuffer,127,fp)!=NULL)
    {
      if(toupper(szBuffer[0])=='O' && toupper(szBuffer[1])=='K')wStyle=MB_OK;
      if(fgets(szBuffer,127,fp)!=NULL)
      {
          i=0;
          strcpy(szTbuf,szBuffer);
          for(;;)
            {
              if(szTbuf[i]==0||szTbuf[i]==13||szTbuf[i]==10)
              {
                szTbuf[i]=0;break;
               }
               i++;
            }
            for(;;)
            {
              if(fgets(szBuffer,MAXNAME,fp)==NULL)break;
              i=strlen(szMessBuf);
              j=strlen(szBuffer);
              if((i+j)>256)break;
              strcat((char *)&szMessBuf[0],szBuffer);
            }
      }
    }
    fclose(fp);


    if(szTbuf[0]==0)
      strcpy(szTbuf,szAppName);

    if(szMessBuf[0]==0)
    {
     wsprintf(szMessBuf, "File Event %s.\n",lpszInFile);
    }
    strcpy(szBuffer,"set winanswer=Y");
    if(wStyle == MB_OK)
    {
       MessageBox(hWnd,szMessBuf,szTbuf,MB_OK);
    }
    else
    {
        if(MessageBox(hWnd,szMessBuf,szTbuf,MB_YESNO)==IDNO)
        {
            strcpy(szBuffer,"set winanswer=N");
            bRetVal = TRUE;
        }
    }

    if(bUseAnswer==TRUE)
    {
      if(lpszOutFile[0]!=0)
      {
        if((fp=fopen(lpszOutFile,"w"))!=NULL)
        {
          fprintf(fp,"%s\n",szBuffer);
          fclose(fp);
        }
      }
    }

    if(bPurgeQuestion==TRUE)
    {
      if(FileExists(szQuestionFile)==TRUE)remove(szQuestionFile);
    }
    if(bPurgeStop==TRUE)
    {
      if(FileExists(szStopFile)==TRUE)remove(szStopFile);
    }
    LogEntry(szBuffer);

return bRetVal;
}

// We have launched the application and are waiting for
// it to terminate and then to launch the next.
LONG FAR PASCAL TimerTask(HWND hWnd)
{
    unsigned char c;
    int j;

    // interval processing
    KillTimer(hWnd,IDM_TASK);
    STARTED = FALSE;

    
    // if we are not using the window text to test for
    // our active task and child task usage count
    // has dropped below what we started with
    // then we execute the next task in our list
    if(WAITCHILD==FALSE)
    {
      if(GetModuleUsage(hInstChild)<hModuleChild)
      {
         ElapsedTime("Process End");
         SetWindowText(hWnd,szAppName);
         if(bUseQuestion==TRUE)StopQuestion(hWnd,szQuestionFile,szAnswerFile);
         if(bUseStop==TRUE)if(StopFile(hWnd)==TRUE)return 0L;
         wSibling+=1;
         if(wSibling<wNumKids)PostMessage(hWnd,WM_COMMAND,IDM_NEXT,0L);
         else DestroyWindow(hWnd);
         return 0L;
      }
    }
    else
    {
       szChildCompare[0]=0;
       GetWindowText(hChild,szChildCompare,MAXPATH);
       j=0;
       while((c=szChildCompare[j])!=0)
       {
        szChildCompare[j]=toupper(c);j++;
       }
       if(strstr(szChildCompare,szChildText)==NULL)
       {
         hChild=GetActiveWindow();
         GetWindowText(hChild,szChildCompare,MAXPATH);
         j=0;
         while((c=szChildCompare[j])!=0)
         {
          szChildCompare[j]=toupper(c);j++;
         }
         if(strstr(szChildCompare,szChildText)==NULL)
         {
           hChild=GetNextWindow(hWnd,GW_HWNDNEXT);
           GetWindowText(hChild,szChildCompare,MAXPATH);
           while((c=szChildCompare[j])!=0)
           {
            szChildCompare[j]=toupper(c);j++;
            }
           if(strstr(szChildCompare,szChildText)==NULL)
           {
            ElapsedTime("Process End");
            WAITCHILD=FALSE;
            SetWindowText(hWnd,szAppName);
            if(bUseQuestion==TRUE)StopQuestion(hWnd,szQuestionFile,szAnswerFile);
            if(bUseStop==TRUE)if(StopFile(hWnd)==TRUE)return 0L;
            wSibling+=1;
            if(wSibling<wNumKids)
              PostMessage(hWnd,WM_COMMAND,IDM_NEXT,0L);
            else DestroyWindow(hWnd);
              return 0L;
            }
          }
        }
    }
    // set another timer and call ourselves back
    SetTimer (hWnd, IDM_TASK,MAXDELAY, NULL);
    STARTED = TRUE;
return 0L;
}


LONG FAR PASCAL WaitStartChild(HWND hWnd)
{
    int j;
    unsigned char c;

    STARTED = FALSE;
    KillTimer(hWnd,IDM_CHILD);
    szChildCompare[0]=0;
    hChild = GetActiveWindow();
    GetWindowText(hChild,szChildCompare,MAXPATH);

    j=0;
    while((c=szChildCompare[j])!=0)
     {
        szChildCompare[j]=toupper(c);j++;
     }

    // if the child ID string is a partial match
    // the next window is the one that we are waiting for
    // so now we can take over
    if(strstr(szChildCompare,szChildText)!=NULL)
    {
     LogEntry(szChildCompare);
     LogEntry("Found Child");
     SetTimer (hWnd, IDM_TASK,MAXDELAY, NULL);
     STARTED = TRUE;
     return 0L;
    }
    if(wRetries >= MAXRETRIES)
    {
       LogEntry(szChildText);
       WAITCHILD = FALSE;
       wsprintf(szMessBuf,"Retries to find child %s = %d.\n\n"
                          "Unable to continue.",
                           szChildText,wRetries);
       MessageBox(hWnd,szMessBuf,szAppName,MB_OK);
       LogEntry("Too many retries to find Child Process");
       DestroyWindow(hWnd);
       return 0L;

    }
    wRetries += 1;
    SetTimer (hWnd, IDM_CHILD,MAXWAIT, NULL);

return 0L;
}


BOOL FAR PASCAL GetUserScript(HWND hWnd)
{
    FILE *fp;
    int i, j, k;

    wNumKids  = 0;
    wSibling  = 0;

    if(FileExists(szArgs)==FALSE)return FALSE;
    if((fp=fopen(szArgs,"r"))==NULL)return FALSE;

    // count lines
    // but ignore empty lines...
    while(fgets(szArgs,MAXNAME,fp)!=NULL)
    {
        for(i=0;szArgs[i]!=0;i++)
        {
         if(szArgs[i]==10||szArgs[i]==13)szArgs[i]=0;
        }
        if(szArgs[0]!=0)wNumKids++;
    }
    if(wNumKids<1)
    {
        fclose(fp);
        return FALSE;
    }
    if(wNumKids>MAXARGS)
    {
        wNumKids=0;
        fclose(fp);
        wsprintf(szMessBuf,"Maximum number of lines (%d) exceeded!",MAXARGS);
        LogEntry(szMessBuf);
        return FALSE;
    }
    rewind(fp);

    // make the file list
    i=0;
    while(fgets(szArgs,MAXNAME,fp)!=NULL)
    {
      for(j=0;szArgs[j]!=0;j++)
      {
      if(szArgs[j]==9)szArgs[j]=32;                // strip tabs
      if(szArgs[j]==10||szArgs[j]==13)szArgs[j]=0; // strip lf-cr
      }
      if(szArgs[0]==0)continue;

      j=0;
      k=0;
      while(szArgs[k]==32)k++;         // trim leading white space
      for(;;)
      {                                // strip double blanks
        szArgs[j] = szArgs[k];
        if(szArgs[j]==0)break;
        if(szArgs[j]==32)
        {
            j++;
            while(szArgs[k]==32)k++;
            continue;
        }
        j++;
        k++;
      }
      if(j>0)
      {
        if(szArgs[j-1]==32)szArgs[j-1]=0;   // trim trailing white space
      }
      j=0;
      k=0;
      for(;;)                               // belt and suspenders
      {
        if(szArgs[j]!=32)break;j++;
      }

      for(;;)
      {
        if(szArgs[j]==0||szArgs[j]==13||szArgs[j]==10)
        {
           szArgList[i][k]=0;break;
        }
        szArgList[i][k]=szArgs[j];
        j++;k++;
        if(j<MAXNAME)continue;
        szArgList[i][k-1]=0;
        break;
      }
      i++;
    }
    fclose(fp);
    LogEntry("User Script Loaded");

return TRUE;
}

LONG FAR PASCAL GetUserProfile(HWND hWnd)
{
    // Certain user profile defaults can be set if they do not exist.
    // The following cannot since they affect immediate mode processing.
    // 1. Start Time
    // 2. Start File

    int i;
    LONG dwResult;
    unsigned char cPurgeLog,cUseLog;
    unsigned char cPurgeQuestion,cUseQuestion;
    unsigned char cPurgeAnswer,cUseAnswer;
    unsigned char cPurgeStop,cUseStop;

    // read the profile strings from the .INI file
    // if one exists..
    getcwd(szDirPath,MAXNAME);     // get the current directory name
    i=0;
    for(;;)
    {
      if(szDirPath[i]==0)
      {
        if(i>0)
        {
           if(szDirPath[i-1]!=92)
           {
            szDirPath[i]=92;        // end the directory name in a slash
            szDirPath[i+1]=0;
           }
        }
        break;
      }
      i++;
    }

    if(szIniFile[0]==0)wsprintf(szIniFile,"%sWINROBOT.INI",szDirPath);

    if(FileExists(szIniFile)==FALSE)
    {

       // write a header section
       WritePrivateProfileString(lpHeader,"Owner  :",
                   szAppName,szIniFile);
       WritePrivateProfileString(lpHeader,"Purpose:",
                  "User Definable Profile",szIniFile);

       // provide examples with explanations
       // options example section
       WritePrivateProfileString(lpExOptions,lpDelay,
                  "Process Termination Check Interval : 5-60 Seconds",
                   szIniFile);
       WritePrivateProfileString(lpExOptions,lpRetries,
                  "Child Process Launch Check Repeat : 1 or More Times",
                    szIniFile);
       WritePrivateProfileString(lpExOptions,lpWait,
                  "Child Process Launch Check Interval : 5-60 Seconds",
                    szIniFile);
       WritePrivateProfileString(lpExOptions,lpPurgeLog,
                  "Y or N - Yes or No - Purge Log Each Run",
                    szIniFile);
       WritePrivateProfileString(lpExOptions,lpUseLog,
                  "Y or N - Yes or No - Use Activity Log",
                    szIniFile);

       WritePrivateProfileString(lpExOptions,lpPurgeQuestion,
                  "Y or N - Yes or No - Purge QuestionFile When Found",
                    szIniFile);
       WritePrivateProfileString(lpExOptions,lpUseQuestion,
                  "Y or N - Yes or No - Respond To QuestionFile",
                    szIniFile);
       WritePrivateProfileString(lpExOptions,lpPurgeAnswer,
                  "Y or N - Yes or No - Purge AnswerFile When Found",
                    szIniFile);
       WritePrivateProfileString(lpExOptions,lpUseAnswer,
                  "N or Y - No or Yes - Create AnswerFile",
                    szIniFile);
       WritePrivateProfileString(lpExOptions,lpPurgeStop,
                  "Y or N - Yes or No - Purge StopFile When Found",
                    szIniFile);
       WritePrivateProfileString(lpExOptions,lpUseStop,
                  "Y or N - Yes or No - Respond To StopFile",
                    szIniFile);

       WritePrivateProfileString(lpExOptions,lpPause,
                  "Message To Echo During A WinRobot Pause",
                    szIniFile);
       WritePrivateProfileString(lpExOptions,lpAppName,
                  "Title Text for WinRobot Window Titles",
                    szIniFile);

       // files example section
       WritePrivateProfileString(lpExFiles,lpLogFile,
                  "Activity and Error Tracking Log",
                   szIniFile);
       WritePrivateProfileString(lpExFiles,lpQuestionFile,
                  "If File Exists Prompt For Input Using File",
                   szIniFile);
       WritePrivateProfileString(lpExFiles,lpAnswerFile,
                  "Batch File To Return Input From Question Prompt",
                    szIniFile);
       WritePrivateProfileString(lpExFiles,lpStopFile,
                  "Pause Or Terminate Script If File Exists",
                    szIniFile);
       WritePrivateProfileString(lpExFiles,lpStartFile,
                  "Do Not Process Script Until File Exists",
                    szIniFile);

       // events example section
       WritePrivateProfileString(lpExEvents,lpStartTime,
                  "HH:MM Event - Time Of Day To Execute Script",
                   szIniFile);

    }

    // for programming of WinRobot allow additional logging
    // if DEBUG = TRUE
    szMessBuf[0]=0;
    GetPrivateProfileString(lpOptions,lpDebug,"",szMessBuf,MAXNAME,
                             szIniFile);
    if(strcmpi(szMessBuf,"TRUE")==0)DEBUG = TRUE;


    // July 17, 1995 - added a debugging feature to allow incremental
    // copying of logfiles from child processes...

    szDebugFile[0] = 0;
    GetPrivateProfileString(lpFiles,lpDebugFile,"",szDebugFile,MAXNAME,
                             szIniFile);
    if(szDebugFile[0]!=0)DEBUGFILE = TRUE;
    szMessBuf[0]=0;
    GetPrivateProfileString(lpOptions,lpPurgeDebug,"",szMessBuf,MAXNAME,
                            szIniFile);
    if(toupper(szMessBuf[0])=='N')bPurgeDebug=FALSE;


    // read/write user options profile
    // set to default value if not in range and correct ini file entry
    szMessBuf[0]=0;
    GetPrivateProfileString(lpOptions,lpDelay,"",szMessBuf,MAXNAME,
                             szIniFile);
    dwResult=atol(szMessBuf);
    if(dwResult<5L||dwResult>60L)
    {
     wsprintf(szMessBuf,"%u",MAXDELAY/1000);
     WritePrivateProfileString(lpOptions,lpDelay,szMessBuf,
                                szIniFile);
     }
    else
     {
        MAXDELAY=(UINT)atoi(szMessBuf);
        MAXDELAY*=1000;
     }

    szMessBuf[0]=0;
    GetPrivateProfileString(lpOptions,lpRetries,"",szMessBuf,MAXNAME,
                            szIniFile);
    dwResult=atol(szMessBuf);
    if(dwResult<1L)
    {
     wsprintf(szMessBuf,"%d",MAXRETRIES);
     WritePrivateProfileString(lpOptions,lpRetries,szMessBuf,
                               szIniFile);
     }
    else
     {
        MAXRETRIES=atoi(szMessBuf);
     }


    szMessBuf[0]=0;
    GetPrivateProfileString(lpOptions,lpWait,"",szMessBuf,MAXNAME,
                            szIniFile);
    dwResult=atol(szMessBuf);
    if(dwResult<5L||dwResult>60L)
    {
     wsprintf(szMessBuf,"%u",MAXWAIT/1000);
     WritePrivateProfileString(lpOptions,lpWait,szMessBuf,
                               szIniFile);
     }
    else
     {
        MAXWAIT=(UINT)atoi(szMessBuf);
        MAXWAIT*=1000;
     }

    // by default the log file is purged after every session
    szMessBuf[0]=0;
    GetPrivateProfileString(lpOptions,lpPurgeLog,"",szMessBuf,MAXNAME,
                            szIniFile);
    cPurgeLog=toupper(szMessBuf[0]);
    if(cPurgeLog != 'Y' && cPurgeLog != 'N')
    {
     WritePrivateProfileString(lpOptions,lpPurgeLog,"Y",szIniFile);
     cPurgeLog = 'Y';
     }

    szMessBuf[0]=0;
    GetPrivateProfileString(lpOptions,lpUseLog,"",szMessBuf,MAXNAME,
                            szIniFile);
    cUseLog=toupper(szMessBuf[0]);
    if(cUseLog != 'Y' && cUseLog != 'N')
    {
     WritePrivateProfileString(lpOptions,lpUseLog,"Y",szIniFile);
     cUseLog = 'Y';
     }


    // set-up the Log File
    szLogFile[0] = 0;
    GetPrivateProfileString(lpFiles,lpLogFile,"",szLogFile,MAXNAME,szIniFile);
    if(szLogFile[0]==0)
    {
      wsprintf(szLogFile,"%sWINROBOT.LOG",szDirPath);
      WritePrivateProfileString(lpFiles,lpLogFile,szLogFile,szIniFile);
    }

  if(cUseLog   =='N')bUseLog   = FALSE;
  if(cPurgeLog =='N')bPurgeLog = FALSE;

  if(bPurgeLog==TRUE)if(FileExists(szLogFile) == TRUE)remove(szLogFile);

  if(cUseLog==TRUE)
  {
    if(FileExists(szLogFile)==FALSE)
    {
       WritePrivateProfileString(lpHeader,"Owner          :",
                   szAppName,szLogFile);
       WritePrivateProfileString(lpHeader,"Purpose        :",
                  "Activity and Error Tracking Log",szLogFile);
       WritePrivateProfileString(lpHeader,"Section Format :",
                  "Month-Day-Year",szLogFile);
       WritePrivateProfileString(lpHeader,"Entry Format   :",
                  "Hour:Minute:Second  Sequence=Log Entry Text",szLogFile);

    }
  }

  // create WinRobot session intialization entry
  if(REGISTERED == FALSE)
  {
    LogEntry("** Unregistered Copy **");
    LogEntry("This copy of WINROBOT will soon expire.");
    LogEntry("Register Today!");
  }
  LogEntry("** WinRobot Start Run **");


    wsprintf(szQuestionFile,"%sQUESTION.TXT",szDirPath);
    wsprintf(szAnswerFile,  "%sANSWER.BAT",  szDirPath);
    wsprintf(szStopFile,    "%sSTOPFILE.TXT",szDirPath);

    // read/write support file pathnames
    szMessBuf[0]=0;
    GetPrivateProfileString(lpFiles,lpQuestionFile,"",szMessBuf,MAXNAME,
                            szIniFile);
    if(szMessBuf[0]==0)
      WritePrivateProfileString(lpFiles,lpQuestionFile,szQuestionFile,
                                 szIniFile);
    else
      strcpy(szQuestionFile,szMessBuf);

    szMessBuf[0]=0;
    GetPrivateProfileString(lpFiles,lpAnswerFile,"",szMessBuf,MAXNAME,
                            szIniFile);
    if(szMessBuf[0]==0)
      WritePrivateProfileString(lpFiles,lpAnswerFile,szAnswerFile,
                                 szIniFile);
    else
      strcpy(szAnswerFile,szMessBuf);

    szMessBuf[0]=0;
    GetPrivateProfileString(lpFiles,lpStopFile,"",szMessBuf,MAXNAME,
                            szIniFile);
    if(szMessBuf[0]==0)
      WritePrivateProfileString(lpFiles,lpStopFile,szStopFile,
                                 szIniFile);
    else
      strcpy(szStopFile,szMessBuf);

    // The StartFile and StartTime affect normal use of immediate mode
    // processing and no default profiles are written for these.

    szMessBuf[0]=0;
    GetPrivateProfileString(lpOptions,lpPurgeQuestion,"",szMessBuf,MAXNAME,
                            szIniFile);
    cPurgeQuestion=toupper(szMessBuf[0]);
    if(cPurgeQuestion != 'Y' && cPurgeQuestion != 'N')
    {
     WritePrivateProfileString(lpOptions,lpPurgeQuestion,"Y",szIniFile);
     cPurgeQuestion = 'Y';
     }

    szMessBuf[0]=0;
    GetPrivateProfileString(lpOptions,lpUseQuestion,"",szMessBuf,MAXNAME,
                            szIniFile);
    cUseQuestion=toupper(szMessBuf[0]);
    if(cUseQuestion != 'Y' && cUseQuestion != 'N')
    {
     WritePrivateProfileString(lpOptions,lpUseQuestion,"Y",szIniFile);
     cUseQuestion = 'Y';
     }


    szMessBuf[0]=0;
    GetPrivateProfileString(lpOptions,lpPurgeAnswer,"",szMessBuf,MAXNAME,
                            szIniFile);
    cPurgeAnswer=toupper(szMessBuf[0]);
    if(cPurgeAnswer != 'Y' && cPurgeAnswer != 'N')
    {
     WritePrivateProfileString(lpOptions,lpPurgeAnswer,"Y",szIniFile);
     cPurgeAnswer = 'Y';
     }

    szMessBuf[0]=0;
    GetPrivateProfileString(lpOptions,lpUseAnswer,"",szMessBuf,MAXNAME,
                            szIniFile);
    cUseAnswer=toupper(szMessBuf[0]);
    if(cUseAnswer != 'Y' && cUseAnswer != 'N')
    {
     WritePrivateProfileString(lpOptions,lpUseAnswer,"N",szIniFile);
     cUseAnswer = 'N';
     }

    szMessBuf[0]=0;
    GetPrivateProfileString(lpOptions,lpPurgeStop,"",szMessBuf,MAXNAME,
                            szIniFile);
    cPurgeStop=toupper(szMessBuf[0]);
    if(cPurgeStop != 'Y' && cPurgeStop != 'N')
    {
     WritePrivateProfileString(lpOptions,lpPurgeStop,"Y",szIniFile);
     cPurgeStop = 'Y';
     }

    szMessBuf[0]=0;
    GetPrivateProfileString(lpOptions,lpUseStop,"",szMessBuf,MAXNAME,
                            szIniFile);
    cUseStop=toupper(szMessBuf[0]);
    if(cUseStop != 'Y' && cUseStop != 'N')
    {
     WritePrivateProfileString(lpOptions,lpUseStop,"Y",szIniFile);
     cUseStop = 'Y';
     }

    // set the globals for the user file profiles
    if(cUseQuestion   == 'N')bUseQuestion   = FALSE;
    if(cPurgeQuestion == 'N')bPurgeQuestion = FALSE;
    if(cUseAnswer     == 'Y')bUseAnswer     = TRUE;
    if(cPurgeAnswer   == 'N')bPurgeAnswer   = FALSE;
    if(cUseStop       == 'N')bUseStop       = FALSE;
    if(cPurgeStop     == 'N')bPurgeStop     = FALSE;

    // Clean-Up old drop files if we find any and if our
    // settings say that we should...
    if(bPurgeQuestion==TRUE)if(FileExists(szQuestionFile))remove(szQuestionFile);
    if(bPurgeAnswer==TRUE)if(FileExists(szAnswerFile))remove(szAnswerFile);
    if(bPurgeStop==TRUE)if(FileExists(szStopFile))remove(szStopFile);

    szMessBuf[0]=0;
    GetPrivateProfileString(lpOptions,lpPause,"",szMessBuf,MAXNAME,
                            szIniFile);
    if(szMessBuf[0]!=0)strcpy(szPauseBuf,szMessBuf);
    else WritePrivateProfileString(lpOptions,lpPause,szPauseBuf,szIniFile);

    szMessBuf[0]=0;
    GetPrivateProfileString(lpOptions,lpAppName,"",szMessBuf,MAXNAME,
                            szIniFile);
    if(szMessBuf[0]!=0)
    {
        strcpy(szAppName,szMessBuf);
        SetWindowText(hWnd,szMessBuf);
          
    }
    else
    {
        WritePrivateProfileString(lpOptions,lpAppName,szAppName,szIniFile);
    }

    LogEntry(szIniFile);
    LogEntry("Get-Set User Profile");


return 0L;
}

LONG FAR PASCAL LogEntry(LPSTR lpszLogEntry)
{

    // allow optional no logging of activities
    if(bUseLog==FALSE)return 0L;

// Use the .INI file format as the format for the log
// Use Today's Date for The Log Section     - [Month-Day-Year]
// Use The Current Time For The Section Key - Hour:Minute:Second Sequence=
// Use The Log File That is Specified In The .INI File

    _dos_getdate(&logdate);
    _dos_gettime(&logtime);
    wSequence+=1;
    wsprintf(szLogSection,"%002d-%002d-%00004d",
                          logdate.month,logdate.day,logdate.year);
    wsprintf(szLogKey,"%002d:%002d:%002d %5d",
                          logtime.hour,logtime.minute,logtime.second,wSequence);
    WritePrivateProfileString(szLogSection,szLogKey,lpszLogEntry,
                           szLogFile);
return 0L;
}

// I added this command to copy incremental files that are created
// by an external application to a saved file for analysis purposes
LONG FAR PASCAL CopyDebugFile()
{
    if(DEBUGFILE==FALSE) return 0L;
    if(FileExists(szDebugFile)==FALSE)return 0L;
    wsprintf(szSource,"%s",szDebugFile);

    _dos_getdate(&logdate);
    _dos_gettime(&logtime);
    wsprintf(szDest,"%002d%002d%002d%002d.%002d$",
                     logdate.month,logdate.day,
                     logtime.hour,logtime.minute,logtime.second);
    hfSource =LZOpenFile(szSource,&ofSource,OF_READ);
    hfDest =LZOpenFile(szDest,&ofDest,OF_CREATE);
    LZCopy(hfSource,hfDest);
    LZClose(hfSource);
    LZClose(hfDest);
    if(bPurgeDebug == TRUE)
    {
      if(FileExists(szDest)==TRUE)remove(szSource);
    }
return 0L;
}



BOOL FAR PASCAL SysCommand(WORD wParam,HWND hWnd)
{
        // hook the system menu for our help procedure...
        // also foil attempts to Maximize or Restore

        if(wParam==IDM_HELP)
        {
           HelpProc(hWnd);
           return FALSE;
        }
        if(wParam==IDM_ABOUT)
        {
           wsprintf(szMessBuf,"%s See user profile %s.",lpszUsage,szIniFile);
           MessageBox(hWnd,szMessBuf,szAppName,MB_OK);
           return FALSE;
        }

        if((wParam &0xfff0)==SC_MAXIMIZE)
        {
            MessageBeep(-1);
            return FALSE;
        }
        if((wParam &0xfff0)==SC_RESTORE)
        {
            MessageBeep(-1);
            return FALSE;
        }

return TRUE;
}
 
LONG FAR PASCAL AboutProc(HWND hWnd)
{
    // Read/Write user profile.
    // Then Display Usage Help.
    GetUserProfile(hWnd);
    HelpProc(hWnd);
    HELPACTIVE = FALSE;
    LogEntry("About WinRobot");
    DestroyWindow(hWnd);

return 0L;
}

LONG FAR PASCAL HelpProc(HWND hWnd)
{
    if(FileExists("WINROBOT.HLP")==TRUE)
    {
      HELPACTIVE = TRUE;
      HELPACTIVE = WinHelp(hWnd,"WINROBOT.HLP",HELP_CONTENTS,0L);
    }
    else
    {
      wsprintf(szMessBuf,"%s See user profile %s.",lpszUsage,szIniFile);
      MessageBox(hWnd,szMessBuf,szAppName,MB_OK);
    }

return 0L;
}
