' Examples for using the VBPRINT.DLL
' Written by Robert Simpson (Black Castle Software, LLC)
' Released to the public domain on 05/23/1996.

DefInt I
DefLng L
DefStr S

Option Explicit

' Flags to use in the dmFields section of the VBDEVMODE

Global Const DM_IN_BUFFER = 8
Global Const DM_IN_PROMPT = 4
Global Const DM_OUT_BUFFER = 2
Global Const DM_OUT_DEFAULT = 1
Global Const DM_ORIENTATION = &H1
Global Const DM_PAPERSIZE = &H2
Global Const DM_PAPERLENGTH = &H4
Global Const DM_PAPERWIDTH = &H8
Global Const DM_SCALE = &H10
Global Const DM_COPIES = &H100
Global Const DM_DEFAULTSOURCE = &H200
Global Const DM_PRINTQUALITY = &H400
Global Const DM_COLOR = &H800
Global Const DM_DUPLEX = &H1000
Global Const DM_YRESOLUTION = &H2000
Global Const DM_TTOPTION = &H4000

' Here is the VB DEVMODE that should be used in all calls to this DLL requiring a DEVMODE structure:

Type DEVMODE_TYPE
  dmDeviceName As String * 32
  dmSpecVersion As Integer
  dmDriverVersion As Integer
  dmSize As Integer
  dmDriverExtra As Integer
  dmFields As Long
  dmOrientation As Integer
  dmPaperSize As Integer
  dmPaperLength As Integer
  dmPaperWidth As Integer
  dmScale As Integer
  dmCopies As Integer
  dmDefaultSource As Integer
  dmPrintQuality As Integer
  dmColor As Integer
  dmDuplex As Integer
  dmYResolution As Integer
  dmTTOption As Integer
  dmPrivate As String
End Type

'  The DEVMODE_TYPE structure in VB is essentially a base DEVMODE structure with a dynamic
'  string attached to the end (the C version is directly below, named VBDEVMODE) which
'  holds the printer's private data (if there is any).

Type BINNAMES_TYPE
  sName As String * 24
End Type

Type ENUMRESOLUTIONS_TYPE
  xdpi As Long
  ydpi As Long
End Type

Type FILEDEPENDENCIES_TYPE
  sFilename As String * 64
End Type

Type PAPERNAMES_TYPE
  sName As String * 64
End Type

Type PAPERSIZE_TYPE
  x As Integer
  y As Integer
End Type

Declare Function VBGetPrinters Lib "vbprint.dll" () As String
Declare Function VBGetDriverFromName Lib "vbprint.dll" (printername As String) As String
Declare Function VBSetDefPrinter Lib "vbprint.dll" (printername As String) As Integer
Declare Function VBGetDefPrinter Lib "vbprint.dll" () As String
Declare Function VBExtDeviceMode Lib "vbprint.dll" (ByVal hWnd As Integer, printername As String, inDEV As DEVMODE_TYPE, outDev As DEVMODE_TYPE, ByVal fMode As Integer) As Integer
Declare Function VBDevModeToStr Lib "vbprint.dll" (inDEV As DEVMODE_TYPE) As String
Declare Function VBStrToDevMode Lib "vbprint.dll" (dmString As String, outDev As DEVMODE_TYPE) As Integer
Declare Function VBDeviceCapabilities Lib "vbprint.dll" (printername As String, ByVal iCap As Integer, lpStr As Any, inDEV As DEVMODE_TYPE) As Long
Declare Function VBResetDC Lib "vbprint.dll" (ByVal hDC As Integer, outDev As DEVMODE_TYPE) As Integer

' orientation selections
Global Const DMORIENT_PORTRAIT = 1
Global Const DMORIENT_LANDSCAPE = 2

' paper selections
'  Warning: The PostScript driver mistakingly uses DMPAPER_ values between
' *  50 and 56.  Don't use this range when defining new paper sizes.

Global Const DMPAPER_LETTER = 1               ' Letter 8 1/2 x 11 in
Global Const DMPAPER_FIRST = DMPAPER_LETTER
Global Const DMPAPER_LETTERSMALL = 2          ' Letter Small 8 1/2 x 11 in
Global Const DMPAPER_TABLOID = 3              ' Tabloid 11 x 17 in
Global Const DMPAPER_LEDGER = 4               ' Ledger 17 x 11 in
Global Const DMPAPER_LEGAL = 5                ' Legal 8 1/2 x 14 in
Global Const DMPAPER_STATEMENT = 6            ' Statement 5 1/2 x 8 1/2 in
Global Const DMPAPER_EXECUTIVE = 7            ' Executive 7 1/4 x 10 1/2 in
Global Const DMPAPER_A3 = 8                   ' A3 297 x 420 mm
Global Const DMPAPER_A4 = 9                   ' A4 210 x 297 mm
Global Const DMPAPER_A4SMALL = 10             ' A4 Small 210 x 297 mm
Global Const DMPAPER_A5 = 11                  ' A5 148 x 210 mm
Global Const DMPAPER_B4 = 12                  ' B4 250 x 354
Global Const DMPAPER_B5 = 13                  ' B5 182 x 257 mm
Global Const DMPAPER_FOLIO = 14               ' Folio 8 1/2 x 13 in
Global Const DMPAPER_QUARTO = 15              ' Quarto 215 x 275 mm
Global Const DMPAPER_10X14 = 16               ' 10x14 in
Global Const DMPAPER_11X17 = 17               ' 11x17 in
Global Const DMPAPER_NOTE = 18                ' Note 8 1/2 x 11 in
Global Const DMPAPER_ENV_9 = 19               ' Envelope #9 3 7/8 x 8 7/8
Global Const DMPAPER_ENV_10 = 20              ' Envelope #10 4 1/8 x 9 1/2
Global Const DMPAPER_ENV_11 = 21              ' Envelope #11 4 1/2 x 10 3/8
Global Const DMPAPER_ENV_12 = 22              ' Envelope #12 4 \276 x 11
Global Const DMPAPER_ENV_14 = 23              ' Envelope #14 5 x 11 1/2
Global Const DMPAPER_CSHEET = 24              ' C size sheet
Global Const DMPAPER_DSHEET = 25              ' D size sheet
Global Const DMPAPER_ESHEET = 26              ' E size sheet
Global Const DMPAPER_ENV_DL = 27              ' Envelope DL 110 x 220mm
Global Const DMPAPER_ENV_C5 = 28              ' Envelope C5 162 x 229 mm
Global Const DMPAPER_ENV_C3 = 29              ' Envelope C3  324 x 458 mm
Global Const DMPAPER_ENV_C4 = 30              ' Envelope C4  229 x 324 mm
Global Const DMPAPER_ENV_C6 = 31              ' Envelope C6  114 x 162 mm
Global Const DMPAPER_ENV_C65 = 32             ' Envelope C65 114 x 229 mm
Global Const DMPAPER_ENV_B4 = 33              ' Envelope B4  250 x 353 mm
Global Const DMPAPER_ENV_B5 = 34              ' Envelope B5  176 x 250 mm
Global Const DMPAPER_ENV_B6 = 35              ' Envelope B6  176 x 125 mm
Global Const DMPAPER_ENV_ITALY = 36           ' Envelope 110 x 230 mm
Global Const DMPAPER_ENV_MONARCH = 37         ' Envelope Monarch 3.875 x 7.5 in
Global Const DMPAPER_ENV_PERSONAL = 38        ' 6 3/4 Envelope 3 5/8 x 6 1/2 in
Global Const DMPAPER_FANFOLD_US = 39          ' US Std Fanfold 14 7/8 x 11 in
Global Const DMPAPER_FANFOLD_STD_GERMAN = 40  ' German Std Fanfold 8 1/2 x 12 in
Global Const DMPAPER_FANFOLD_LGL_GERMAN = 41  ' German Legal Fanfold 8 1/2 x 13 in
Global Const DMPAPER_LAST = DMPAPER_FANFOLD_LGL_GERMAN
Global Const DMPAPER_USER = 256

' bin selections
Global Const DMBIN_UPPER = 1
Global Const DMBIN_FIRST = DMBIN_UPPER
Global Const DMBIN_ONLYONE = 1
Global Const DMBIN_LOWER = 2
Global Const DMBIN_MIDDLE = 3
Global Const DMBIN_MANUAL = 4
Global Const DMBIN_ENVELOPE = 5
Global Const DMBIN_ENVMANUAL = 6
Global Const DMBIN_AUTO = 7
Global Const DMBIN_TRACTOR = 8
Global Const DMBIN_SMALLFMT = 9
Global Const DMBIN_LARGEFMT = 10
Global Const DMBIN_LARGECAPACITY = 11
Global Const DMBIN_CASSETTE = 14
Global Const DMBIN_LAST = DMBIN_CASSETTE
Global Const DMBIN_USER = 256             ' device specific bins start here

' print qualities
Global Const DMRES_DRAFT = -1
Global Const DMRES_LOW = -2
Global Const DMRES_MEDIUM = -3
Global Const DMRES_HIGH = -4

' color enable/disable for color printers
Global Const DMCOLOR_MONOCHROME = 1
Global Const DMCOLOR_COLOR = 2

' duplex enable
Global Const DMDUP_SIMPLEX = 1
Global Const DMDUP_VERTICAL = 2
Global Const DMDUP_HORIZONTAL = 3

' TrueType options
Global Const DMTT_BITMAP = 1          ' print TT fonts as graphics
Global Const DMTT_DOWNLOAD = 2        ' download TT fonts as soft fonts
Global Const DMTT_SUBDEV = 3          ' substitute device fonts for TT fonts

' device capabilities indices
Global Const DC_FIELDS = 1            ' Returns the dmFields member of the DEVMODE structure
Global Const DC_PAPERS = 2            ' Reutrns an array of type Integer listing available paper sizes (see above DMPAPER consts)
Global Const DC_PAPERSIZE = 3         ' Copys dims of all supported paper sizes (in 10ths of millimeters) to a PAPERSIZE_TYPE structure
Global Const DC_MINEXTENT = 4         ' Returns a POINT_TYPE containing the min papersize that dmPaperLength and dmPaperWidth can specify
Global Const DC_MAXEXTENT = 5         ' Returns a POINT_TYPE containing the max papersize that dmPaperLength and dmPaperWidth can specify
Global Const DC_BINS = 6              ' Returns an array of type Integer containing the available paper bins for the printer (see above DMBIN consts)
Global Const DC_DUPLEX = 7            ' Returns the level of duplex support
Global Const DC_SIZE = 8              ' Returns the dmSize member of the DEVMODE structure
Global Const DC_EXTRA = 9             ' Returns the # of bytes required for the driver-specific portion of the DEVMODE structure
Global Const DC_VERSION = 10          ' Returns the spec version to which the printer driver conforms
Global Const DC_DRIVER = 11           ' Returns the version # of the printer driver
Global Const DC_BINNAMES = 12         ' Returns an array of BINNAMES_TYPE giving the names of the available paper bins
Global Const DC_ENUMRESOLUTIONS = 13  ' Returns an array of ENUMRESOLUTIONS_TYPE showing the available DPI resolutions supported
Global Const DC_FILEDEPENDENCIES = 14 ' Returns an array of FILEDEPENDENCIES_TYPE showing all the driver files needed for the printer
Global Const DC_TRUETYPE = 15         ' Returns the level of ability the printer has for using TrueType fonts
Global Const DC_PAPERNAMES = 16       ' Returns an array of PAPERNAMES_TYPE showing the names for the papers available
Global Const DC_ORIENTATION = 17      ' Returns the relationship between portrait and landscape in terms of the number of degrees that portrait orientation is rotated counterclockwise to produce landscape orientation
Global Const DC_COPIES = 18           ' Returns the # of copies the device can print

' bit fields of the return value (DWORD) for DC_TRUETYPE
Global Const DCTT_BITMAP = 1
Global Const DCTT_DOWNLOAD = 2
Global Const DCTT_SUBDEV = 4

Sub Test1 ()
  Dim min As POINT_TYPE
  Dim lRet As Long
  Dim inDEV As DEVMODE_TYPE

  lRet = VBDeviceCapabilities("Epson Stylus Pro on LPT1:", DC_MAXEXTENT, min, inDEV)

End Sub

