unit JwStgPnl;

{
        **   VERSION History   **
   Version     Date     Notes
    v1.00  - 01APR99    Original Release
}

{
   The stage panel handles much the same way as a combo box, except it's
a button of sorts.  And as you press the button with the left button, it
cycles forward in the stage list, and the right button cycles backward.
   The real problem was adding a list of colors, so I settled on just
using a string list of colors.
}

interface

uses {$IFDEF WIN32} Windows, {$ELSE} WinProcs, WinTypes, {$ENDIF}
      Messages, SysUtils, Classes, Controls, Forms, Graphics, Extctrls;

type
  TJwStagePanel = class(TPanel)
    private
      { Private fields of TJwStagePanel }
        FAdjustBevel : Boolean;
        FAdjustColor : Boolean;
        FColorList : TStrings;
        FLabels : TStrings;
        FStageTag : Longint;

      { Private methods of TJwStagePanel }
        function GetAdjustBevel : Boolean;
        procedure SetAdjustBevel(Value : Boolean);
        function GetAdjustColor : Boolean;
        procedure SetAdjustColor(Value : Boolean);
        function GetColorList : TStrings;
        procedure SetColorList(Value : TStrings);
        function GetLabels : TStrings;
        procedure SetLabels(Value : TStrings);
        function GetStageTag : Longint;

    protected
      { Protected fields of TJwStagePanel }

      { Protected methods of TJwStagePanel }
        procedure Click; override;
        procedure DragDrop(DragObject: TObject; X, Y: Integer); override;
        procedure DoEnter; override;
        procedure DoExit; override;
        procedure MouseDown(Button: TMouseButton; Shift: TShiftState; X, Y: Integer); override;
        procedure MouseMove(Shift: TShiftState; X, Y: Integer); override;
        procedure MouseUp(Button: TMouseButton; Shift: TShiftState; X, Y: Integer); override;
        procedure Resize; override;
        procedure Loaded; override;
        procedure Paint; override;

    public
      { Public fields and properties of TJwStagePanel }

      { Public methods of TJwStagePanel }
        constructor Create(AOwner: TComponent); override;
        destructor Destroy; override;

    published
      { Published properties of TJwStagePanel }
        property OnClick;
        property OnDblClick;
        property OnDragDrop;
        property OnEnter;
        property OnExit;
        property OnKeyDown;
        property OnKeyPress;
        property OnKeyUp;
        property OnMouseDown;
        property OnMouseMove;
        property OnMouseUp;
        property OnResize;
        property AdjustBevel : Boolean
             read GetAdjustBevel write SetAdjustBevel
             default False;
        property AdjustColor : Boolean
             read GetAdjustColor write SetAdjustColor
             default False;
        property ColorList : TStrings read GetColorList write SetColorList;
        { The different labels to be used }
        property Labels : TStrings read GetLabels write SetLabels;
        property StageTag : Longint read GetStageTag write FStageTag default 0;

  end;

procedure Register;

implementation

procedure Register;
begin
     { Register TJwStagePanel with JoeCode as its
       default page on the Delphi component palette }
     RegisterComponents('JwTools', [TJwStagePanel]);
end;

function HexToInt( InStr: String ): LongInt;

  function HexToByte( InChar: Char ): Byte;
    const
      Subtractor = Ord( 'A' ) - 10;
    begin
      case InChar of
        '0'..'9': Result := Ord( InChar ) - Ord( '0' );
        'A'..'F': Result := Ord( InChar ) - Subtractor;
        else
          Result := 0;
      end;
    end;

  var
    TempInt, TempInt2: Integer;
    TempLongInt: LongInt;

  begin
    Result := 0;
    TempInt2 := 0;
    for TempInt := Length( InStr ) downto 1 do begin
      TempLongInt := HexToByte( UpCase( InStr[TempInt] ) );
      if TempLongInt > 0 then begin
        If TempInt2 > 24 then
          begin
            Result := -1;
            exit;
          end;
        TempLongInt := TempLongInt shl TempInt2;
        Result := Result + TempLongInt;
      end;
      Inc( TempInt2, 4 );
    end;
  end;

function TJwStagePanel.GetAdjustBevel : Boolean;
begin
  Result := FAdjustBevel;
end;

procedure TJwStagePanel.SetAdjustBevel(Value : Boolean);
begin
  FAdjustBevel := Value;
end;

function TJwStagePanel.GetAdjustColor : Boolean;
begin
  Result := FAdjustColor;
end;

procedure TJwStagePanel.SetAdjustColor(Value : Boolean);
begin
  FAdjustColor := Value;
end;

function TJwStagePanel.GetColorList : TStrings;
begin
  Result := FColorList;
end;

procedure TJwStagePanel.SetColorList(Value : TStrings);
begin
 { Use Assign method because TList is an object type }
  FColorList.Assign(Value);

  Invalidate;
end;

function TJwStagePanel.GetLabels : TStrings;
begin
  Result := FLabels;
end;

procedure TJwStagePanel.SetLabels(Value : TStrings);
begin
  { Use Assign method because TStrings is an object type }
  FLabels.Assign(Value);
  Invalidate;
end;

function TJwStagePanel.GetStageTag : Longint;
begin
  Result := FStageTag;
end;

{ Override OnClick handler from TPanel }
procedure TJwStagePanel.Click;
begin
  inherited Click;
end;

{ Override OnDragDrop handler from TPanel }
procedure TJwStagePanel.DragDrop(DragObject: TObject; X, Y: Integer);
begin
  inherited DragDrop(DragObject, X, Y);
end;

{ Override OnEnter handler from TPanel }
procedure TJwStagePanel.DoEnter;
begin
  inherited DoEnter;
end;

{ Override OnExit handler from TPanel }
procedure TJwStagePanel.DoExit;
begin
  inherited DoExit;
end;

{ Override OnMouseDown handler from TPanel }
procedure TJwStagePanel.MouseDown(Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  inherited MouseDown(Button, Shift, X, Y);
end;

{ Override OnMouseMove handler from TPanel }
procedure TJwStagePanel.MouseMove(Shift: TShiftState; X, Y: Integer);
begin
  inherited MouseMove(Shift, X, Y);
end;

{ Override OnMouseUp handler from TPanel }
procedure TJwStagePanel.MouseUp(Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if Button = mbLeft then
    begin
      if ( FStageTag + 1 ) < FLabels.Count then
        Inc( FStageTag )
      else
        FStageTag := 0;
    end
  else
    begin
      if ( FStageTag - 1 ) > -1 then
        Dec( FStageTag )
      else
        FStageTag := FLabels.Count - 1;
    end;
  Self.Caption := FLabels[ FStageTag ];

  if FAdjustColor then
    begin
      if FStageTag < FColorList.Count then
        Self.Color := HexToInt( FColorList[ FStageTag ] )
      else
        Self.Color := clBtnFace;
    end;

  if FAdjustBevel then
    begin
      Case Self.BevelOuter of
        bvNone: Self.BevelOuter := bvLowered;
        bvLowered: Self.BevelOuter := bvRaised;
        bvRaised: Self.BevelOuter := bvNone;
      end;
    end;

  inherited MouseUp(Button, Shift, X, Y);
end;

{ Override OnResize handler from TPanel }
procedure TJwStagePanel.Resize;
begin
  { Call method of parent class }
  inherited Resize;
end;

constructor TJwStagePanel.Create(AOwner: TComponent);
begin
  { Call the Create method of the container's parent class       }
  inherited Create(AOwner);

  FAdjustBevel := False;
  FAdjustColor := False;
  FColorList := TStringList.Create;
  FLabels := TStringList.Create;
  FStageTag := 0;

  FLabels.Add( 'JwStagePanel' );
end;

destructor TJwStagePanel.Destroy;
begin
  FColorList.Free;
  FLabels.Free;
  inherited Destroy;
end;

procedure TJwStagePanel.Loaded;
begin
  inherited Loaded;
end;

procedure TJwStagePanel.Paint;
begin
  { Make this component look like its parent component by calling
    its parent's Paint method. }
  Self.Caption := FLabels[ FStageTag ];

  if FAdjustColor then
    begin
      if FStageTag < FColorList.Count then
        Self.Color := HexToInt( FColorList[ FStageTag ] )
      else
        Self.Color := clBtnFace;
    end;

  inherited Paint;
end;


end.

