{*************************************************************}
{*                                                           *}
{*    Here is Hello-world!                                   *}
{*        or: have you ever believed that this proggy        *}
{*        could be compiled under MS-DOS ?                   *}
{*    Want some help ? CATCH THIS: 'dcc -cd hello.pas'       *}
{*    And, for the protected mode: 'dcc -cp hello.pas'       *}
{*    And, for Windows, of course: 'dcc hello.pas'           *}
{*    But for that you must have (what a surprise !)         *}
{*        TURBO.TPL and/or TPP.TPL                           *}
{*                                                           *}
{*    Written by Cosmin Truta                                *}
{*    Babes-Bolyai University, Cluj-Napoca, Romania, 1996    *}
{*                                                           *}
{*************************************************************}

program Hello;

{$IFDEF WINDOWS}
uses WinCrt;
{$ELSE}
  {$IFNDEF DPMI}
  {$M $4000, $4000, $4000}
  {$ELSE}
  {$M $4000}
  {$ENDIF}
uses Dos;
{$ENDIF}

{$IFDEF VER70}  (** or VER60 or VER55 or ... **)
Error: 'This program requires Borland Pascal 8.0 (!!) or higher'
{$ENDIF}

type
  TMyBaseClass = class
  protected
    function M: string; virtual; abstract;
  end;

  TMyClass = class(TMyBaseClass)
  private
    FN: Integer;
    procedure SetN(Value: Integer);
  protected
    function M: string; override;
  public
    constructor Create;
    property N: Integer read FN write SetN default 3;
  end;

  TOtherClass = class(TMyBaseClass);

constructor TMyClass.Create;
begin
  FN := 3;
end;

function TMyClass.M: string;
begin
  M := 'This method overrides an abstract method';
end;

procedure TMyClass.SetN(Value: Integer);
begin
  FN := Value;
end;

{ RTTI Testing }
procedure RTTITest(Obj: TObject; const ObjName: string);
begin
  Writeln('  Working with ', ObjName);
  Writeln('    class name: ', Obj.ClassName);
  Writeln('    class parent: ', Obj.ClassParent.ClassName);
  if Obj is TMyClass then
  begin
    Writeln('  this object is an instance of ''TMyClass''');
    Writeln('    and the value of its field is ', (Obj as TMyClass).N);
  end
  else
    Writeln('  this object is not an instance of ''TMyClass''');
end;

{ Execute ExcDemo }
function ExecExcDemo: Boolean;
{$IFDEF WINDOWS}
begin
  ExecExcDemo := False;
end;
{$ELSE}
var
  F: file;
begin
  FileMode := 0;
  {$I-}
  Assign(F, 'EXCDEMO.EXE'); Reset(F);
  {$I+}
  if IOResult <> 0 then
  begin
    ExecExcDemo := False;
    Exit;
  end;
  Close(F);
  SwapVectors;
  Exec(GetEnv('COMSPEC'), '/C EXCDEMO.EXE');
  SwapVectors;
  ExecExcDemo := (DosError = 0);
end;
{$ENDIF}

var
  MyObject: TMyClass;
  OtherObject: TOtherClass;

begin
  Writeln('Hello, world !');
  Writeln('Please see what can we have now even in MS-DOS !');
  Readln;

  Writeln('The features of the new class types available in Delphi:');
  MyObject := TMyClass.Create;
  OtherObject := TOtherClass.Create;

  with MyObject do
  begin
    Writeln('  This is a property:');
    Writeln('    initial value:', N : 2);
    N := 7;
    Writeln('    final value:' , N : 4);
    Writeln('  ', M, '.');
    Writeln;
  end;

  Writeln('Run-time type information:');
  RTTITest(MyObject, 'MyObject');
  RTTITest(OtherObject, 'OtherObject');
  Readln;

  Writeln('Exception handling:');
  if not ExecExcDemo then
    Writeln('  -- compile and execute the ExcDemo program for demo.');
  Readln;

  Writeln('You can even try the safe FDIV instruction on a buggy Pentium');
  Writeln('  using the $U+/- directive.');
  Writeln;
  Writeln('But, first of all, you must be able to compile ',
    'all your BP7 programs !');
  Writeln;
end.
