     	:: For US Robotics Courier "V Everything" V.34 modems (with HST)
	:: Change the next script line to match the speed in initmodem
	:: (in the initmodem subroutine near the end of this file).

	:: If you have a fast system change instances of 38400 to 115200

dialnum	if js2,mnp speed 38400
	gosub waketb		:: get modem to respond
	pat; pat 9 OK
	put "AT"
      	if !js2,mnp put "&M0&B0&H0&R1"   :: No error correction or flow control
	if js2,mnp put "&M5"             :: ARQ mode only, hangs up if no ARQ
        if js2,o_mnp put "S27=32"        :: LAPM (V.42) defeated, MNP 1-4 only
        if js2,a_mnp put "&M4"           :: Requests ARQ connect 
	if js2,_s put "&H2&I2&R1"        :: Software flow control (avoid!!)
        if js2,_c put "&K1"              :: Automatic compression (MNP5 or V.42bis) if HWFC & DTE>DCE
        if js2,_nc put "&K0"             :: No compression
        if js2,v32 put "S56=192"         :: V.32bis and V32 terbo; V.FC, and V.34 defeated
        if js2,vfc put "S54=128S56=64"   :: V.FC only; V.34  defeated
	if js2,hst put "B1"              :: Requests HST, accepts V.32, V.FC or V.34
        if js2,o_hst put "S27=4S56=192"  :: HST only; V.32 and V.FC and V.34 defeated
	if js2,300 put "&N1"             :: Forces connect speed specified
	if js2,1200 put "&N2"
	if js2,2400b put "&N3"
        if js2,4800 put "&N4"
        if js2,7200 put "&N5"
        if js2,9600 put "&N6"
        if js2,12000 put "&N7"
        if js2,14400 put "&N8"
        if js2,16800 put "&N9"
        if js2,19200 put "&N10"   
        if js2,21600 put "&N11"
        if js2,24000 put "&N12"
        if js2,26400 put "&N13"
        if js2,28800 put "&N14" 
	ss s2 "(c:)(.*)";  if %z2 put "%z2 "	:: for extra commands
	if "%s3>8" put "S7=70"		: longer wait if long distance
	put "Q0E1V1S10=10\r"; wait -f2
	if %alds if ps3,0 putw "ATS8=10\r"
	put "%mprefix";  put "%s3%alds";  dis -Q
	if js2,man put ";\r"; echo "Hit F1 when Tone is heard"; t; put "ATD"
	put "\r";  dis -t
	if "js3,;"  accept s1 "Lift Telephone Receiver, Hit ENTER"; o; return
	pat 1l "CONNECT"; pat 2l "NO CARRIER"; pat 3l "BUSY"; pat 4l "RINGING"
	pat 5l "NO DIAL TONE"; pat 6l "VOICE"; pat 7l "NO ANSWER"; pat 8i "ERROR"
        pat 9l "OK"   
	wait -f72
	while "4&&!L>4" wait -f40    :: wait for a few rings only
	if "n||2||3||4||5||6||7||8||9" goto sorry
	dis -d
	if dd while "!c&&L<20" sleep 1	:: For modems with slow carrier det
        sets s8 %y2 
	if "hCONNECT" ss y "[0-9]+"; estimate 0 z0; if !%s1 ife az0>300 speed z0; else speed 300
	if "hCARRIER" ss y "[0-9]+"; estimate 0 z0        
        if "hNONE" if S>2400 echo "ARQ Connection Required"; return  :: Rejects non-ARQ connects >2400 bps
        if js2,fast if az0<9600 echo "No Fast Connection"; return    :: Rejects connects <9600 bps
        if "!hARQ" set s1 ""
	if !%s1 goto ns1
        :: if !Js1,_s handshake slow; lput "Handhake SLOW: "         :: For slow HD
        if !Js1,_s handshake on; lput "Handshake ON: "
        if "hARQ" echo "ARQ Connected"
	echo "Speed Locked"; goto mm2end
ns1:    if "hARQ" echo "ARQ Connected"; handshake both; goto mm2end
	if "hMNP" echo "MNP Connected";  handshake both; goto mm2end
        if "hLAPM" echo "V.42 Connected"; handshake both; goto mm2end
        if "hHST" echo "HST Connected"; handshake both; goto mm2end
        if "hNONE" echo "No Error Correcton"; handshake off; goto mm2end
        echo "Unknown Connect Message!!"
        return
sorry:	echo "No Connect Message Detected."
	return
mm2end:	set s9 "y"
	return

	:: If you change the speed below, you MUST change the speed in
	:: lines labelled "dialnum" and "call2" in this file !!!

initmodem  echo "Initializing Courier Dual Standard V.34 Modem"	
        pat 0 "OK"
	speed 38400
	put "AT&F1 X6 &B2\r";  wait -f4        :: HW flow control template
	put "AT&K3\r";  wait -f4	       :: V.42bis compression only
        :put "ATS54=0\r"; wait -f4             :: Enable V.8 Call Indicate
        put "ATS11=40\r"; wait -f4             :: Faster tone dialing
	if js0,,aa put "ATE0 Q2 S0=1 S7=18\r";  wait -f5
	put "AT&W\r"; wait -f4
	return


call1	bye; sp 38400; gosub waketb; putw ATM0H1\r"
	return

call2	bye;
	sp 38400	 	:: Change this to match speed in initmodem
	gosub waketb; pat 1 OK
	put "ATX6 Q0 S0=1 &A2 &B2 B0 S28=0 &H1 &I0 &K0 &M4 &R2 &Y0\r"; wait -f2
	put "AT&K3\r"; wait -f2		:: Dual Standard/v.42bis
	return

