#define AREAS_NAME       "AREAS"    /* Complies with SOUP v1.2  */
#define BATCH_EXT          "MSG"    /* Complies with SOUP v1.2  */
#define INDEX_EXT          "IDX"    /* Complies with SOUP v1.2  */
#define ERRORS_NAME     "ERRORS"    /* Complies with SOUP v1.2  */
#define NEWSRC      "NEWSRC.SLR"
#define NEWSRC_TMP  "NEWSRC.TMP"

enum SOUP_Types { u, M, m, n, C, c, i, b, B };  /* Supported types */

/* External Data */
extern int  verbose;                              /* From config.c */
extern char _slrerr[80];                          /* From config.c */
extern char user_path[MAXPATH];                   /* From config.c */
extern char temp_path[MAXPATH];                   /* From config.c */
extern char log_path[MAXPATH];                    /* From config.c */
extern char newsgroups_path[MAXPATH];             /* From config.c */
extern int  news_type;                            /* From config.c */
extern int  news_index;                           /* From config.c */
extern int  kill_summary;                         /* From config.c */
extern long news_area_bytes;                      /* From config.c */
extern long news_area_messages;                   /* From config.c */
extern char area_name[80];                        /* From newsrc.c */
extern char keyword;                              /* From newsrc.c */
extern long index_high;                           /* From newsrc.c */
extern long msg_high;                             /* From newsrc.c */
extern char batch_prefix[10];                     /* From batindex.c */
extern long totbyte_count;                        /* From slrnews.c */

/* External Functions */
extern int  get_batch_prefix();                   /* From batindex.c */
extern int  kill_msg(FILE *message_file);         /* From kill.c     */
extern int  write_description(FILE *areas_file);  /* From newsgrp.c  */
extern long filesize(FILE *filename);             /* From filesize.c */
extern int  write_newsrc(const char *newsrc_type, const char *open_mode);
extern int  partial_cnews(FILE *message_file, FILE *index_file, long message_size, long offset, char *file_name);
extern int  full_cnews(FILE *message_file, FILE *index_file, long message_size, long offset, char *file_name);

/* Global Data */
long high_msg;
long low_msg;

/* Local functions */
FILE *open_batch_file();
FILE *open_index_file();
FILE *open_areas_file();
long eval_area();
long high_fileno();
long low_fileno();
int  usenet_message(FILE *message_file, FILE *batch_file);
int  binary_message(FILE *message_file, FILE *batch_file, long message_size);
void clean_zero_byte_file();
