#include <string.h>

extern char compress[10];
extern char _slrerr[80];

/*
Function: get_compress_type()
Purpose : Extract compression type from string and store in global
          variable compress.
Return  : 0 on success, non-zero on error and set _slrerr.
*/

int get_compress_type(char buf[128])
{
  char *p = NULL;

  if ((p = strtok(buf,"-")) == NULL)
  {
    strcpy(_slrerr,"get_compress_type(): invalid \"compress\" line in config file");
    goto ErrorExit;
  }
  if ((p = strtok(NULL,"=")) == NULL)
  {
    strcpy(_slrerr,"get_compress_type(): invalid \"compress\" line in config file");
    goto ErrorExit;
  }
  strcpy(compress,p);
GoodExit:
  return 0;
ErrorExit:
  return 1;
}
