;PPMPX2.ASM 3.3 (for DPMI)
;	MACHINE LANGUAGE SUBROUTINES
;	FOR PPMPQS
;	1991-97 by YUJI KIDA
;
.386P

code	segment	use16
	assume cs:code,ds:code


	INCLUDE	UBP.MAC
	include	ppmpx.h

	org	100h
start:
	JMP	START0

	include	dpmi4ub.h
	include	dpmi4ub.lib

	align	4
primeadrnow	dd	?
lastprime	dd	?

lpvindexadr	dd	?
lpvdataadr	dd	?

pmodecsseg	dw	?

primes		dd	?

P_OFF	DD	?
Y_OFF	DD	?
L_OFF	DD	?
X_OFF	DD	?
D_OFF	DD	?
B_OFF	DD	?
M_OFF	DW	?
M_SEG	DW	?
W_OFF	DD	?


IniLog	DW	?
CutLog	DW	?

lpvnow		dw	0
lpvcount	dw	0

sieveUnitMax	dd	?


; ** command branch


START0:
	MOV_AX	AR0		;ARRAY[0] is the command
	MOV	BX,offset CMD_TBL
	SHL	AX,1
	ADD	BX,AX
	JMP	CS:[BX]

CMD_TBL:
	DW	INITMPQS,SETR1R2,SIEVE,SETDATAB,SETDATA
	DW	DECOMPOSE,INITMPQS2,freememory


;
; * free DPMI memories
;
freememory:
	call	freemainDATAmemory
	mov	ax,ss
	mov	ds,ax
	mov	es,ax
	retf

;
; * Initialize again
; command#=6

initmpqs2:
	call	real2protA

	mov	eax,ds:[_sieveBsize]
	mov	edx,ds:[_sievetop]
	sub	eax,edx
	mov	ds:[_sieveConst],eax

	push	edx
	call	prot2real
	pop	eax

	mov	bx,AR0
	shr	eax,5		;/20h
	mov	cs:[bx],ax	;loop time
	shr	eax,16
	mov	cs:[bx+2],ax

	mov	ax,ss
	mov	ds,ax
	mov	es,ax
	retf


;
;* test the divisivility of W by PR()
;
;COMMAND#=5

decompose:
	call	real2protA

	mov	eax,gs:[w_off]
	mov	ds:[_absQ],eax

	db	09ah		;call main
	dw	480h
decomposeSEL	dw	?
	call	prot2real
	cli
	mov	ax,ss
	mov	ds,ax
	mov	es,ax
	sti
	retf

;
; initialize work area
;COMMAND#=0

;	V1=work(0,0)
;	V2=P
;	V3=Y
;	V4=L
;	V5=X
;	V6=D
;	V7=B
;	V8=OF
;	V9=W#
;	V10=MP2%(0)

;	AR[1]	NUMBER OF PRIMES \ 2
;	AR[2]	INITIAL LOG
;	AR[3]	LIMIT LOG
;
;	set AR[1]=0 if memory lacks

MEMORY_LACK:
	MOV	BX,AR1
	MOV	WORD PTR CS:[BX],0
	retf

seg2linear:
	movzx	edx,word ptr cs:[bx]
	movzx	eax,word ptr cs:[bx+2]
	shl	eax,4
	add	eax,edx
	ret


INITMPQS:
	MOV	BX,V1		;check work(0,0) segment
	MOV	AX,CS:[BX]
	shr	ax,4
	add	ax,CS:[BX+2]
	cmp	ax,_memoseg
	ja	short memory_lack

	MOV	BX,V2		;set P ADDRESS
	call	seg2linear
	MOV	CS:[P_OFF],eax

	MOV	BX,V3		;set Y ADDRESS
	call	seg2linear
	MOV	CS:[Y_OFF],eax

	MOV	BX,V4		;set L ADDRESS
	call	seg2linear
	MOV	CS:[L_OFF],eax

	MOV	BX,V5		;set X ADDRESS
	call	seg2linear
	MOV	CS:[X_OFF],eax

	MOV	BX,V6		;set D ADDRESS
	call	seg2linear
	MOV	CS:[D_OFF],eax

	MOV	BX,V7		;set B ADDRESS
	call	seg2linear
	MOV	CS:[B_OFF],eax

	MOV	BX,V8		;set Off ADDRESS
	mov	ax,cs:[bx]
	MOV	CS:[M_OFF],ax
	mov	ax,cs:[bx+2]
	MOV	CS:[M_SEG],ax

	MOV	BX,V9		;set W# ADDRESS
	call	seg2linear
	MOV	CS:[W_OFF],eax

	MOV	BX,V10		;set PMODE segment
	MOV	AX,CS:[BX]
	shr	ax,4
	add	ax,CS:[BX+2]
	sub	ax,ARRAYHEADSEG
	mov	cs:[pmodecsseg],ax

	xor	eax,eax
	MOV_AX	AR1
	shl	eax,5
	mov	cs:[primes],eax

	MOV_AX	AR2
	MOV	CS:[IniLog],AX

	MOV_AX	AR3
	MOV	CS:[CutLog],AX

	xor	eax,eax
	mov_ax	AR4
	shl	eax,10
	mov	cs:[sieveUnitMax],eax

init100:
	mov	ax,cs
	mov	ds,ax

	; store "number of primes" and "inilog" 
	; and "cutlog" and "M"

	mov	ax,_memoseg
	mov	es,ax

	mov	di,0			;clear work area
	mov	cx,80h
	xor	ax,ax
	rep	stosw

	mov	eax,cs:[sieveUnitMax]
	mov	es:[_sieveBsizeR],eax
	shr	eax,1
	mov	es:[_sieveWsizeR],eax

	mov	eax,cs:[primes]
	mov	es:[_primesR],eax

	mov	ax,cs:[inilog]
	mov	ah,al
	mov	es:[_inilogR],ax
	mov	es:[_inilogR+2],ax

	mov	ax,cs:[cutlog]
	mov	es:[_cutlogR],ax

	lds	si,dword ptr cs:[M_off]	;set sievewidth
	mov	di,_sievewidthR
	lodsw
	and	ax,7fffh	;make positive
	movsw
	cmp	ax,1
	je	short init150
	movsw
init150:
	cli
	mov	ax,cs
	mov	ds,ax
	sti

	mov	eax,[primes]
	add	eax,100
	mov	edx,primeunitbytes
	mul	edx
	add	eax,[sieveUnitMax]
;add	eax,[sieveUnitMax]	;for safety
	add	eax,48		;for alignment safety
	mov	[DPMImemorysize],eax
	call	DPMIinit
	jc	initerror

	mov	cx,16
	mov	ax,[pmodecsseg]
	mul	cx
	mov	cx,dx
	mov	dx,ax
	mov	bx,[userCODE32sel]
	mov	ax,7		;set base address
	int	31h

	mov	ebx,dword ptr [DPMIaddresslow]
	add	ebx,0fh
	and	bx,0fff0h
	mov	fs:[_primeadr],ebx

	mov	edx,fs:[_primes]
add	edx,100
	mov	eax,primeunitbytes
	mul	edx
	add	eax,ebx
	add	eax,31		;
	and	ax,0ffe0h	;let be multiple of 32
	mov	fs:[_sievetop],eax
	add	eax,fs:[_sieveBsize]
	mov	fs:[_sieveover],eax

	add	ebx,primeunitbytes
	mov	[primeadrnow],ebx
	mov	[lastprime],0
	call	prot2real

	mov	ax,[userCODE32sel]
	mov	[decomposeSEL],ax
	mov	[sieveSEL],ax
	mov	[setR1R2SEL],ax

	;set higher work area address

	mov	ax,_memoseg
	shr	ax,1
	mov	bx,AR1
	mov	[bx],ax

	cli
	mov	ax,ss
	mov	ds,ax
	mov	es,ax
	sti
	retf

initerror:
;	call	prot2real
	mov	ax,cs
	mov	ds,ax
	mov	ax,8001h	;-1 of UB
	mov	bx,AR1
	mov	[bx],ax

	cli
	mov	ax,ss
	mov	ds,ax
	mov	es,ax
	sti
	retf

;
; set data for each prime
;command#=4
setdata:
	call	real2protA

	mov	edi,gs:[primeadrnow]
	mov	esi,gs:[p_off]
	mov	ax,ds:[esi]
	add	esi,2
	cmp	ax,1
	ja	short setdata20
	movzx	eax,word ptr [esi]
;	add	esi,2
	jmp	short setdata30
setdata20:
	mov	eax,[esi]
;	add	esi,4

setdata30:
	cmp	eax,ds:[_sieveBsize]
	jb	short setdata39
	inc	word ptr ds:[_primes4]
setdata39:
	mov	edx,eax
	sub	eax,gs:[lastprime]
	mov	[edi],ax
	mov	gs:[lastprime],edx

	mov	esi,gs:[y_off]
	mov	ax,[esi]
	add	esi,2
	cmp	ax,1
	ja	short setdata40
	jb	short setdata50
setdata45:
	movzx	eax,word ptr [esi]
;	add	esi,2
	jmp	short setdata50
setdata40:
	mov	eax,[esi]
;	add	esi,4
setdata50:
	mov	[edi+4],eax

	mov	esi,gs:[l_off]
	mov	ax,[esi+2]
	mov	[edi+2],ax

	add	edi,primeunitbytes
	mov	gs:[primeadrnow],edi

	call	prot2real

	mov	ax,ss
	mov	ds,ax
	retf

;
; set data for each prime power
;command#=3
setdataB:
	call	real2protA

	inc	word ptr ds:[_primepowers]

	mov	edi,gs:[primeadrnow]

	mov	esi,gs:[p_off]
	xor	eax,eax
	mov	ax,[esi+2]		;must be < 2^16
	mov	[edi],ax		;set raw data

	shr	ax,1
	jc	setdataBjp		;if odd
	inc	word ptr ds:[_powersof2]
setdataBjp:
	mov	esi,gs:[y_off]
	mov	ax,[esi+2]		;must be < 2^16
	mov	[edi+4],eax		;set sqrt

	mov	esi,gs:[l_off]
	mov	ax,[esi+2]
	mov	[edi+2],ax		;set log

	add	edi,primeunitbytes
	mov	gs:[primeadrnow],edi

	call	prot2real
	mov	ax,ss
	mov	ds,ax
	retf


;
; * sieving main
;   386 protect mode
; command#=2

SIEVE:
	call	real2protA

	db	09ah		;call main
	dw	280h
sieveSEL	dw	?
	call	prot2real
	cli
	mov	ax,ss
	mov	ds,ax
	mov	es,ax
	sti
	retf


;
;
; command#=3
;
dummy:
	retf

;
; set sieve start adr R1,R2 for each prime
;
; command#=1

SETR1R2:	;set parameter

	call	real2protA

	;store D by 32bit form

	mov	esi,gs:[D_OFF]
	mov	edi,_D
	xor	eax,eax
	mov	ax,[esi]
	add	esi,2
	and	ax,7fffh
	mov	ecx,eax
	mov	eax,3		;3*32 bits
	mov	[edi],eax
	add	edi,4
setR1R2lpD:
	mov	ax,[esi]
	add	esi,2
	mov	[edi],ax
	add	edi,2
	loop	setR1R2lpD
	xor	eax,eax
	mov	[edi],eax
	mov	[edi+4],eax
	mov	[edi+8],eax

	;store B by 32bit form

	mov	esi,gs:[B_OFF]
	mov	edi,_B
	xor	eax,eax
	mov	ax,[esi]
	add	esi,2
	and	ax,7fffh
	mov	ecx,eax
	mov	eax,5		;6*32 bits
	mov	[edi],eax
	add	edi,4
setR1R2lpB:
	mov	ax,[esi]
	add	esi,2
	mov	[edi],ax
	add	edi,2
	loop	setR1R2lpB
	xor	eax,eax
	mov	[edi],eax
	mov	[edi+4],eax
	mov	[edi+8],eax
	mov	[edi+0ch],eax
	mov	[edi+10h],eax

	db	09ah		;call protect mode
	dw	100h
setR1R2SEL	dw	?
	call	prot2real
	cli
	mov	ax,ss
	mov	ds,ax
	mov	es,ax
	sti
	retf

codeend:
code	ends
end	start
