; Using these substitutions for HTML codes will result in less typing
; I also find them easier to remember than straight HTML, (but then
;   I created them)
; The command line to use the strings in the file (will save output
;   HTML file with extension .htm) is: mt /i(htmshort.mt)x+b+(.htm) file(s)

; \ (needs to be represented as \\) turns something on ~ turns it off
;

; First line will be title of page
	.{~0}[^\r\n]* = <HTML>\r\n<HEAD>\r\n<TITLE>\i</TITLE>\r\n</HEAD>\r\n<BODY>\r\n
; One or more blank line(s) will be converted to paragraph break
	'\r\n'{2,}      = \r\n<P>\r\n
	\\n             = <BR>          ; \n represents newline as in C
	\\_             = <HR>

; Font styles
	\\b             = <B>
	\~b              = </B>
	\\i             = <I>
	\~i              = </I>
	\\t             = <TT>
	\~t              = </TT>
	\\\"            = <BLOCKQUOTE>
	\~\"             = </BLOCKQUOTE>
; Headings will be represented by \[digit] Heading will continue until end of
;   line or \ encountered
	\\\d[^\\\r\n]*   = <H\2>\3</H\2>

; \** will start a unnumbered list, \* for each item, ~* to end
	 \\'**'            = <UL><LI>
	 \\'*'             = <LI>
	 \~'*'              = </UL>
; \## will start a numbered list, \# for each item, ~# to end
	 \\##            = <OL><LI>
	 \\#             = <LI>
	 \~#              = </OL>
; \g represents graphics, the word after the \g is the image name
	 \\g\s*\w+       = "<IMG SRC= \"\3\">"
; \l represents links, the word after the \l is the link name, the rest of the line
;  will be the link description unless a \ is encountered first
; is the link description
	\\l\s*\S+[^\r\n\\]+ = "<A HREF= \"\3\"> \4 </A>"
; \@ is an email link - the email address will follow and be highlighted
	 \\@\s*\S+       = "<A HREF= \"mailto:\3\">\3</A>"

; Convert to HTML escape characters
	\>              = &lt
	\<              = &gt
	\&              = &amp
	\"              = &quot

; for literal \ and ~ precede with backslash
	\\[\\~]         = \2
; Single \ can be used to end \l and headers, will be deleted
	\\              = \z
; Finally do closing statements
	.{0~} = </BODY>\r\n</HTML>\r\n
