/**************************************
 * LINE.C - ANSI C
 *
 * Sem argumentos: mostra todas as linhas, numeradas
 * 1 argumento: mostra a linha com esse nmero
 * 2 argumentos: mostra as linhas nesse intervalo
 * Se o primeiro argumento  negativo, a numerao das linhas 
 * suprimida.
 *
 * Sintaxe:
 * LINE [[-]arg1 [arg2]] < infile [ > outfile]
 *
 * Joao Magalhaes, 1997
 * jcm@individual.EUnet.pt
 */

/**************************************
 * LINE.C - ANSI C
 *
 * No arguments: displays all lines, numbered
 * 1 argument: displays the line with that number
 * 2 arguments: displays that line range
 * if the first argument is negative, line number are not displayed
 *
 * Syntax:
 * LINE [[-]arg1 [arg2]] < infile [ > outfile]
 *
 * Joao Magalhaes, 1997
 * jcm@individual.EUnet.pt
 */

#include <stdio.h>
#include <stdlib.h>

#define BUFLEN 4098	/* input line size */


/* Caso: nenhum argumento */
/* Case: no command line arguments */
void List(void)
   {
   char S[BUFLEN];
   long CurLine = 0;
   while(gets(S))
      {
      CurLine++;
      printf("[%ld] %s\n", CurLine, S);
      }
   }

/* Caso: 1 argumento */
/* Case: 1 command line argument */
void ListLine(long LineNum)
   {
   char S[BUFLEN], NoPrint;
   long CurLine = 0L;

   if (LineNum < 1)
      {
      LineNum *=(-1);
      NoPrint = 1;
      }
   else NoPrint = 0;

   while((gets(S)) && (CurLine <= LineNum))
      {
      CurLine++;
      if (CurLine != LineNum) continue;
      else
	 if (NoPrint) printf("%s\n", S);
	 else printf("[%ld] %s\n", CurLine, S);
      }
   }

/* Caso: 2 argumentos */
/* Case: 2 command line arguments */
void ListRange(long First, long Last)
   {
   char S[BUFLEN], NoPrint;
   long LineNum, Swap;

   LineNum = 0L;

   if (First < 1)
      {
      First *=(-1);
      NoPrint = 1;
      }
   else NoPrint = 0;

   if (Last < 1) Last *=(-1);

   if (First > Last)
      {
      Swap = First;
      First = Last;
      Last = Swap;
      }

   while((gets(S)) && (LineNum < Last))
      {
      LineNum++;
      if (LineNum < First) continue;
      else
	 if (NoPrint) printf("%s\n", S);
	 else printf("[%ld] %s\n", LineNum, S);
      }
   }



int main(int argc, char ** argv)
   {

   if (argc > 3) exit(1);

   if (argc == 1) List();

   if (argc == 2) ListLine( atol(argv[1]));

   if (argc == 3) ListRange( atol(argv[1]), atol(argv[2]));

   return 0;
   }
