'CLEANER cleans upper ASCII and NULLS from files
'
' $INCLUDE: 'qb.bi'

DECLARE FUNCTION exists (filename$)

DIM SHARED inregs AS RegTypeX, outregs AS RegTypeX
CONST YES = 1, NO = 0
  
	CLS
	infile$ = COMMAND$
	IF infile$ = "" THEN GOTO help
	OPEN infile$ FOR BINARY AS #1
	q = LOF(1)
	IF q = 0 THEN GOTO nofind
	outfile$ = "temp"
	OPEN outfile$ FOR OUTPUT AS #2
	GOSUB filename
	oldfile$ = file$ + ".OLD"
	IF exists(oldfile$) = YES THEN KILL oldfile$
HEADER:
	COLOR 15: PRINT "CLEANER "; : COLOR 7: PRINT "Fast non-ASCII, upper ASCII and NULL cleaner"
	PRINT "Cleaning "; infile$; "; making backup named "; file$; ".OLD"
	PRINT "Hit [Ctrl]+[Break] to terminate."
	GOSUB TIME
	time1 = TIMER
	PRINT " Start time  :"; newtime$
	PRINT " Total bytes :"; q
	PRINT " Est @130 bps:"; FIX(q / 130); "secs. "
	z = 0: x = 0: y = 0
	inline$ = INPUT$(q, #1)
	DO
		z = z + 1
		IF z = q + 1 THEN EXIT DO
		b$ = MID$(inline$, z, 1)
		b = ASC(b$)
		IF b = 9 OR (b > 31 AND b < 127) OR b = 10 OR b = 13 THEN
			o$ = o$ + b$
			ELSE y = y + 1
		END IF
	LOOP
FINISH:
	PRINT #2, o$
	CLOSE
	time2 = TIMER
noold:
	NAME infile$ AS oldfile$
	NAME "temp" AS infile$
	GOSUB TIME
	PRINT "    Removed  :"; y
	PRINT "Finish time  :"; newtime$
	secs = time2 - time1
	PRINT "Process rate :"; FIX(z / secs); "bps"
	PRINT "Process time :"; CINT(secs); "secs."
	END
'*************************** GENERAL SUBROUTINES ******************************
TIME:
	intime$ = TIME$                                     'current time changed
		 hour$ = MID$(intime$, 1, 2)                     'to newtime$
		 min$ = MID$(intime$, 4, 2)
		 sec$ = MID$(intime$, 7, 2)
		 hour = VAL(hour$)
			 IF hour < 12 THEN ampm$ = "am" ELSE ampm$ = "pm"
			 IF hour > 12 THEN hour = hour - 12
		 hour$ = STR$(hour)
	newtime$ = hour$ + ":" + min$ + ":" + sec$ + " " + ampm$
	RETURN
'****************************** HELP AND ERROR ROUTINES ***********************
help:
	PRINT " "
	PRINT "CLEANER cleans non - ASCII, upper ASCII and NULL characters from a file."
	PRINT "(c) 1990 David A. Wesson"
	PRINT " "
	PRINT "Syntax: CLEANER  [d:]filename.ext   "
	PRINT ""
	PRINT "  NOTE: Backup called filename.OLD will be made."
	END
nofind:
	PRINT "ERROR: No file by that name found."
	GOTO help
filename:                                       'splits infile$ into
		period = INSTR(infile$, ".")              'file$ and ext$
		IF period = 0 THEN
			file$ = UCASE$(infile$)
			ext$ = ""
		ELSE
			file$ = UCASE$(LEFT$(infile$, period - 1))
			ext$ = UCASE$(MID$(infile$, period + 1))
		END IF
		RETURN

FUNCTION exists (search$)
	 savefile$ = search$
	 inregs.ax = &H4E00
	 inregs.cx = 1     '3 for hidden
	 search$ = search$ + CHR$(0)
	 inregs.dx = SADD(search$)
	 inregs.ds = -1
	 CALL INTERRUPTX(&H21, inregs, outregs)
	 IF (outregs.flags AND 1) = 1 THEN
			exists = NO
	 ELSE
			exists = YES
	 END IF
	 search$ = savefile$
END FUNCTION

