/*  Copyright (C) 1993   Marc Stern  (internet: stern@mble.philips.be)  */

#define Uses_TProgram
#define Uses_TVMemMgr
#define Uses_MsgBox

#include "tvtools.h"
#include "tools.h"
#include <dir.h>
#include <conio.h>
#include <stdlib.h>
#include <process.h>
//#include <float.h>


int appSystem( char *cmd )
{
 int status;

 // Test if current drive is ready
 int disk = getdisk();

 for (;;)
    {
     status = test_drive( disk );

     if ( status & D_INVALID )
        {
         messageBox( mfOKButton,
                     "\03Current disk (%c:) is invalid.",
                     disk + 'A'
                   );
         return cmCancel;
        }

     // OK or write-protected
     if ( status & D_READABLE ) break;

     status = messageBox( mfOKCancel,
                          "\03Please insert a formatted disk\n"
                          "\03in drive %c:",
                          disk + 'A'
                        );
     if ( status != cmOK ) return cmCancel;
    }

 // free all buffers
 if ( TVMemMgr::safetyPoolExhausted() )
    TVMemMgr::resizeSafetyPool( 0 );
// also: while ( TBufListEntry::freeHead() );
// but not public

 // Save mouse state
// saveMouseState();

 // suspend critical error handler
 TProgram::application->suspend();

 clrscr();
 if ( cmd ) status = system( cmd );
 else { // Go to DOS and come back
       char *comspec = getenv("COMSPEC");
       if ( ! comspec ) comspec = "COMMAND";
       status = spawnlpe( P_WAIT, comspec, comspec, "/e:2000", NULL, environ );
     }
// _fpreset();  // To reset math co-processor

 // restore memory pool
 if ( TVMemMgr::safetyPoolExhausted() ) TVMemMgr::resizeSafetyPool();

 // resume critical error handler
 TProgram::application->resume();

 // Restore mouse state & redraw screen
// restoreMouseState();
//  Seems that mouse cursor is not redrawn until we move it ???

 // Redraw screen (already performed in restoreMouseState)
 TProgram::application->redraw();

 return status;
}
