
{*******************************************************}
{                                                       }
{       Graphics Vision Unit                            }
{                                                       }
{       Copyright (c) 1994 Stefan Milius                }
{                                                       }
{*******************************************************}

{ Portions Copyright (c) 1992 Borland International }

{
  GVTEXTS.TXT GVTEXTS.DOC GINFO.TXT NEW.TXT GV.VER
}

Unit GVTexts;

{$A+,B-,D+,F+,G+,O+,R-,S-,X+,I-}

Interface

Uses Objects;

const

{ language constants }

  lfEnglish = 0;
  lfGerman  = 1;

  Language: Byte = lfGerman;

{ Get a language-dependent string
}
  function GetStr(Key: Word): String;

{ Version 2.09-style functions
}
{$ifndef Windows}
  function PutTexts: PStrListMaker;
  procedure SetTexts(AList: PStringList);
  procedure MakeRezFile(AList: PStrListMaker);
{$endif}

{ Version 2.10-style functions
}
  procedure FreeTexts;
  procedure LoadTexts(GVLname: string);
  procedure StoreTexts(GVLname: string; List: PStrListMaker);
  procedure SetTextResource(AResource: PStream);

Implementation

{$ifdef Windows}
uses WinTypes, Strings, WinProcs, WinRes;
{$else}
uses WinRes;
{$endif}

const
{ Text stringlist
}
  Texts: PStringList = nil;

{$ifndef Windows}
{ old-style 
}

{ number of string indices per language }

  StrCount = 200;

function PutTexts: PStrListMaker;
var Str: PStrListMaker;
Begin
  Str := New(PStrListMaker, Init($4000, 100));
  With Str^ do Begin
    { english }
    Put(1, #13' No help available in this context.');
    Put(2, 'Help');

    Put(3, 'Input does not conform to picture:'#13' %s');
    Put(4, 'Invalid character in input');
    Put(5, 'Value not in the range %d to %d');
    Put(6, 'Input not in valid-list');

    Put(7, 'Clock');
    Put(8, 'Colors'); Put(9,'~G~roup'); Put(10,'~I~tem'); Put(11,'~C~olor');
    Put(12,'O~K~'); Put(13,'Cancel');

    Put(14, 'The graphic cannot be initialized. Please make sure that your'#13+
	    'Hardware does support the standard VGA mode.'#13+
	    'Eventually change the directory to your graphic driver'#13+
	    '(EGAVGA.BGI).');

    Put(15, 'Disk is write-protected in drive %c');
    Put(16, 'Critical disk error on drive %c');
    Put(17, 'Disk is not ready in drive %c');
    Put(18, 'Critical disk error on drive %c');
    Put(19, 'Data integrity error on drive %c');
    Put(20, 'Critical disk error on drive %c');
    Put(21, 'Seek error on drive %c');
    Put(22, 'Unknown media type in drive %c');
    Put(23, 'Sector not found on drive %c');
    Put(24, 'Printer out of paper');
    Put(25, 'Write fault on drive %c');
    Put(26, 'Read fault on drive %c');
    Put(27, 'Hardware failure on drive %c');
    Put(28, 'Bad memory image of FAT detected');
    Put(29, 'Device access error');
    Put(30, 'Insert diskette in drive %c');
    Put(31, 'Fatal error');

    Put(32, '    ~Enter~ Retry  ~Esc~ Cancel');
    Put(33, 'Mouse watcher');
    Put(34, 'Type Exit to return...');

    Put(35, '~N~ew'); Put(36,'~O~pen...'); Put(37,'~S~ave'); Put(38,'S~a~ve as...');
    Put(39, 'Save a~l~l'); Put(40, '~C~hange dir...'); Put(41,'~D~OS shell');
    Put(42, 'E~x~it');

    Put(43, '~U~ndo'); Put(44,'Cu~t~'); Put(45,'~C~opy'); Put(46,'~P~aste');
    Put(47, 'C~l~ear'); Put(48, 'Shift+Del'); Put(49,'Ctrl+Ins'); Put(50, 'Shift+Ins');
    Put(51, 'Ctrl+Del');

    Put(52, '~T~ile'); Put(53,'C~a~scade'); Put(54,'Cl~o~se all');
    Put(55,'~S~ize/Move'); Put(56,'~Z~oom'); Put(57, '~N~ext'); Put(58, '~P~revious');
    Put(59,'~C~lose'); Put(60,'Ctrl+F5'); Put(61,'Shift+F6');

    Put(62,'Find'); Put(63,'~T~ext to find'); Put(64,'~C~ase sensitive');
    Put(65,'~W~hole words only'); Put(66,'O~K~');Put(67,'Cancel');

    Put(68,'Replace'); Put(69,'~T~ext to find'); Put(70,'~N~ew text');
    Put(71,'~C~ase sensitive'); Put(72, '~W~hole words only');
    Put(73,'~P~rompt on replace'); Put(74,'~R~eplace all'); Put(75,'O~K~');
    Put(76,'Cancel');

    Put(77, 'Not enough memory for this operation.');
    Put(78, 'Error reading file %s.');
    Put(79, 'Error writing file %s.');
    Put(80, 'Error creating file %s.');
    Put(81, '%s has been modified. Save?');
    Put(82, #13'Save untitled file?');
    Put(83, 'Save file as');
    Put(84, '~N~ame');
    Put(85, #13+'Search string not found.');
    Put(86, #13'Replace this occurance?');
    Put(87, 'Clipboard'); Put(88,'Untitled');

    Put(89, #13'Too many files.');

    Put(90,' %-12s %-9s %3s %2d, %4d  %2d:%02d');

    Put(91,'Jan'); Put(92,'Feb'); Put(93,'Mar'); Put(94,'Apr'); Put(95,'May');
    Put(96,'Jun'); Put(97,'Jul'); Put(98,'Aug'); Put(99,'Sep'); Put(100,'Oct');
    Put(101,'Nov'); Put(102,'Dec');
    Put(103,'Directory');

    Put(104,'~F~iles'); Put(105,'~O~pen'); Put(106,'O~K~'); Put(107,'~R~eplace');
    Put(108,'~C~lear'); Put(109,'Cancel'); Put(110,'Help');

    Put(111, #13'Invalid drive or directory.');
    Put(112, #13'Invalid file name.');
    Put(113,'Drives');

    Put(114, 'Change Directory'); Put(115,'O~K~'); Put(116,'~C~hDir');
    Put(117,'~R~evert'); Put(118,'Help');  Put(119, 'Directory ~n~ame');
    Put(120,'Directory ~t~ree');

    Put(121, #13'Invalid directory.');

    Put(122, 'Warning'); Put(123,'Error'); Put(124,'Information');
    Put(125,'Confirmation');

    Put(126, '~Y~es'); Put(127, '~N~o'); Put(128,'O~K~'); Put(129,'Cancel');
    Put(130, 'O~K~'); Put(131,'Cancel');

    Put(132,'Window list'); Put(133, '~D~elete'); Put(134, 'Cancel'); Put(135, 'Help');
    Put(136, '~W~indows');

    { Deutsch }

    Put(StrCount +1, #13'Fr diesen Kontext gibt es keinen Hilfebildschirm.');
    Put(StrCount +2, 'Hilfe');

    Put(StrCount +3, 'Die Eingabe widerspricht der Maske: '#13' %s');
    Put(StrCount +4, 'In der Eingabe sind ungltige Zeichen');
    Put(StrCount +5, 'Wert nicht innerhalb des Bereichs %d bis %d');
    Put(StrCount +6, 'Eingabe nicht in der gltigen Liste');
    Put(StrCount +7,'Uhr');

    Put(StrCount +8, 'Farben'); Put(StrCount +9,'~G~ruppen');
    Put(StrCount +10,'~E~intrge');
    Put(StrCount +11,'~F~arbwahl'); Put(StrCount +12,'O~K~');
    Put(StrCount +13,'Abbruch');

    Put(StrCount +14,
      'Die Graphik kann nicht initialisiert werden. Bitte stellen Sie'#13+
      'sicher, da Ihre Hardware den Standard-VGA-Modus untersttzt.'#13+
      'ndern Sie eventuell den Pfad zu Ihrem Graphiktreiber'#13+
      '(EGAVGA.BGI).');

    Put(StrCount +15, 'Diskette in Laufwerk %c ist schreibgeschtzt');
    Put(StrCount +16, 'Kritischer Diskettenfehler in Laufwerk %c');
    Put(StrCount +17, 'Diskette in Laufwerk %c nicht bereit');
    Put(StrCount +18, 'Kritischer Diskettenfehler in Laufwerk %c');
    Put(StrCount +19, 'Datenfehler in Laufwerk %c');
    Put(StrCount +20, 'Kritischer Diskettenfehler in Laufwerk %c');
    Put(StrCount +21, 'Datenfehler in Laufwerk %c');
    Put(StrCount +22, 'Unbekannter Medientyp in Laufwerk %c');
    Put(StrCount +23, 'Sektor in Laufwerk %c nicht gefunden');
    Put(StrCount +24, 'Drucker hat kein Papier mehr');
    Put(StrCount +25, 'Fehler beim Schreiben auf Laufwerk %c');
    Put(StrCount +26, 'Fehler beim Lesen von Laufwerk %c');
    Put(StrCount +27, 'Hardware-Fehler bei Laufwerk %c');
    Put(StrCount +28, 'Fehlerhafte Speicherkopie der FAT ermittelt');
    Put(StrCount +29, 'Fehler beim Zugriff auf ein externes Gert');
    Put(StrCount +30, 'Diskette in Laufwerk %c einlegen');
    Put(StrCount +31, 'nicht behebbarer Fehler');

    Put(StrCount +32, '    ~Enter~ Nochmal  ~Esc~ Abbruch');
    Put(StrCount +33, 'Mausbeobachter');
    Put(StrCount +34, 'Tippen Sie Exit, um zurckzukehren...');

    Put(StrCount +35, '~N~eu'); Put(StrCount +36,'~f~fnen...'); Put(StrCount +37,'~S~peichern');
    Put(StrCount +38,'Speichern ~u~nter...'); Put(StrCount +39,'~A~lle speichern');
    Put(StrCount +40,'~V~erzeichnis wechseln'); Put(StrCount +41,'D~O~S aufrufen'); Put(StrCount +42, '~B~eenden');

    Put(StrCount +43,'~R~ckgngig'); Put(StrCount +44,'~A~usschneiden');
    Put(StrCount +45,'~K~opieren'); Put(StrCount +46,'~E~infgen');
    Put(StrCount +47,'~L~schen'); Put(StrCount +48,'Umschalt+Entf');
    Put(StrCount +49,'Strg+Einfg'); Put(StrCount +50,'Umschalt+Einfg'); Put(StrCount +51,'Strg+Entf');

    Put(StrCount +52, '~N~ebeneinander'); Put(StrCount +53,'~b~erlappend');
    Put(StrCount +54,'~A~lle schlieen');
    Put(StrCount +55, '~G~re/Position'); Put(StrCount +56,'~V~ergrern');
    Put(StrCount +57,'N~c~hstes'); Put(StrCount +58,'V~o~riges');
    Put(StrCount +59,'~S~chlieen'); Put(StrCount +60,'Strg+F5');
    Put(StrCount +61,'Umschalt+F6');

    Put(StrCount +62,'Text suchen'); Put(StrCount +63,'~S~uchen nach');
    Put(StrCount +64,'~G~ro./Kleinschreib.'); Put(StrCount +65,'~N~ur ganze Wrter');
    Put(StrCount +66,'O~K~'); Put(StrCount +67,'Abbruch');

    Put(StrCount +68,'Text ersetzen'); Put(StrCount +69,'~S~uchen nach');
    Put(StrCount +70,'~E~rsetzen durch'); Put(StrCount +71,'~G~ro./Kleinschreib.');
    Put(StrCount +72, '~N~ur ganze Wrter');  Put(StrCount +73,'~M~it Besttigung');
    Put(StrCount +74,'~A~lle ersetzen'); Put(StrCount +75,'O~K~');
    Put(StrCount +76, 'Abbruch');

    Put(StrCount +77, 'Nicht gengend Speicher fr diese Operation.');
    Put(StrCount +78, 'Fehler beim Lesen der Datei %s.');
    Put(StrCount +79, 'Fehler beim Schreiben der Datei %s.');
    Put(StrCount +80, 'Fehler beim Erzeugen der Datei %s.');
    Put(StrCount +81, '%s wurde verndert. Speichern?');
    Put(StrCount +82, 'Unbenannte Datei speichern?');
    Put(StrCount +83, 'Datei speichern als');
    Put(StrCount +84, '~N~ame');
    Put(StrCount +85, #13+'Gesuchter Text wurde nicht gefunden.');
    Put(StrCount +86, #13+#3'Ersetzen?');

    Put(StrCount +87,'Zwischenablage'); Put(StrCount +88,'Unbenannt');

    Put(StrCount +89,#13'Zu viele Dateien.');
    Put(StrCount +90, ' %-10s %-11s %3s %2d, %4d  %2d:%02d');

    Put(StrCount +91,'Jan'); Put(StrCount +92,'Feb'); Put(StrCount +93,'Mr');
    Put(StrCount +94,'Apr'); Put(StrCount +95,'Mai'); Put(StrCount +96,'Jun');
    Put(StrCount +97,'Jul'); Put(StrCount +98,'Aug'); Put(StrCount +99,'Sep');
    Put(StrCount +100,'Okt'); Put(StrCount +101,'Nov'); Put(StrCount +102,'Dez');

    Put(StrCount +103,'Verzeichnis');

    Put(StrCount +104,'~D~ateien'); Put(StrCount +105,'~f~fnen');
    Put(StrCount +106,'O~K~'); Put(StrCount +107,'~E~rsetzen');
    Put(StrCount +108,'En~t~fernen'); Put(StrCount +109,'Abbruch');
    Put(StrCount +110,'Hilfe');

    Put(StrCount +111,'Das angegebene Laufwerk oder Verzeichnis ist ungltig.');
    Put(StrCount +112, #13'Der angegebene Dateiname ist ungltig.');
    Put(StrCount +113,'Laufwerke');

    Put(StrCount +114, 'Verzeichnis wechseln'); Put(StrCount +115,'O~K~');
    Put(StrCount +116,'~C~hDir'); Put(StrCount +117,'~Z~urck');
    Put(StrCount +118,'Hilfe'); Put(StrCount +119,'Verzeichnis~n~ame');
    Put(StrCount +120,'Verzeichnis~b~aum');

    Put(StrCount +121,#13'Das angegebene Verzeichnis ist ungltig.');

    Put(StrCount +122, 'Warnung'); Put(StrCount +123,'Fehler');
    Put(StrCount +124,'Information'); Put(StrCount +125,'Besttigen');

    Put(StrCount +126, '~J~a'); Put(StrCount +127, '~N~ein');
    Put(StrCount +128, 'O~K~'); Put(StrCount +129, 'Abbruch');

    Put(StrCount +120, 'O~K~'); Put(StrCount +131,'Abbruch');

    Put(StrCount +132, 'Fensterliste'); Put(StrCount +133, '~L~schen');
    Put(StrCount +134, 'Abbruch'); Put(StrCount +135, 'Hilfe');
    Put(StrCount +136, '~F~enster');
  End;
  PutTexts := Str;
End;

procedure SetTexts(AList: PStringList);
Begin
  If Texts <> nil then Dispose(Texts, Done);
  Texts := AList;
End;

procedure MakeRezFile(AList: PStrListMaker);
var S: TDosStream;
Begin
  S.Init('GVSTR.REZ', stCreate);
  AList^.Store(S);
  S.Done;
End;
{$endif Windows}

{ Using GVL files 
}

const
  GVL: PStream = nil;

procedure LoadTexts(GVLname: string);
begin
  FreeTexts;
  GVL := New(PBufStream, Init(GVLName, stOpenRead, 4096));
  Texts := New(PStringList, Load(GVL^));
end;

procedure StoreTexts(GVLname: string; List: PStrListMaker);
var
  GVL: PStream;
begin
  GVL := New(PBufStream, Init(GVLname, stCreate, 4096));
  List^.Store(GVL^);
  Dispose(GVL, Done)
end;

{ Using Windows resources 
}
{$ifdef Windows}
var
  TheInstance: THandle;

procedure SetTextResource(AResource: PStream);
begin
  TheInstance := 0;
  If (AResource <> nil) and (TypeOf(AResource^) = TypeOf(TResStream))
  then TheInstance := PResStream(AResource)^.Instance
end;
{$else}
const
  Resource: PStream = nil;
  Blocks: PStringBlock = nil;

procedure SetTextResource(AResource: PStream);
begin
  Resource := AResource;
end;
{$endif Windows}

{ GetStr 
}

function GetStr(Key: Word): String;
var
{$ifdef Windows}
  Buf: array[0..255] of Char;
{$else}
  P: PString;
  B: PStringBlock;
{$endif Windows}
Begin
  If Texts <> nil
  then begin
    GetStr := Texts^.Get(Key);
    If AnsiCode
    then asm
	les	di, @Result
	push	es
	push	di
	call	AnsiFrom437Str
    end
  end else
  {$ifdef Windows}
  begin
    WinProcs.LoadString(TheInstance, Key, Buf, 256);
    If not AnsiCode then AnsiTo437(Buf);
    GetStr := StrPas(Buf);
  end
  {$else}
  if Resource <> nil
  then begin
    P := GetStringFromBlock(Blocks, Key);
    If P = nil
    then begin
      B := LoadStringBlock(Resource^, Key);
      If B = nil
      then B := NullStringBlock(Key);
      B^.sbNext := Blocks;
      Blocks := B;
      P := GetStringFromBlock(Blocks, Key)
    end;
    GetStr := P^
  end
  else
    GetStr := ''
  {$endif Windows}
End;

procedure FreeTexts;
{$ifndef Windows}
var
  N: PStringBlock;
{$endif Windows}
begin
  If Texts <> nil
  then begin
    Dispose(Texts, Done);
    Texts := nil
  end;
  If GVL <> nil
  then begin
    Dispose(GVL, Done);
    GVL := nil
  end;
  {$ifndef Windows}
  If Blocks <> nil
  then begin
    while Blocks <> nil do
    begin
      N := Blocks^.sbNext;
      FreeStringBlock(Blocks);
      Blocks := N
    end;
    Blocks := nil;
  end;
  Resource := nil
  {$endif Windows}
end;

{$ifdef Windows}
begin
  TheInstance := HInstance
{$endif Windows}
End.
