
{ **************************************************************************
  *                                                                        *
  *                         FileRead Test Program #2                       *
  *                         ========================                       *
  *                                                                        *
  *  Description:                                                          *
  *                                                                        *
  *       This program is similar to program #1 with the exception that    *
  *  instead of using a record as the storage, we are using a word.        *
  *  This shows that you can use almost any type to store in a file, as    *
  *  long as what you are storing in the file stays consistent.            *
  *                                                                        *
  ************************************************************************** }

Program Test_FileRead_2;

uses
  Crt,FileRead;

Procedure Main;
var
  MyFile : TFreadPtr;  { an instance of the TFread object }
  i      : integer;    { loop variable }
  temp   : string;     { temp string for processing integers }
  f      : file;       { temp file for deleting old version of TOM.GAG }
  Number : Word;       { instead of a record, let's create a file of words!}
Begin

  { Let's initialize a file object and create a new file. }
  New(MyFile,Init('INFO.DAT',Create,SizeOf(Number)));

  { Let's do some stuff with our new file. }
  with Myfile^ do
  begin
    randomize;
    for i:=1 to 100 do
    begin
      Number:=random(65535);
      AppendRec(Number);
    end;
    { Try to rename the file. }
    if not RenameFile('TOM.GAG') then
    begin
      { If we cannot, then delete previous version of TOM.GAG. }
      Assign(f,'TOM.GAG');
      erase(f);
      { And try one more time. }
      if not RenameFile('TOM.GAG') then
      begin
        { if we cannot rename this time, then just give up. }
        Writeln('Still having trouble renaming file!');
        halt(1);
      end;
    end;
    { If we can rename the file, then read the first record. }
    ReadRec(Number,0);
    if ReadError then
      { if a read error occured, then just close and quit. }
      writeln('Oops, dude, and error hath occurred!')
    else
    begin
      { go through the file sequentially forward, printing the name
        field of the particular record. }
      while not ReadError do
      begin
        Writeln(GetCurrent:4,':  ',Number);
        ReadNext(Number);
      end;
      writeln;
      write('Press a key to go backwards!');
      readln;
      writeln;
      { Let's go backward now! }
      ReadCurrent(Number);
      while not ReadError do
      begin
        Writeln(GetCurrent:4,':  ',Number);
        ReadPrevious(Number);
      end;
    end;
  end;
  { Okay, close file and clean house. }
  Dispose(Myfile,Done);
End;

Begin
  Main;
End.