program EnvironmentTest; {             Version 2.0            88/09/15

Demonstrates ENVUNIT.PAS, handy little routines to simplify using the
environment string.

COMPILE TO _DISK_ AND RUN FROM INSIDE THE TURBO INTEGRATED ENVIRONMENT
to simulate nested programs (ie. one program "exec"ed by another).

This program is hereby donated to the public domain. It may be freely copied,
used & modified without charge or fee.

Author        :  Mike Babulic
                 3827 Charleswood Dr. N.W.
                 Calgary, Alberta
                 CANADA
                 T2L 2C7
Compuserve ID :  72307,314

}

  uses CRT,Dos,EnvUnit;

  procedure Wait;
   begin
     write('Press Return');
       readln;
     GotoXY(WhereX,WhereY-1);
       ClrEol;
   end;

  var SomeFile: string;
      oldPSP: word;
      i : integer;

  begin
    writeln;
    writeln('DOS Version ',Dos_Version/100.0:2:2);
    writeln;
    writeln('Program Path = ',MyPath);
    writeln('        Dir  = ',MyDir );
    writeln('        Name = ',MyName);
    writeln('        Ext  = ',MyExt );
    repeat
      oldPSP := PSP;
      UseParentPSP;
      if oldPSP <> PSP then begin
        writeln;
        writeln('Parent  Name = ',ProgName);
        writeln('        Path = ',ProgPath);
      end;
    until oldPSP = PSP;
    {UseRootPSP;} {don't need this 'cause we're already at the root}
    writeln;
    writeln('Root    Name = ',ProgName);
    writeln('        Path = ',ProgPath);
    UseMyPSP;
    wait;

    writeln;writeln(EnvCount,' Environment Strings...');
    writeln('     ',FirstEnv);
    while not EOEnv do
      writeln('     ',NextEnv);
    wait;

    writeln;writeln('Using the EnvStr() function...');
    for i := 1 to EnvCount do
      writeln(i:3,') ',EnvStr(i));
    wait;

    somefile := 'COMSPEC';
    writeln;writeln('GetEnv(''',somefile,''')...');
      writeln('     ',GetEnv(somefile));
    wait;

    writeln;writeln('Named Strings...');
    writeln('     ',FirstNamed('PATH',';'));
    while not EONamed do
      writeln('     ',NextNamed);
    wait;

    writeln;writeln('Paths...');
    writeln('     ',FirstPath);
    while not EONamed do
      writeln('     ',NextPath);
    wait;

    SomeFile := 'envunit.tpu';
    writeln;writeln('FSearch(''',somefile,''',GetEnv(''path''))...');
    writeln('     ',FSearch(somefile,GetEnv('path')));
    writeln;writeln('FExpand(''..''))...');
    writeln('     ',FExpand('..'));
    writeln;writeln('PathTo(''',somefile,''')...');
    writeln('     ',PathTo(somefile));
    writeln;writeln('FFind(''',somefile,''')...');
    writeln('     ',FFind(somefile));
    wait;
  end.