{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Strings/Strip.pas                [x] Protected mode

  This example shows how a string can be stripped, that is, how leading
  and trailing occurrences of (chained) substring(s) can be removed.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;


uses EFSTRING;

var Stripped, A : tToken;

begin

     A.Initialize (' I''m stripped.  ');
     A.Append ( Endl ); { End each string with CR/LF }
     A.Insert ( Endl, 0 );

     Stripped.InitializeEmpty;
     Stripped.Fill (@A, 3); { Fill with 3 * A }

     { Strip CR/LF and blank spaces in the beginning and end
       of the string. }

     Stripped.Strip (DefaultDelimeters { = CR/LF and SPACE } );
     WriteLn ('<', Stripped.Pascal, '>');

end.