{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Datatype/Duplicat.pas            [x] Protected mode

  Demonstration of how data types can be duplicated into new instances.
  The polymorphic design gives all linear ADT's these capabilities.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFDEF, EFKERNEL, EFADT, EFARRAY, EFLIST;


var Data1, Data2 : pLinearADT;
    SomeData : string;

begin
     { Initialize a linked list }
     Data1 := New( pList,
                   Initialize ( SizeOf(String) ) );
                               { Element size }

     { Add some data }
     SomeData := 'First element';  Data1^.Store (SomeData);
     SomeData := 'Second element'; Data1^.Store (SomeData);
     SomeData := 'Third element';  Data1^.Store (SomeData);
     SomeData := 'Forth element';  Data1^.Store (SomeData);

     { Duplicate first data type into a new array list }
     Data2 := New( pArray, Duplicate (Data1));
     Data1^.Free; { Dispose the first data type (the linked list) }
     WriteLn ('* "Duplicated" linked list into an array *');


     { Create a iterator and perform a task with all elements }

     with Data2^.CreateIterator^ do begin

          repeat
                Write (String(Content^));
                WalkForward; { Next element! }
                if not IsEnd then Write (', ') else WriteLn ('.');
          until IsEnd; { Condition; end is reached }

          Free; { Iterator }

     end;

     Data2^.Free; { Dispose the second data type (the array list) }
end.