/* TCHK 2.1 - Howard Kapustein's Turbo C library        6-6-89      */
/* Copyright (C) 1988,1989 Howard Kapustein.  All rights reserved.  */

/* mathhk.h  -  header file for MATHHK.C - math functions */

#ifndef MATHHK_HEADER
#define MATHHK_HEADER   1

#define SQRT2   1.41421356237309504880
#define PI  3.141592653589793238462643
#define E   2.7182818284590452353602874

#define sqr(x)      ((x) * (x))
#define isgn(x)     ((x) < 0 ? -1 : 1)
#define lsgn(x)     ((x) < 0l ? -1 : 1)
#define fsgn(x)     ((x) < 0.0 ? -1 : 1)
#define sgn(x)      isgn(x)
#define sign(x)     isgn(x)
#define lsign(x)    lsgn(x)
#define fsign(x)    fsgn(x)
#define swap(x,y)   (x ^= y, y^= x, x^=y)
#define mid(a,x,b)  ((((a) <= (x)) && ((x) <= (b))) ? 1 : 0)
#define nmid(a,x,b) ((((x) < (a)) || ((b) < (x))) ? 1 : 0)
#define iseven(x)   (((x) % 2 == 0) ? TRUE : FALSE)
#define isodd(x)    (!iseven(x))

#define MAXFLOAT           3.4E+38
#define MAXDOUBLE          1.7E+308
#define MAXLONG            2147483647   /* 2,147,483,647 */
#define MAXLONG_UNSIGNED   4294967295   /* 4,294,967,295 */


/* function prototypes */
double round(double x, int n);         /* round x to n decimal places */
double frac(double x);                 /* return fractional portion of real */
double factorial(int n);               /* n! */
int summation(int max);                /* : 1+2+...+max */
double average(int n, double element[]);    /* average (mean) */
double variance(int n, double element[]);   /* variance */
double stddev(int n, double element[]);     /* standard deviation */
unsigned char bitrevb(unsigned char value); /* bit reverse - byte */
unsigned int bitrevw(unsigned value);       /* bit reverse - word */
unsigned long bitrevl(unsigned long value); /* bit reverse - long */

#endif              /* MATHHK_HEADER */
