/* TCHK 2.1 - Howard Kapustein's Turbo C library        6-6-89      */
/* Copyright (C) 1988,1989 Howard Kapustein.  All rights reserved.  */

/* doshk.h  -  header file for DOSHK.C - DOS routines */

#ifndef DOSHK_HEADER
#define DOSHK_HEADER    1

#include <howard.h>

typedef struct BIOSParmBlock {              /* BIOS Parameter Block */
            unsigned int BytesPerSector;         /* bytes per sector */
            byte         SectorsPerAllocUnit;    /* sectors per cluster */
            unsigned int ReservedSectors;        /* reserved sectors (for boot record) */
            byte         numberFATs;             /* number of FAT copies */
            unsigned int numberRootDirEntries;   /* number of root directory entries */
            unsigned int TotalSectors;           /* total number of sectors */
            byte         MediaDescriptor;        /* media desriptor byte */
            unsigned int SectorsPerFAT;          /* sectors per FAT */
        };

typedef struct BootBlock {                  /* Boot Block */
            byte JumpInstr[3];
            byte OEMinfo[8];
            struct BIOSParmBlock BPB;
            unsigned int SectorsPerTrack;        /* sectors per track */
            unsigned int numberHeads;            /* number of heads (sides) */
            unsigned int numberHiddenSectors;    /* number of hidden sectors */
        };

typedef struct BootBlock4 {                 /* Boot Block (DOS 4.x) */
            byte JumpInstr[3];
            byte OEMinfo[8];
            struct BIOSParmBlock BPB;
            unsigned int SectorsPerTrack;        /* sectors per track */
            unsigned int numberHeads;            /* number of heads (sides) */
            unsigned long numberHiddenSectors;   /* number of hidden sectors */
            unsigned long TotalnumberSectors;    /* total number of sectors */
            byte Physicaldrive;                  /* physical drive number */
            byte reserved1[1];                   /* (reserved - 1 byte) */
            byte Signaturebyte;                  /* signature byte (shoud be 0x29) */
            unsigned long VolumeSerialNumber;    /* volume serial number */
            char VolumeLabel[11];                /* volume label */
            byte reserved2[8];                   /* (reserved - 8 bytes) */
        };

/* Format prototypes */
boolean getBPB(int drive, struct BIOSParmBlock *BPB);    /* get BIOS Parameter Block (A=0, B=1,...) */
boolean getBootBlock(int drive, struct BootBlock *BB);   /* get Boot Block */
boolean getBootBlock4(int drive, struct BootBlock4 *BB4);/* get Boot Block (DOS 4.x) */
boolean getVolSerialNum(int drive, unsigned long *serialnum);   /* get volume serial number (DOS 4.x) */

/* Memory prototypes */
int memory_strategy(boolean read, int *strategy);        /* get/set mem alloc strategy */
boolean isXMSinstalled(void);           /* is XMS installed */

/* Software prototypes */
boolean isAssignavail(void);            /* is ASSIGN installed */
unsigned getAssignmemseg(void);         /* get segment of ASSIGN work area */
boolean isAppendavail(void);            /* is APPEND installed */
boolean isVidclock(void);               /* is VIDCLOCK.COM installed */
boolean isScrnSav2(void);               /* is SCRNSAV2.COM installed */
boolean isAutoPark(void);               /* is AUTOPARK.COM installed */
void setAutoPark(unsigned long count);  /* set parking delay, count * 55ms timer ticks */
int isShareavail(void);                 /* is SHARE installed */
boolean isCEDavail(void);               /* is CED installed */
boolean CEDremove(char *command);       /* delete/remove installable command */
boolean CEDadd(char *command, unsigned char mode, unsigned segment, unsigned offset);   /* add CED installable command */
boolean ispcAnywhere(void);             /* is pcAnywhere installed */
void SetpcAnywhere(boolean enabled);    /* Enable/Disable pcAnywhere */
unsigned char isDriverSys(void);        /* is Driver.Sys installed */
unsigned char isNLSFuncCom(void);       /* is NLSFUNC.COM installed */
boolean isWhoa(void);                   /* is WHOA!.COM installed */
boolean uninstallWhoa(void);            /* uninstall WHOA!.COM */
boolean setWhoa(unsigned int delaycount);   /* set delay count for WHOA!.COM */
boolean isAnarkey(void);                /* is ANARKEY.COM installed */

/* Device prototypes */
int isremovable(char drive);            /* is device fixed */
int iscdevicemoderaw(int handle);       /* is character device in "raw"/binary or "cooked" mode */
int setcdevicemode(int handle, boolean setraw); /* set character device to "raw"/binary mode ? */
int ishandlelocal(int handle);          /* is handle local (MSNetwork) or remote (redirected to server) */
int isdrivelocal(int drive);            /* is drive local (MSNetwork) or remote (redirected to server) */
boolean isRedirectStdin(void);          /* is stdin redirected */
boolean isRedirectStdout(void);         /* is stdout redirected */

/* DOS prototypes */
boolean commit(int handle);             /* flush disk buffer for a handle */
char *resolvepath(char *str, char *buffer); /* resolve a path to a fully qualified path (DOS 3.x) */

/* DOS date/time stamp macros */
#define doshour(h)          ((h & 0xF800) >> 11)
#define dosmin(m)           ((m & 0x07E0) >> 5)
#define dossec(s)           (s & 0x001F)
#define todostime(h,m,s)    (((h << 11) & 0xF800) | ((m << 5) & 0x07E0) | (s & 0x001F))
#define dosyear(y)          ((y & 0xFE00) >> 9)
#define dosmonth(m)         ((m & 0x01E0) >> 5)
#define dosday(d)           (d & 0x001F)
#define todosdate(y,m,d)    (((y << 9) & 0xFE00) | ((m << 5) & 0x01E0) | (d & 0x001F))

#endif              /* DOSHK_HEADER */
