/* ================================================
** dosfns.h -- Miscellaneous routine to call MS-DOS
**		system functions or perform system
**		specific tasks.
** ================================================
*/

/* getdfs -- Get Disk Free Space.  Returns
**		information on disk capacity
**		and available space.
**	Input:
**		drive = target drive (A=0, B=1,...)
**
**	Output:
**		avail = number of available clusters
**		total = total clusters on disk
**		sectsize = bytes/sector for disk
**	Returns:
**		Number of sectors per cluster
**		-1 if drive has invalid sectors/cluster
*/
getdfs(drive, avail, total, sectsize)
int drive;
unsigned *avail, *total, *sectsize;
{
	union REGS regs;
	
	regs.x.dx = drive+1;
	regs.x.ax = 0x3600;
	intdos(&regs, &regs);
	*avail = regs.x.bx;
	*total = regs.x.dx;
	*sectsize = regs.x.cx;
	return(regs.x.ax);
}
/* parse -- Parse filename into FCB.  This
**		function takes a command line and
**		parses it for a file name of the form
**		d:filename.ext.
**
**		Bits in mode control parsing:
**
**		bit 0=1 : ignore leading separators
**		bit 1=1 : change drive id only if one given
**		bit 2=1 : change filename only if one given
**		bit 3=1 : change extension only if one given
**
**		returnse -1 if drive invalid
*/
parse(filename, fcb, mode)
char filename[];
struct ext_fcb *fcb;
int mode;
{
	union REGS regs;
	struct SREGS segregs;		/* V3.0 is union SREGS segregs; */
	
	regs.x.si = (unsigned) filename;
	segread(&segregs);
	segregs.es = segregs.ds;
	regs.x.di = (unsigned) fcb;
	regs.h.al = (unsigned char) mode;
	regs.h.ah = 0x29;
	intdosx(&regs, &regs, &segregs);
	return((int) regs.h.al);
}
/* setdta -- Set Disk Transfer Address.
**		Sets the DOS disk transfer address
**		to the address of buffer.
*/
setdta(buffer)
char buffer[];
{
	union REGS regs;
	
	regs.x.ax = 0x1A00;
	regs.x.dx = (unsigned) buffer;
	intdos(&regs, &regs);
}
/* search_first -- Search for First Directory Entry
**		On entry fcb contains an extended
**		File Control Block with file name
**		and attribute bits set.  On exit
**		fcb contains matched entry unless
**		return code is 255, in which case
**		no match was found.
*/
search_first(fcb)
struct ext_fcb *fcb;
{
 	union REGS regs;
	
	regs.x.ax = 0x1100;
	regs.x.dx = (unsigned) fcb;
	intdos(&regs, &regs);
	return((int) regs.h.al);
}
/* search_next -- Search for Next Directory Entry.
**		Same as search_first except for
**		use on subsequent calls.
*/
search_next(fcb)
struct ext_fcb *fcb;
{
 	union REGS regs;
	
	regs.x.ax = 0x1200;
	regs.x.dx = (unsigned) fcb;
	intdos(&regs, &regs);
	return((int) regs.h.al);
}
/* current_drv -- This function returns the drive number
**		of the current default drive (A=0,
**		B=1, C=2, etc.).
*/
current_drv()
{
	union REGS regs;
	
	regs.x.ax = 0x1900;
	intdos(&regs, &regs);
	return((int) regs.h.al);
}
/* select_drv -- This function changes the current default
**		drive to the specified drive (A=0,
**		B=1, C=2, etc.).  Returns the total number of
**		drives.
*/
select_drv(drv)
int drv;
{
	union REGS regs;
	
	regs.x.ax = 0x0E00;
	regs.x.dx = (unsigned) drv;
	intdos(&regs, &regs);
	return((int) regs.h.al);
}
/* get_table -- This function return a "far" pointer to
**		the parameters table for the specified
**		disk drive (A=0, B=1, etc.).
*/
struct disk_table far *get_table(drv)
int drv;
{
	struct disk_table far *t;
	
	union REGS regs;
	struct SREGS segregs;
	
	regs.x.ax = 0x3200;
	regs.x.dx = drv+1;
	segread(&segregs);
	intdosx(&regs, &regs, &segregs);
	FP_SEG(t) = segregs.ds;
	FP_OFF(t) = regs.x.bx;
	return(t);
}
/* dtoa -- Takes date in Microsoft packed
**		format and converts it to an ASCII
**		string as : "Mmm, dd, yr"
*/
dtoa(date, s)
struct ms_date date;
char s[];
{
	static char *mo_str[] = {
		"Jan", "Feb", "Mar", "Apr", "May", "Jun",
		"Jul", "Aug", "Sep", "Oct", "Nov", "Dec"
	};
	
	strcpy(s,"        ");
	if (date.m  != 0)
	  sprintf(s, "%s %2d, %4d",
	    mo_str[date.m-1], date.d, date.y+1980);
}
/* ttoa -- Takes time in Microsoft packed
**		format and converts it to an ASCII
**		string as : "HH:MMx", where x is
**		'a' for A.M. and 'p' for P.M.
*/
ttoa(time, s)
struct ms_time time;
char s[];
{
	int hr;
	char am_pm;
	
	hr = time.hh;
	strcpy(s, "      ");
	if ((hr != 0) || (time.mm != 0) || (time.xx != 0)) {
		am_pm = (hr >= 12) ? 'p' : 'a';
		hr %= 12;
		if (hr == 0)
		  hr += 12;
		sprintf(s, "%2d:%02d%c", hr, time.mm, am_pm);
	}
}
/* fatval -- This function calculates the logical
**		"chaining" of cluster numbers in a File
**		Allocation Table.  Given an entry
**		cluster number it calculates the next
**		cluster using the array fat[].
**
**		If is12 is TRUE then fat[] is assumed to
**		contain 12 bit entries, otherwise fat[]
**		is assumed to contain 16 bit entries.
*/
fatval(is12, cluster, fat)
int is12;
unsigned cluster;
unsigned char fat[];
{
	unsigned clword, cloffset;
	
	if (is12) {
		/* 12 bit FAT lookup */
		cloffset = 3*cluster/2;
		clword = fat[cloffset] + (fat[cloffset + 1] << 8);
		if (cluster & 1)
		  return(clword >> 4);  /* odd cluster */
		else
		  return(clword & 0x0FFF);	/* even cluster */
	}
	else
	  /* 16 bit FAT lookup */
	  return(((unsigned int *) fat)[cluster]);
}
