' FMSVER.BAS v1.20
'
' Verify that files listed in your RBBS-PC FMS directory actually exist,
' and update file sizes accordingly.
'
' July 4, 1994
'
' Copyright (C) 1989, 1990, 1991, 1994 Chip Morrow
' 
' * NOTES *
'
'                 ------- Late 1989 to January 1990 -------
'
'           Thanks to Randy Sun of Sigma Industries RBBS for all the
'           input, suggestions, and examples of advanced FMS directory
'           structures to play with, as well as the original idea, and
'           for testing the early stuff on his equipment.
'
'                 ----------- February 4, 1990 ------------
'
'           Finally started on the first public release (1.00).
'
'           Modified the source for compile with Crescent Software's
'           PDQ library. First test compile = 25% of the original
'           executable file size.
'
'           Took the "byte", and heavily commented the source code.
'
'           Patched PDQ.LIB and Tom Hanlin's ADVBAS.LIB to support
'           file sharing for all file opening. Thanks to Mike Ervin
'           of the Radius BBS for pointing me in the right direction
'           on this one!
'
'                 ------------ February 5, 1990 ------------
'
'           Added third command line variable for trashcan file.
'           Starting on cleaning up the display for first release.
'
'                 ------------ February 6, 1990 -------------
'
'           Released version 1.00b.
'
'                 ------------ February 7, 1990 -------------
'
'           Fixed a bug in 1.00b that was causing input past end of
'           file. Released as 1.01b.
'
'                 ------------ February 14, 1990 ------------
'
'           Finished commenting the code, finished cleaning up the
'           unneeded vars, etc. Started on next version.
'
'                 -------------- June 30, 1990 --------------
'
'           Added support for up to 20 subdirectories. Added support
'           for \FMS TOP.
'
'                 -------------- July 7, 1990 ---------------
'
'           Added support for private filenames preceded by an equals
'           '=' sign, and the RBBS-supported FMS comments preceded by
'           a backslash or an asterisk.
'
'           Released version 1.04.
'
'                 -------------- July 9, 1991 ---------------
'            
'           A whole year since the last update??  Upped max file
'           directories to 50.  Rewrote the code slightly (although
'           it's still in dire need).
'
'                 -------------- July 4, 1994 ---------------
'
'           Wow, only 3 years since the last update!  Now supports
'           up to 10 extended description lines for each file, and
'           is linked to the most recent version of Crescent Sofware's
'           PDQ library (v3.12).
'
' Chip Morrow - Sysop
' Information Overload
' Fidonet 1:226/730
' Public BBS Node (614) 837-0739
'
' Command lines used to compile this program with QB 4.5 and PDQ 3.12:
'
' bc fmsver /o;
' link fmsver+_str$+_noval+_noread+_noerror+_nofield/nod/noe,,nul,pdq

DEFINT A-Z                                         ' Everybody's an integer

DECLARE FUNCTION PDQVALI% (A$)                     ' PDQ integer value convert
DECLARE FUNCTION PDQExist% (A$)                    ' PDQ file exist function

REDIM Directory$(1 to 50)                          ' Max of 50 directories
REDIM Extend$(1 to 11)                             ' 10 extended description
                                                   ' lines  (0794)

VERSION$ = "FMSVER v1.20 - 07/04/94"               ' Current version
Cls 
config.file$ = "FMSVER.CNF"                        ' Config file name
Yes = PDQExist(Config.File$)                       ' Is config file present?
IF YES THEN GOTO CONTINUE                          ' Yep, branch accordingly
'
' ***************************************************************
' * THIS BLOCK OF CODE EXECUTED ONLY IF CONFIG FILE NOT PRESENT *
' ***************************************************************
'
A$ = "Configuration file " + Config.File$ + " not found."
B$ = "Press [ENTER] at any of the following prompts to abort."   ' 120
C$ = "Enter number of download directories in your system: "     ' 120

Call PDQPRINT (A$, 3, 1, 14)                       ' PDQPRINT is a direct
Call PDQPrint (B$, 5, 1, 14)                       ' screen write with color,
Call PDQPrint (C$, 7, 1, 3)                        ' PRINT is a bios write.

Locate 7,57                                        ' Set the cursor

CALL PDQINPUT (a$)                                 ' Get number of dirs in A$
  If PDQvalI(a$) < 1 then end                      ' No dirs? Goodbye.
  If PDQVALI(a$) > 50 then                         ' More than 50 dirs?
     print "Sorry, 50 directories max." : end      ' Goodbye.
  End If

Close #1                                           ' Number of dirs OK.

Open "FMSVER.CNF" for output as #1                 ' Open config file.
Print #1,a$                                        ' Number of dirs on line 1.

    For x = 1 to PDQvalI(a$)                       ' ** START OF LOOP **

      p$ = "Directory path #" + str$(x) + " --> "
      Print p$;                                    ' Ask for subdir name
      Call PDQinput (b$)                           ' Get it from keyboard

      If b$ = "" then                              ' If nothing was entered
          close #1 : kill "FMSVER.CNF" : end       ' Delete config file & exit.
      End If

      b$ = ucase$(b$)                              ' Subdir name to all caps
      if right$(b$,1) <> "\" then b$ = b$ + "\"    ' Add a backslash if needed
      Print #1,b$                                  ' Send it to the config file

    Next                                           ' ** END OF LOOP **

Print "Path/Filename of FMS directory --> ";       ' Ask for FMS dir name
CAll PDQinput (b$)                                 ' Get it from keyboard
If b$ = "" then                                    ' If nothing was entered
   close #1 : kill "FMSVER.CNF" : end              ' Delete config file & exit.
End If
b$ = ucase$(b$)                                    ' FMS name to all caps
Print #1, b$                                       ' Send it to the config file
Print "Path/Filename of new FMS to be created --> "; ' Ask for output filename
Call PDQinput (c$)                                 ' Get it from keyboard
If c$ = "" then                                    ' If nothing was entered
   close #1 : kill "FMSVER.CNF" : end              ' Delete config file & exit.
End If
c$ = ucase$(c$)                                    ' Output file in all caps
If b$ = c$ then                                    ' If FMS = output file
   Print "Input and output filenames cannot be identical!"
   Close #1 : Kill "FMSVER.CNF" : end              ' Delete config file & exit.
End If
Print #1,c$                                        ' Send it to config file
Close #1                                           ' Save config file.
Print
Print "We have:"
Print
Open "FMSVER.CNF" for input shared as #1           ' Re-open config file
input #1,a$                                        ' Get number of dirs
Print a$ " download directories, which are:"       ' Tell the user about it
  For x = 1 to PDQvalI(a$)                         ' ** START OF LOOP **
    input #1,b$                                    ' Get a subdir name
    Print b$                                       ' Display it
  Next                                             ' ** END OF LOOP
Print
input #1,a$                                        ' Get FMS filename
Print "FMS directory is "a$                        ' Stick it on screen
input #1,new$                                      ' Get output filename
Print "New filename to be created by this program is "new$ ' Do the same
close #1                                            ' So much for that
Print
1 print "Is the above correct? ";                  ' Is it right?
  CAll PDQinput (a$)                               ' Get response from keyboard
  if a$ = "" then goto 1                           ' If nothing, try again
  a$ = ucase$(left$(a$,1))                         ' Worry about 1st char only

  If a$ = "Y" then                                 ' Yep, it's right.
     print "Configuration file FMSVER.CNF saved "; ' File is already saved,
     print "on default drive."                     ' but let's tell them about
     End                                           ' it and exit to DOS.
  End If

  If a$ = "N" then                                 ' Nope, it wasn't right.
     kill "FMSVER.CNF"                             ' Delete config file
     print "Configuration file FMSVER.CNF deleted." 'Tell them about it
     end                                           ' Exit to DOS
  End If
  goto 1                                           ' Invalid response, go back
'
' ********************************************************
' * CONFIG FILE EXISTS, SO OPEN IT AND GET WHAT WE NEED. *
' *             (NORMAL RUN STARTS HERE)                 *
' ********************************************************
'
CONTINUE:
  OPEN CONFIG.FILE$ FOR INPUT SHARED AS #1         ' Open the config file
  INPUT #1, DIRS                                   ' Get number of dirs
    IF DIRS = 0 THEN                               ' We can't handle zero
       PRINT "Configuration file FMSVER.CNF not valid." ' Tell them about it
       END                                         ' Exit to DOS
    END IF
    IF DIRS > 50 THEN                              ' Too many dirs
       PRINT "FMSVER can handle a maximum of 50 "; ' Tell them about it
       PRINT "file directories."                   ' and
       PRINT "Redo the FMSVER.CNF file." : END     ' Exit to DOS
    END IF

  FOR X = 1 TO DIRS                                ' ** START OF LOOP **
    LINE INPUT #1, Directory$(X)                   ' Get subdir name
    If Len(Directory$(X)) > MaxFileLen Then        ' Determine longest subdir
       MaxFileLen = Len(Directory$(X))             ' name.
    End If
  NEXT                                             ' ** END OF LOOP **
 
   MaxFileLen = MaxFileLen + 14                    ' Add 14 for filename, etc.

   LINE INPUT #1, MASTER.DIR$                      ' Get filename of FMS dir
   IF COMMAND$ = "" THEN                           ' If no arguments passed...
     Yes = PDQExist(Master.Dir$)                   ' Is the FMS lurking about?
     IF YES THEN GOTO 10                           ' Yep, so jump to line #10.
     PRINT "FMS directory "; MASTER.DIR$; " not found."  'Nope, it's not here.
     END                                           ' Nothing to do, so exit.
   END IF
 
' ************************************************************************
' * FMS DIRECTORY AND NEW DIRECTORY NAME WERE INPUT ON THE COMMAND LINE. *
' ************************************************************************

 3 SPLIT.FLAG = 0                                  'This block of code
   Split1$ = ""                                    'splits the command line
   Split2$ = ""                                    'into these three variables.
   Split3$ = ""
   FOR X = 1 TO LEN(COMMAND$)                      ' ** START OF LOOP **
     TEST$ = MID$(COMMAND$,X,1)                    ' Individual character

     IF TEST$ <> chr$(32) and _                    ' It's not a blank,
        TEST$ <> chr$(255) and _                   ' not an ascii blank,
        Split.Flag = 0 then _                      ' nor have we seen any,
        Split1$ = Split1$ + TEST$ : GOTO 4         ' so it's part of FMS name.

     IF TEST$ = chr$(32) or test$ = chr$(255) then ' we have a blank, so
        Split.Flag = (Split.Flag + 1)              ' incrememt variable counter
        Goto 4                                     ' and get next character
        END IF

     IF Split.Flag = 1 then _                      ' It's part of output name
        Split2$ = Split2$ + Test$ : _              ' Add it to the variable
        Goto 4                                     ' Get next character

     IF Split.Flag = 2 then _                      ' It's part of trashcan name
        Split3$ = Split3$ + Test$                  ' Add it to the variable
 4 NEXT                                            ' Get next character
   
' *********************************************************************
' * CHECK FOR EXISTENCE OF FMS DIRECTORY SUPPLIED ON THE COMMAND LINE *
' *********************************************************************

MASTER.DIR$ = Split1$                              ' FMS name was 1st variable
Yes = PDQExist(Master.Dir$)                        ' See if it exists
IF YES THEN GOTO 5                                 ' Yep, branch down
Print "FMS directory <"; MASTER.DIR$; "> not found." ' Nope, tell them about it
END                                                ' and exit to DOS.
'
' *******************************************************************
' * CHECK TO SEE IF A NEW FILE NAME WAS ENTERED ON THE COMMAND LINE *
' *******************************************************************
'
5 IF SPLIT2$ <> "" then GOTO 10                    ' If 2nd variable was there,
                                                   ' Branch down.
  Print "Path/Filename of new FMS directory to be created --> "; ' Otherwise,
  CALL PDQInput (SPLIT2$)                          ' Get it from the keyboard.

10 IF COMMAND$ = "" THEN INPUT #1,NEW.DIR$ ELSE _  ' Get output from file or,
      NEW.DIR$ = SPLIT2$                           ' from command line
   IF NEW.DIR$ = "" THEN                           ' Couldn't find output name
      Print "Output filename not specified." : end ' Tell them, and exit to DOS
   END IF
   MASTER.DIR$ = ucase$(master.dir$)               ' FMS name in upper case
   NEW.DIR$ = ucase$(new.dir$)                     ' Output file in upper case
   If Split3$ = "" then tcan$ = "NOTFOUND.TXT" else _' No trashcan specified.
      tcan$ = Split3$                              ' Trashcan on command line
      tcan$ = ucase$(tcan$)                        ' Trashcan in all caps

   if master.dir$ = new.dir$ then                  ' Input and output are same
      print "Input and Output filenames cannot "   ' Tell them about it
      print "be identical!" : End                  ' and exit to DOS.
   END IF

20 ' *****************************
   ' * BUILD MAIN RUNNING SCREEN *
   ' *****************************
   
   CLOSE #1                                        ' Make sure nothing's open
   cls                                             ' Wipe the screen
   top$ = chr$(218) + string$(78, chr$(196)) + chr$(191) ' Top border
   cen$ = chr$(179) + string$(78, chr$(32)) + chr$(179)  ' Middle border
   bot$ = chr$(192) + string$(78, chr$(196)) + chr$(217) ' Bottom border
   filler$ = string$(78,chr$(177))                 ' Filler characters
   dat$ = date$ : call lgdate(dat$)                ' Current date in long fmt.
   placedate = 78 - len(dat$)                      ' Where date will print.
   Call PDQPrint (Top$, 1, 1, 12)                  ' Print top border
   Call PDQPrint (Cen$, 2, 1, 12)                  ' Print second line
   Call PDQPrint (Bot$, 3, 1, 12)                  ' Print third line
   Call PDQPrint (Version$, 2, 3, 15)              ' Print FMSVER version #,
   Call PDQPrint (Dat$, 2, placedate, 14)          ' and long date on line 2.
   Call PDQPrint (String$(80, " "), 25, 1, 15 + 16 * 1) ' Clear line 25.
   Call PDQPrint (Top$, 4, 1, 12)                  ' Print top border on line 4

   For Row = 5 to 23                               ' *** START OF LOOP ***
       Call PDQPrint (Cen$, Row, 1, 12)            ' Print middle border
       Call PDQPrint (Filler$, Row, 2, 3)          ' Print filler characters
   Next Row                                        ' *** END OF LOOP

   Call PDQPrint (Bot$, 24, 1, 12)                 ' Print bottom screen border

   Stat1$ = "   Input file : " + MASTER.DIR$       ' Declare three status
   Stat2$ = "  Output file : " + NEW.DIR$          ' line variables
   Stat3$ = "Trashcan file : " + TCAN$             '
 
   Longstat = len(Stat1$)                          ' Find the longest length
   if len(Stat2$) > Longstat then Longstat = len(Stat2$) ' of the three.
   if len(Stat3$) > Longstat then Longstat = len(Stat3$) '
   BoxLen = Longstat + 2                           ' Add 2 chars to it.
   Center = 40 - (Boxlen \ 2)                      ' Find center of screen
 
   Call PDQPrint (String$(Boxlen, " "), 5, Center, 2) ' Blank out the three
   Call PDQPrint (String$(Boxlen, " "), 6, Center, 2) ' areas where the status
   Call PDQPrint (String$(Boxlen, " "), 7, Center, 2) ' lines will go.
 
   Call PDQPrint ("", 4, Center-1, 12)
   Call PDQPrint ("", 4, Center + BoxLen, 12)
   For This = 5 to 7
     Call PDQPrint ("", This, Center-1, 12)
     Call PDQPrint ("", This, Center + BoxLen, 12)
   Next This
   Call PDQPrint ("", 8, Center-1, 12)
   Call PDQPrint ("", 8, Center + BoxLen, 12)
   For This = Center to ((Center + BoxLen)-1)
     Call PDQPrint ("", 8, This, 12)
   Next This

   Call PDQPrint (Stat1$, 5, Center + 1, 2)        ' Print the status lines.
   Call PDQPrint (Stat2$, 6, Center + 1, 2)        '
   Call PDQPrint (Stat3$, 7, Center + 1, 2)        '

   dummy = maxfilelen + 16                         ' Figure on extra 8 chars
   found.top$ = chr$(218) + _                      ' Create variables for top
         string$(dummy, chr$(196)) + chr$(191)     ' border of last file found,
   found.cen$ = chr$(179) + _                      ' middle border,
         string$(dummy, chr$(32)) + chr$(179)      ' and...
   found.bot$ = chr$(192) + _                      ' bottom border.
         string$(dummy, chr$(196)) + chr$(217)     '

   pl = 40 - (dummy \ 2)                           ' Column # for this border.
   found.clear = dummy - 1                         ' Number of columns to clear
   found.col = pl + 2                              ' Column # for last file fnd

   Call PDQPrint (found.top$, 15, pl, 12)          ' Print the borders for
   Call PDQPrint (found.cen$, 16, pl, 12)          ' last file found.
   Call PDQPrint (found.bot$, 17, pl, 12)          '

   notfound.top$ = chr$(218) + _                   ' Create borders for
            string$(14, chr$(196)) + chr$(191)     ' last file not found.
   notfound.cen$ = chr$(179) + _                   '
            string$(14, chr$(32)) + chr$(179)      '
   notfound.bot$ = chr$(192) + _                   '
            string$(14, chr$(196)) + chr$(217)     '

   Call PDQPrint (notfound.top$, 20, 32, 12)       ' Print borders for last
   Call PDQPrint (notfound.cen$, 21, 32, 12)       ' file not found.
   Call PDQPrint (notfound.bot$, 22, 32, 12)       '

   Call PDQPrint (" Last file found ", 15, 32, 15) ' Put headers at top borders
   Call PDQPrint (" Not Found ", 20, 34, 15)       ' of both.

   Call PDQPRINT (STRING$(80, " "), 25, 1, 15 + 16 * 1) ' Clear line 25
   ESCAPE$ = "Press [Esc] to abort..."             ' Create Esc variable.  120
   Center = 40 - (len(Escape$) \ 2)                ' Find the center
   Call PDQPRINT (Escape$, 25, Center, 15 + 16 * 1) ' Tell them they can quit

' *****************************
' * THE REAL WORK STARTS HERE *
' *****************************

   open MASTER.DIR$ for input shared as #1         ' Open the FMS   120

   open NEW.DIR$ for output as #2                  ' Open the output file

      if err > 0 then                              ' If there was a problem
         cls                                       ' clear the screen
         Print "Unable to open output file "; new.dir$  ' tell them about it
         end                                       ' and exit to dos.
      end if
   open TCAN$ for output as #3                     ' Open the trashcan
      if err > 0 then                              ' If there was a problem
         cls                                       ' clear the screen
         Print "Unable to open trashcan file "; tcan$  ' tell them about it
         end                                       ' and exit to dos.
      end if

   X = 1                                           ' From this point on,
                                                   ' "X" is the number of
                                                   ' the file being processed,
                                                   ' NOT the line number.

   DO                                              ' *** START OF MAIN LOOP ***
     LINE INPUT #1, TEST$                          ' Get a line from the FMS
     IF ERR > 0 THEN EXIT DO                       ' If any error, exit
     IF INKEY$ = CHR$(27) THEN EXIT DO             ' If <Esc> pressed, exit
     IF LEN(TEST$) < 32 THEN EXIT DO               ' If line too short, exit
     WORK$ = TEST$ : GOSUB MAIN.LOOP.LABEL         ' Process the line
   LOOP UNTIL EOF(1)                               ' *** END OF MAIN LOOP ***

   GOTO 103                                        ' Branch off.

MAIN.LOOP.LABEL:
   Max.Line.Number = 32                            ' Just for my info
   Print.Location = 40 - (Max.Line.Number \ 2)     ' Ditto
   line.number$ = "Checking file number " + str$(x) + "..."   ' Four vars for
   this.top$ = chr$(218) + string$(30, chr$(196)) + chr$(191) ' current file
   this.cen$ = chr$(179) + string$(30, chr$(32)) + chr$(179)  ' number in
   this.bot$ = chr$(192) + string$(30, chr$(196)) + chr$(217) ' process.

   Call PDQPrint(This.Top$, 10, Print.Location, 12)        ' Print that info to
   Call PDQPrint(This.Cen$, 11, Print.Location, 12)        ' screen...
   Call PDQPrint(This.Bot$, 12, Print.Location, 12)        ' ...
   Call PDQPrint(Line.Number$, 11, Print.Location + 2, 11) ' ...
   Locate 11, (Print.Location + 2) + Len(Line.Number$)
'
' *********************************
' * SUPPORT EXTENDED DESCRIPTIONS *                               ' 1-4-90
' *********************************                 ' Updated v1.20 (7-4-94)
'
     if left$(work$,1) = " " then                   ' Assume extended descr.
        ex.flag = ex.flag + 1                       ' Increment extended flag
        Select Case ex.flag:                        ' Set variables based on
           Case is < 11: Extend$(ex.flag) = work$   ' the value of ex.flag 1.20
           Case else: Extend$(11) = work$           ' If more than 10 extendeds
        End Select                                  ' dump them into dummy var
        FOR E = 1 TO 11                             ' Extend$(11).
           IF E > ex.flag THEN                      ' 1.20
              Extend$(E) = ""                       ' 1.20
           END IF                                   ' 1.20
        NEXT                                        ' 1.20

        If FmsTop Then
           IF AddToMe = 0 THEN FilNum = 3 ELSE FilNum = 2  '
           FOR E = 1 TO 10                                 ' 
              IF Extend$(E) <> "" THEN                     '
                 PRINT #FilNum, Extend$(E)                 '
                 Extend$(E) = ""                           '
              END IF                                       '
           NEXT                                            '
        End If
        Goto 102                                  ' Branch off
     End if

'
' *******************************
' * SUPPORT CHAINED DIRECTORIES *
' *******************************
'
     if left$(work$,7) = "\FMS CH" then AddToMe = 1 : goto 101
     if left$(work$,1) = "\" then
        if instr(Work$, "FMS TOP") > 0 Then 
           FmsTop = -1
           AddToMe = 1
           Goto 101
        End If
     End If
'
' ***************************************************************
' *  FMS LINE IS NOT EXTENDED DESCRIPTION OR CHAINED DIRECTORY. *
' ***************************************************************
'
     Select Case Left$(Work$, 1)         ' Check first character of FMS line.
       Case "\", "*":                    ' If backslash or asterisk,
         CommentLine = -1                ' send immediately to output file.
         PrivateFile = 0
         Goto 101
       Case "=":                         ' If an equals sign,
         PrivateFile = -1                ' it's a private file. Split the vars.
         CommentLine = 0
         Work1$ = Mid$(Work$, 2, 12)
         Work2$ = Mid$(Work$, 14, 8)
         Work3$ = mid$(work$,22,len(work$)-len(work1$)-len(work2$))
       Case Else:                        ' If none of the above,
         PrivateFile = 0                 ' it's normal. Split the vars.
         CommentLine = 0
         work1$ = mid$(work$,1,12)                                  ' File name,
         work2$ = mid$(work$,13,9)                                  ' Size,
         work3$ = mid$(work$,22,len(work$)-len(work1$)-len(work2$)) ' The rest.
     End Select

30 if right$(work1$,1) = " " or right$(work1$,1) = chr$(0) then _ ' Make a
             work1$ = left$(work1$,len(work1$)-1) : _             ' clean
   if right$(work1$,1) = " " or right$(work1$,1) = chr$(0) then _ ' filename
             goto 30                                              ' to use.

50 f$ = work1$                                 ' Filename is work1$

' ******************************************
' * Physical checks for each subdirectory. *
' ******************************************

  FOR DirTest = 1 to 50
      FoundFile = 0
      If Dirs > (DirTest-1) THEN
         FindMe$ = Directory$(DirTest) + F$
         Yes = PDQExist(FindMe$)
         If Yes Then
            Here$ = FindMe$
            FoundFile = -1
            Exit For
         End If
      End If
  NEXT

  If FoundFile Then goto 70

Call PDQPrint (string$(12, " "), 21, 34, 14)   ' File not found, clear field
Call PDQPrint (Work1$, 21, 34, 14)             ' and tell them about it.
Locate 21, 34 + Len(Work1$)
              AddToMe = 0                      ' Reset extended flag
              goto 100                         ' and branch accordingly.

70 AddToMe = 1                                 ' We found it somewhere.
   open here$ for input shared as #4          ' Open it (shared)  0794 v1.20
   length$ = str$(lof(4)) : close #4          ' Find it's size and close it.
   p$ = here$ + " = " + length$ + " bytes"
   Call PDQPrint (Space$(Found.Clear), 16, Found.Col, 14)
   Call PDQPrint (P$, 16, Found.Col, 14)       ' and tell them what we found.
   Locate 16, Found.Col + Len(P$)

   if len(length$) < 9 then _                  ' If length doesn't fill the
     add$ = string$(9-len(length$)," ") : _    ' space, add enough blanks to
     length$ = add$ + length$                  ' cover things.
   work2$ = length$                            ' File size variable is now ok.

   if len(work1$) < 12 then _                  ' If file name isn't max chars,
      add$ = string$(12-len(work1$)," ") : _   ' Add enough blanks to cover
      work1$ = work1$ + add$                   ' things.

   If PrivateFile Then                         ' If it's a private file,
      Work$ = "=" + Work1$ + _                 ' precede with '=' sign.
              Right$(Work2$, 8) + Work3$       '
   Else                                        ' Otherwise,
      work$ = work1$ + work2$ + work3$         ' dump the three work variables
   End If                                      ' into the string to send to the
                                               ' output file.
   
100 X = X + 1                                  ' Increment # of files checked.

101 if AddToMe = 0 and CommentLine = 0 then    ' If file not found,

       If FmsTop Then
          Print #3, Work$
       Else
          FOR E = 1 TO 10                                    ' Print any
            IF Extend$(E) <> "" THEN PRINT #3, Extend$(E)    ' extended
          NEXT                                               ' descriptions,
          Print #3, Work$                                    ' and modified
       End If                                  ' string to the trashcan file.

    End if

    If AddToMe = 1 then                        ' If we found it, do the
 
       If FmsTop Then
          Print #2, Work$
       Else
          FOR E = 1 TO 10                                    ' Same as above,
            IF Extend$(E) <> "" THEN PRINT #2, Extend$(E)    ' but print to
          NEXT                                               ' the output file
          Print #2, Work$                                    ' instead.
       End If

    End if

    If CommentLine Then
       CommentLine = 0
       Print #2, Work$
       Goto 102
    Else
      For E = 1 TO 10           ' Clear all extended descriptions,
          Extend$(E) = ""       '
      Next
      ex.flag = 0               ' and their flag.
    End If

102 RETURN                                     ' ** END OF MAIN LOOP **

103 cls                                        ' All done! Wipe the screen,
    Locate 3,1 : Print "Done!"                 ' clean up, and tell them what
                                               ' we did.
    locate 5,1 : Print TCAN$ " contains a list of files not found."
                 Print MASTER.DIR$ " was not modified."
                 Print
                 Print NEW.DIR$ " is your new FMS directory. Files not found were not"
                 Print "added to this list."
                 Print
                 Print "Thanks for using FMSVER."
                 Print
                 Print "Chip Morrow"
                 Print "Sysop - Information Overload"
                 Print "Fidonet 1:226/730"
                 Print "Data (614) 837-0739"
    end                                         ' We're outa here.
 
SUB LGDATE (X$)

   Month$ = Left$(X$, 2)
     Day$ = Mid$(X$, 4, 2)
    Year$ = Right$(X$, 4)

    Select Case Month$
      Case "01":
        Month$ = "January"
      Case "02":
        Month$ = "February"
      Case "03":
        Month$ = "March"
      Case "04":
        Month$ = "April"
      Case "05":
        Month$ = "May"
      Case "06":
        Month$ = "June"
      Case "07":
        Month$ = "July"
      Case "08":
        Month$ = "August"
      Case "09":
        Month$ = "September"
      Case "10":
        Month$ = "October"
      Case "11":
        Month$ = "November"
      Case "12":
        Month$ = "December"
      Case Else:
    End Select
 
    Select Case Left$(Day$, 1)
      Case "0":
        Day$ = Right$(Day$, 1)
      Case Else:
    End Select
 
    X$ = Month$ + " " + Day$ + ", " + Year$

End Sub

