PAGE 60,132
TITLE DESQview BASIC File Locking Interface Copyright 1988 by Jon Martin     
; Changes made for compatiblity with PDS v7.1 far string option (/Fs).
; Modification based on work by Scott McNay on 07/26/92.  Changed routines
; used by Scott for compatiblity and efficiency.  Thanks Scott for the
; breakthrough in giving RBBS 64K of string space!
; Richie Molinelli - 02/07/93
;--------------------------------------------------------------------;
;ROUTINE: LOCKDV              AUTHOR:  Jon Martin                    ;
;                                      4396 N. Prairie Willow Ct.    ;
;                                      Concord, California 94521     ;
;                                                                    ;
;DATE:  October 23, 1988      VERSION: 1.0                           ;       
;                                                                    ;
;DESCRIPTION: This subroutine enables programs written in Compiled   ;
;             BASIC to do Semaphore type resource locking when       ;
;             running in a DESQview environment.  Care was taken     ;
;             to allow the program to be fully DESQview aware.       ;
;             Programs calling this interface in a non DESQview      ;
;             environment will totally ignore the lock and unlock    ;
;             requests.  BEGINC (Begin critical) and ENDC (End       ;
;             critical) are used in a pre DESQview 2.00 environment. ;
;             API calls to Create and Test for the presence of       ;
;             mailboxes are used to implement the resource locking   ;
;             strategy when running in a DESQview 2.00 or higher     ;
;             environment.                                           ;
;                                                                    ;
;             LOCKING - Get resource name                            ;
;                       Find mailbox using resource name             ;
;                       If found then pause and loop until not found ;
;                       Create mailbox using resource name           ;
;                       return to calling program                    ;
;           UNLOCKING - Get resource name                            ;
;                       Find mailbox using resource name             ;
;                       If not found then return to calling program  ;
;                       If found then Close and Free mailbox         ;
;                       Return to calling program                    ;
;                                                                    ;
;                       BEGINC and ENDC have been wrapped around     ;
;                       those processes that were determined to be   ;
;                       necessary.                                   ;
;                                                                    ;
;FUNCTION: This routine supports calls from the IBM (MICROSOFT)      ;
;          BASIC Version 2.0 or Microsoft QuickBASIC Versions 1.0,   ;
;          2.01, 3.0, 4.00b & 4.50 compilers to the DESQview User    ;
;          Interface.  The calls are:                                ;
;                                                                    ;
;            CALL DVLOCK(resource name)                              ;
;                 a) returns if DESQview is not present              ;
;                 b) issues Begin Critical if DESQview level < 2.00  ;
;                 c) issues Lock Mailbox if DESQview level           ;
;                    >= 2.00                                         ;
;                                                                    ;
;            CALL DVUNLOCK(resource name)                            ;
;                 a) returns if DESQview is not present              ;
;                 b) issues End Critical if DESQview level <2.00     ;
;                 c) issues Unlock Mailbox if DESQview level         ;
;                    >= 2.00                                         ;
;                                                                    ;
; NOTE: "resource" must be a string and not exceed 32 characters     ;
;       Link this with your BASIC program in the following manner    ;
;                                                                    ;
;       LINK PGMNAME+LOCKDV,,,;                                      ;
;                                                                    ;
;--------------------------------------------------------------------;

                  EXTRN  StringAddress:FAR  ;FS020701

LOCKDV   SEGMENT BYTE PUBLIC 'CODE'

         ASSUME  CS:LOCKDV,DS:LOCKDV,ES:LOCKDV
         ORG     0
.xlist
.SALL
;  DESQview API interfaces

;***************************************************************
;
;  Function numbers (AX values) for the @CALL interface
;
;***************************************************************

DVC_PAUSE	EQU	1000H
DVC_PRINTC	EQU	1003H
DVC_GETBIT	EQU	1013H
DVC_FREEBIT	EQU	1014H
DVC_SETBIT	EQU	1015H
DVC_ISOBJ	EQU	1016H
DVC_LOCATE	EQU	1018H
DVC_SOUND	EQU	1019H
DVC_OSTACK	EQU	101AH
DVC_BEGINC	EQU	101BH
DVC_ENDC	EQU	101CH
DVC_STOP	EQU	101DH
DVC_START	EQU	101EH
DVC_DISPEROR	EQU	101FH
DVC_PGMINT	EQU	1021H
DVC_POSWIN	EQU	1023H
DVC_GETBUF	EQU	1024H
DVC_USTACK	EQU	1025H
DVC_POSTTASK	EQU	102BH
DVC_NEWPROC	EQU	102CH
DVC_KMOUSE	EQU	102DH

DVC_APPNUM	EQU	1107H
DVC_DBGPOKE	EQU	110AH
DVC_APILEVEL	EQU	110BH
DVC_GETMEM	EQU	110CH
DVC_PUTMEM	EQU	110DH
DVC_FINDMAIL	EQU	110EH
DVC_PUSHKEY	EQU	1110H
DVC_JUSTIFY	EQU	1111H
DVC_CSTYLE	EQU	1112H

DVC_DVPRESENT	EQU	0FFFFH
DVC_SHADOW	EQU	0FFFEH
DVC_UPDATE	EQU	0FFFDH

;***************************************************************
;
;  Message numbers (BH values) for the @SEND interface
;
;***************************************************************

DVM_HANDLE	EQU	00H
DVM_NEW		EQU	01H
DVM_FREE	EQU	02H
DVM_ADDR	EQU	03H
DVM_DIR		EQU	03H
DVM_READ	EQU	04H
DVM_APPLY	EQU	04H
DVM_WRITE	EQU	05H
DVM_SIZEOF	EQU	08H
DVM_LEN		EQU	09H
DVM_ADDTO	EQU	0AH
DVM_SUBFROM	EQU	0BH
DVM_OPEN	EQU	0CH
DVM_CLOSE	EQU	0DH
DVM_ERASE	EQU	0EH
DVM_STATUS	EQU	0FH
DVM_EOF		EQU	10H
DVM_AT		EQU	11H
DVM_SETSCALE	EQU	11H
DVM_SETNAME	EQU	11H
DVM_READN	EQU	12H
DVM_GETSCALE	EQU	12H
DVM_REDRAW	EQU	13H
DVM_SETESC	EQU	14H
DVM_LOCK	EQU	14H

;***************************************************************
;
;  Alias numbers (BL values) for the @SEND interface
;
;***************************************************************

DVA_TOS		EQU	00H
DVA_ME		EQU	01H
DVA_MAILTOS	EQU	02H
DVA_MAILME	EQU	03H
DVA_KEYTOS	EQU	04H
DVA_KEYME	EQU	05H
DVA_OBJQTOS	EQU	06H
DVA_OBJQME	EQU	07H
DVA_WINDOW	EQU	08H
DVA_MAILBOX	EQU	09H
DVA_KEYBOARD	EQU	0AH
DVA_TIMER	EQU	0BH
DVA_POINTER	EQU	0FH
DVA_PANEL	EQU	10H


;***************************************************************
;
;  @SEND interface macro - bombs AH and BX
;
;***************************************************************

@SEND		macro	message,object
		ifdef DVA_&object
		  MOV	BX,DVM_&message*256+DVA_&object
  		  MOV	AH,12H
		  INT	15H
		else		
		  @PUSH	&object
		  @SEND	&message,TOS
		endif
		endm

;***************************************************************
;
;  @CALL interface macro - bombs AX
;
;***************************************************************

@CALL		macro	func
	        local	L1
		ifndef DVC_&func
		  MOV	AX,&func
		  INT	15H
		else
		if (DVC_&func eq DVC_APILEVEL)
		  CMP	BX,200H		; is 2.00 sufficient ?
		  JB	L1		; jump if so
		  MOV	AX,DVC_APILEVEL	; issue the call
		  INT	15H
		  CMP	AX,2		; early version 2.00 ?
		  JNE	L1		; jump if not
		  XCHG	BH,BL		; reverse bytes
		  MOV	AX,DVC_APILEVEL	; reissue call
		  INT	15H
		  XCHG	BH,BL		; correct byte order
L1:
		else
		if (DVC_&func eq DVC_DVPRESENT)
		  PUSH	BX		; save registers
		  PUSH	CX
		  PUSH	DX
		  MOV	AX,2B01H	; DOS Set Date function
		  XOR	BX,BX		; in case outside DESQview
		  MOV	CX,'DE'		; invalid date value
		  MOV	DX,'SQ'
		  INT	21H
		  MOV	AX,BX		; version # to AX
		  CMP	AX,2		; early DV 2.00 ?
		  JNE	L1		; jump if not
		  XCHG	AH,AL		; swap bytes if so
L1:		  POP	DX		; restore registers
		  POP	CX
		  POP	BX
		else
		if (DVC_&func eq DVC_SHADOW)
		  MOV	AH,0FEH
		  INT	10H
		else 
		if (DVC_&func eq DVC_UPDATE)
		  MOV	AH,0FFH
		  INT	10H
		else 
		  MOV	AX,DVC_&func
		  INT	15H
		endif
		endif
		endif
		endif
		endif
		endm


;***************************************************************
;
;  @PUSH and supporting macros - pushes 32-bit values on the stack
;
;***************************************************************

@PUSH_ESDI	macro
		PUSH	ES
		PUSH	DI
		endm

@PUSH_DSSI	macro
		PUSH	DS
		PUSH	SI
		endm

@PUSH_BXAX	macro
		PUSH	BX
		PUSH	AX
		endm

@PUSH_DXCX	macro
		PUSH	DX
		PUSH	CX
		endm

@PUSH_ESSI	macro
		PUSH	ES
		PUSH	SI
		endm

@PUSH_DSDI	macro
		PUSH	DS
		PUSH	DI
		endm

@PUSH		macro	parm
		ifdef @PUSH_&parm
		  @PUSH_&parm
		else		  
		  PUSH	WORD PTR &parm+2
		  PUSH	WORD PTR &parm
		endif
		endm


;***************************************************************
;
;  @POP and supporting macros - pops 32-bit values from the stack
;
;***************************************************************

@POP_ESDI	macro
		POP	DI
		POP	ES
		endm

@POP_DSSI	macro
		POP	SI
		POP	DS
		endm

@POP_BXAX	macro
		POP	AX
		POP	BX
		endm

@POP_DXCX	macro
		POP	CX
		POP	DX
		endm

@POP_ESSI	macro
		POP	SI
		POP	ES
		endm

@POP_DSDI	macro
		POP	DI
		POP	DS
		endm

@POP		macro	parm
		ifdef @POP_&parm
		  @POP_&parm
		else		  
		  POP	WORD PTR &parm
		  POP	WORD PTR &parm+2
		endif
		endm


;***************************************************************
;
;  @MOV and supporting macros - moves 32-bit values to/from memory
;
;***************************************************************

@DV_LOAD	macro	seg,off,arg
		MOV	&seg,WORD PTR &arg+2
		MOV	&off,WORD PTR &arg
		endm

@DV_STORE	macro	seg,off,arg
		MOV	WORD PTR &arg+2,&seg
		MOV	WORD PTR &arg,&off
		endm

@MOV_ESDI	macro	mac,arg
		&mac	ES,DI,&arg
		endm

@MOV_DSSI	macro	mac,arg
		&mac	DS,SI,&arg
		endm

@MOV_BXAX	macro	mac,arg
		&mac	BX,AX,&arg
		endm

@MOV_DXCX	macro	mac,arg
		&mac	DX,CX,&arg
		endm

@MOV_ESSI	macro	mac,arg
		&mac	ES,SI,&arg
		endm

@MOV_DSDI	macro	mac,arg
		&mac	DS,DI,&arg
		endm

@MOV		macro	dest,src
		ifdef @MOV_&dest
		  @MOV_&dest	@DV_LOAD,&src
		else
		  @MOV_&src	@DV_STORE,&dest
		endif
		endm

 
;***************************************************************
;
;  @CMP macro - compares BX:AX to DWORD in memory
;
;***************************************************************

@CMP		macro	parm
		local	L1
		CMP	AX,WORD PTR &parm
		JNE	L1
		CMP	BX,WORD PTR &parm+2
L1:
		endm
.list
CX_HOLD          DW      0
SEMAPHORE        DD      0
RESOURCE         DB      '                                '
STRG_LOC         DW      0                       ;FS020701

DVLOCK   PROC    FAR
         PUBLIC  DVLOCK 
         PUSH    BP                              ;save base pointer
         MOV     BP,SP                           ;establish new base
         PUSH    DS                              ;save BASIC data segment
         PUSH    ES                              ;save BASIC extra segment
;FS020701 MOV     BX,[BP+6]                       ;get string descriptor
;FS020701 MOV     DX,[BX+2]                       ;get address of string
;FS020701 MOV     CX,[BX]                         ;get length of string
         PUSH    [BP+ 6]                         ;FS020701
         CALL    StringAddress                   ;FS020701
         MOV     CS:CX_HOLD,CX                   ;save length of string
         MOV     CS:STRG_LOC,AX                  ;FS020701
         PUSH    DS                              ;FS020701
         PUSH    DX                              ;FS020701
         POP     DS                              ;FS020701
         MOV     SI,CS:STRG_LOC                  ;FS020701
         MOV     CX,CS:CX_HOLD                   ;FS020701
         PUSH    CS                              ;setup for ES
         POP     ES                              ;ES now points to us
;FS020701MOV     SI,DX                           ;offset of BASIC'S string
         LEA     DI,CS:RESOURCE                  ;point to resource name
         CLD                                     ;start from bottom
         REP     MOVSB                           ;copy string to resource name
         POP     DS                              ;FS020701
         @CALL   DVPRESENT                       ;test for DESQview
         TEST    AX,AX                           ;well is it there?
         JZ      LK_EXIT                         ;zero means no
         MOV     BX,200H                         ;set API level required
         CMP     AX,BX                           ;is required level supported?
         JNB     APILKSEM                        ;not below means ok!
         @CALL   BEGINC                          ;start critical
LK_EXIT:
         JMP     DVLOCK_EXIT                     ;exit lock resource
APILKSEM:
         @CALL   APILEVEL                        ;set API level
LOOP_SEMA:
         @CALL   BEGINC                          ;start critical
         LEA     DI,CS:RESOURCE                  ;point to resource mailbox nm
         PUSH    CS                              ;setup for ES
         POP     ES                              ;ES now points to us
         MOV     CX,CS:CX_HOLD                   ;setup resource name len
         XOR     DX,DX                           ;clear high register
         @CALL   FINDMAIL                        ;find the resource mailbox
         TEST    BX,BX                           ;did we find it?
         JZ      MAKE_SEMA                       ;zero means nope!
         @CALL   ENDC                            ;end critical
         @CALL   PAUSE                           ;let's wait for awhile
         JMP     LOOP_SEMA                       ;let's go try again
MAKE_SEMA:
         @SEND   NEW,MAILBOX                     ;create resource mailbox
         @POP    CS:SEMAPHORE                    ;save semaphore
         LEA     DI,CS:RESOURCE                  ;point to resource mailbox nm
         PUSH    CS                              ;setup for ES
         POP     ES                              ;ES now points to us
         @PUSH_ESDI                              ;put address on stack
         MOV     CX,CS:CX_HOLD                   ;setup resource name len
         XOR     DX,DX                           ;clear high register
         @PUSH_DXCX                              ;put length on stack
         @SEND   SETNAME,CS:SEMAPHORE            ;let's give it a name
         @CALL   ENDC                            ;end critical
DVLOCK_EXIT:
         POP     ES                              ;restore BASIC extra segment
         POP     DS                              ;restore BASIC data segment
         POP     BP                              ;restore BASIC base pointer
         RET     2                               ;return to BASIC
DVLOCK   ENDP

DVUNLOCK PROC    FAR
         PUBLIC  DVUNLOCK
         PUSH    BP                              ;save base pointer
         MOV     BP,SP                           ;establish new base
         PUSH    DS                              ;save BASIC data segment
         PUSH    ES                              ;save BASIC extra segment
;FS020701 MOV     BX,[BP+6]                       ;get string descriptor
;FS020701 MOV     DX,[BX+2]                       ;get address of string
;FS010701 MOV     CX,[BX]                         ;get length of string
         PUSH    [BP+ 6]                         ;FS020701
         CALL    StringAddress                   ;FS020701
         MOV     CS:CX_HOLD,CX                   ;save length of string
         MOV     CS:STRG_LOC,AX                  ;FS020701
         PUSH    DS                              ;FS020701
         PUSH    DX                              ;FS020701
         POP     DS                              ;FS020701
         MOV     SI,CS:STRG_LOC                  ;FS020701
         MOV     CX,CS:CX_HOLD                   ;FS020701
         PUSH    CS                              ;setup for ES
         POP     ES                              ;ES now points to us
;FS020701 MOV     SI,DX                           ;offset of BASIC'S string
         LEA     DI,CS:RESOURCE                  ;point to resource name
         CLD                                     ;start from bottom
         REP     MOVSB                           ;copy string to resource name
         POP     DS                              ;FS020701
         @CALL   DVPRESENT                       ;test for DESQview
         TEST    AX,AX                           ;well is it there?
         JZ      UNLKSEMA_EXIT                   ;zero means no
         MOV     BX,200H                         ;set API level required
         CMP     AX,BX                           ;is required level supported?
         JNB     APIULSEM                        ;not below means ok!
         @CALL   ENDC                            ;end critical
UNLKSEMA_EXIT:
         JMP     DVUNLOCK_EXIT                   ;exit unlock resource
APIULSEM:
         @CALL   APILEVEL
         LEA     DI,CS:RESOURCE                  ;point to resource mailbox nm
         PUSH    CS                              ;setup for ES
         POP     ES                              ;ES now points to us
         MOV     CX,CS:CX_HOLD                   ;setup resource name len
         XOR     DX,DX                           ;clear high register
         @CALL   FINDMAIL                        ;find resource mailbox
         TEST    BX,BX                           ;did we find it?
         JZ      DVUNLOCK_EXIT                   ;zero means nope!
         @MOV    CS:SEMAPHORE,DSSI               ;found so save semaphore
         @CALL   BEGINC                          ;begin critical
         @SEND   CLOSE,CS:SEMAPHORE              ;unlock resource mailbox
         @SEND   FREE,CS:SEMAPHORE               ;release resource mailbox
         @CALL   ENDC                            ;end critical
DVUNLOCK_EXIT:
         POP     ES                              ;restore BASIC extra segment
         POP     DS                              ;restore BASIC data segment
         POP     BP                              ;restore BASIC base pointer
         RET     2                               ;return to BASIC
DVUNLOCK ENDP

LOCKDV   ENDS
         END

