TITLE  'Set Palette register(s)'
NAME   SETPAL
PAGE   55,132
;-----------------------------------------------------------------------|
;    ScanSoft          (C)1991 Cornel H Huth     ALL RIGHTS RESERVED    |
;-----------------------------------------------------------------------|
;     date:      11 Feb 91                                              |
; function:      Set single or all palettes                             |
;   caller:      FAR call (QuickBASIC convention)                       |
;                call SETPALREG(0,8)                                    |
;                call SETPALLETE(vseg,voff)                             |
;    stack:     +06 = palette value (palette string offset)             |
;                08 = palette register (palette string segment)         |
;  returns:      none                                                   |
;------------------------------------------------------------------------

PARMS           = 2
ARGreg          EQU [bp+08]
ARGvalue        EQU [bp+06]
ARGseg          EQU [bp+08]
ARGoff          EQU [bp+06]

include EXTRNDAT.INC

dgroup          group _BSS,_DATA

SetPal_TEXT     SEGMENT WORD PUBLIC 'CODE'
                ASSUME  cs:SetPal_TEXT,ds:dgroup,ss:dgroup

                PUBLIC  SetPalReg
SetPalReg       PROC    FAR

                push    bp
                mov     bp,sp
                mov     bx,ARGvalue
                mov     ax,[bx]         ;ax=color value (al)
                mov     bx,ARGreg
                mov     bx,[bx]         ;bx=reg (bl)
                mov     bh,al           ;color value
                mov     ax,1000h
                int 10h                 ;update specified pal reg
                pop     bp
                RET     PARMS*2
SetPalReg       ENDP

                PUBLIC SetPalette
SetPalette      PROC FAR

                push    bp
                mov     bp,sp
                mov     bx,ARGoff
                mov     dx,[bx]
                mov     bx,ARGseg       ;string segment
                mov     es,[bx]         ;es:dx->17-byte palette data
                mov     ax,1002h
                int 10h                 ;update palette
                pop     bp
                RET     PARMS*2
SetPalette      ENDP

SetPal_TEXT     ENDS
                END

