TITLE  'Set Screen Origin EGA - VIDEO SYSTEMS p.387'
NAME   SCRNORG
PAGE   55,132
;-----------------------------------------------------------------------|
;    ScanSoft          (C)1990 Cornel H Huth     ALL RIGHTS RESERVED    |
;-----------------------------------------------------------------------|
;     date:      04 Aug 90                                              |
; function:      Set the screen origin for EGA/VGA                      |
;   caller:      FAR call (QuickBASIC convention)                       |
;                call SETSCNORG(0,0)                                    |
;    stack:     +06 = y0                                                |
;                08 = x0                                                |
;  returns:      none                                                   |
;               ;need to adjust for EGA or VGA                          |
;               ;since on _some_ VGA this code causes flicker           |
;               ;found by David Sill 13-Aug-92 (send him new version)   |
;-----------------------------------------------------------------------|

PARMS           = 2
ARGx            EQU [bp+08]
ARGy            EQU [bp+06]
CRT_MODE        EQU 49h
ADDR_6845       EQU 63h
L_POINTS        EQU 85h
BIOS_FLAGS      EQU 89h
ByteOffsetShift EQU 3

include EXTRNDAT.INC

dgroup          group _BSS,_DATA
7
ScreenOrg_TEXT  SEGMENT WORD PUBLIC 'CODE'
                ASSUME cs:ScreenOrg_TEXT,ds:dgroup,ss:dgroup

                PUBLIC SetScnOrg
SetScnOrg       PROC    FAR

                push    bp
                mov     bp,sp

                mov     ax,40h
                mov     es,ax
                mov     cl,es:[CRT_MODE]

                mov     bx,ARGx
                mov     ax,[bx]
                mov     x0,ax
                mov     bx,ARGy
                mov     bx,[bx]
                mov     y0,bx

                cmp     cl,7
                ja      L01
                je      L02
                test    byte ptr es:[BIOS_FLAGS],1
                jnz     L02
                jmp     short L03

; setup for graphics modes (8pixels/byte)

L01:            mov     cx,8
                div     cl
                mov     cl,ah
                xor     ah,ah
                xchg    ax,bx
                mul     word ptr bpl
                jmp     short L05

; setup for VGA alphanumeric & EGA mono alpha (9pixels/byte)

L02:            mov     cx,9
                div     cl
                dec     ah
                jns     L04
                mov     ah,8
                jmp     short L04

; setup for EGA color alpha (8pixels/byte)

L03:            mov     cx,8
                div     cl
L04:            mov     cl,ah
                xor     ah,ah
                xchg    ax,bx
                div     byte ptr es:[L_POINTS]
                xchg    ah,ch
                mul     word ptr bpl
                shr     ax,1

L05:            add     bx,ax                   ;set origin
                mov     dx,es:[ADDR_6845]
                add     dl,6

L20:            in      al,dx   ; update start address high and low regs
                test    al,8
                jz      L20
L21:            in      al,dx
                test    al,8
                jnz     L21

                cli
                sub     dl,6
                mov     ah,bh
                mov     al,0ch
                out     dx,ax
                mov     ah,bl
                inc     al
                out     dx,ax
                sti
                add     dl,6

                ;need to adjust for EGA or VGA
                ;since on _some_ VGA this code causes flicker
                ;found by David Sill 13-Aug-92

                test    byte ptr es:[BIOS_FLAGS],1 ;VGA active bit
                jz      L22b                       ;not VGA

L22a:           in      al,dx                   ;VGA loop
                test    al,8
                jnz     L22a
                jmp     SHORT L23

L22b:           in      al,dx                   ;EGA loop
                test    al,8
                jz      L22b

L23:            cli
                sub     dl,6
                mov     ah,ch
                mov     al,8
                out     dx,ax
                mov     dl,0c0h
                mov     al,13h OR 20h
                out     dx,al
                mov     al,cl
                out     dx,al
                sti

                pop     bp
                ret     PARMS * 2

SetScnOrg       ENDP
ScreenOrg_TEXT  ENDS
                END

