        PAGE    ,105
        TITLE   DESQview Aware Procedures
        .MODEL  MEDIUM
;***********************************************************************
;                             DVAWARE.ASM                              *
;   Two assembled subroutines to allow compiled BASIC programs to be   *
; "DESQview aware."  These routines have no effect when the program    *
; is running directly under DOS.                                       *
;   DVBREAK [DECLARE SUB DVBREAK ()] will stop the time slice if the   *
; program is running under DESQview.                                   *
;   DVSHADOW [DECLARE SUB DVSHADOW ()] allows programs compiled with   *
; BC version 4.0, or later, to run in the background or in small       *
; windows under "plain" DESQview.  The CALL DVSHADOW statement must be *
; executed before any PRINT statement in the program.                  *
;   WARNING:  BASIC programs using either of these procedures must be  *
; compiled with switch "/O" for standalone use.                        *
;               Written by M. L. Lesser, August 7, 1990                *
;              Assembled with Microsoft MASM, version 5.1              *
;***********************************************************************
IF1
        INCLUDE DVAPI.INC               ;From DVAPI Reference Library
ENDIF

.DATA
        EXTRN   B$VideoBase: WORD       ;Base of (text) screen memory

.CODE

DVPRES  PROC NEAR               ;Local (non-public) subroutine to check
        @CALL   DVPRESENT       ;  for DESQview presence.
        OR      AX,AX           ;Will be zero if not running under DV
        RET
DVPRES  ENDP

        PUBLIC  DVBREAK
DVBREAK PROC
        PUSH    BP
        CALL    DVPRES
        JZ      DONE                    ;If not under DV, quit
        @CALL   PAUSE                   ;Else drop time slice
        JMP  SHORT  DONE
DVBREAK ENDP

        PUBLIC  DVSHADOW
DVSHADOW PROC
        PUSH    BP
        CALL    DVPRES
        JZ      DONE                    ;If not under DV, quit
        @CALL   SHADOW                  ;Else tell DV to shadow output
        MOV     B$VideoBase,ES
DONE:   POP     BP
        RET
DVSHADOW ENDP
        END
