/*	v_constr.c- Initialize a viewport */

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <tools/viewport.h>

int v_construct( viewport *v )
{
    /* Initialize a previously allocated (with malloc() or a declaration)
     * viewport, setting various fields to reasonable defaults. It's an
     * error to construct a viewport more than once without an intervening
     * v_destroy call.
     */

    struct text_info info;
    gettextinfo( &info );

    if( v->magic == VMAGIC )
        return 0;

    v->magic     = VMAGIC;
    v->inactive  = 1;
    v->closed    = 1;
    v->clearok   = 0;
    v->saveok    = 0;
    v->nrows     = info.screenheight;   /* Initial size is the entire screen */
    v->ncols     = info.screenwidth;
    v->row       = 0;                   /* Upper-left corner */
    v->col       = 0;
    v->cur_col   = 0;
    v->cur_row   = 0;
    v->fcolor    = BLACK ;
    v->bcolor    = LIGHTGRAY ;
    v->savebuf   = NULL;
    v->old_image = NULL;
    return 1;
}
