	title	wnet - window network interface (simulated)
	include	window.inc
	include	asm.inc

; (c) 1990 Soft Advances, all rights reserved.

	.data?
request_pointer		dd	?
request_bc		dw	?

reply_pointer		dd	?
reply_bc		dw	?

	.code
	extn	poll_server
	public	receive_window_reply,receive_window_request
	public	transmit_window_reply,transmit_window_request


;;	receive window reply
;
;	entry	DS:SI	reply packet pointer
;		CX	byte count
;	uses	AX
;
receive_window_reply proc
	pushm	cx,di,si,ds,es
	mov	ax,ds
	mov	es,ax
	mov	di,si
	lds	si,reply_pointer[bp]
	rep	movsb
	mov	reply_bc[bp],0
	popm	es,ds,si,di,cx
	clc
	ret
receive_window_reply endp


;;	receive window request
;
;	entry	DS:SI	request packet pointer
;		CX	byte count
;	exit	Cf	if byte count too big
;	uses	AX
;
receive_window_request proc
	pushm	cx,di,si,ds,es
	mov	ax,ds
	mov	es,ax
	mov	di,si
	lds	si,request_pointer[bp]
	mov	ax,request_bc[bp]
	sub	ax,cx
	jc	rwr1			; if requested byte count too big
	mov	request_bc[bp],ax
	add	wptr request_pointer[bp],cx
	rep	movsb
rwr1:	popm	es,ds,si,di,cx
	ret
receive_window_request endp


;;	transmit window reply
;
;	entry	DS:SI	packet pointer
;		CX	byte count
;	uses	AX
;
transmit_window_reply proc
	mov	wptr reply_pointer[bp],si
	mov	wptr reply_pointer[bp+2],ds
	mov	reply_bc[bp],cx
	ret
transmit_window_reply endp


;;	transmit window request
;
;	entry	DS:SI	packet pointer
;		CX	packet byte count
;	uses	AX
;
transmit_window_request proc
	mov	wptr request_pointer[bp],si
	mov	wptr request_pointer[bp+2],ds
	mov	request_bc[bp],cx
	call	poll_server
	ret
transmit_window_request endp


	end
