/*
 * Winvue main module
 *
 * Written by Bill Hall
 * 3665  Benton Street, #66
 * Santa Clara, CA 95051
 *
 * See Winvue.doc for usage information
 *
 */

/* bypass some things we don't need in windows.h */
#define NOCOMM		
#define NOKANJI
#define NOATOM
#define NOBITMAP
#define NOMINMAX
#include <windows.h>

#include <io.h>
#include <stdlib.h>
#include <ttycls.h>

#define EXTERN
#include "winvue.h"

/* entry point for windows */
int FAR PASCAL WinMain(hInstance, hPrevInstance, lpszCmdLine, cmdShow)
HANDLE hInstance, hPrevInstance;
LPSTR lpszCmdLine;
int cmdShow;
{

  /* initialize program */
    if (!InitProgram(hInstance,hPrevInstance, lpszCmdLine, cmdShow))
      /* if we fail, then exit */
	return FALSE;

  /* fall into the message loop */
    while (TRUE)
	DoMessage();

}

/* execute GetMessage while waiting for a file to view */
void NEAR DoGetMessage()
{
    MSG msg;

    if (GetMessage((LPMSG)&msg,NULL,0,0)) {
	if (TranslateAccelerator(MWnd.hWnd,hAccel,(LPMSG)&msg) == 0) {
	    TranslateMessage((LPMSG)&msg);
	    DispatchMessage((LPMSG)&msg);
	}
    }
    else
	exit((int)msg.wParam);
}

/* 
   Execute PeekMessage while displaying a file so that other Windows
   programs can continue to run.
*/
void NEAR DoPeekMessage()
{
    MSG msg;

  /* if there is a message, then process it */
    if (PeekMessage((LPMSG)&msg,NULL,0,0,PM_REMOVE)) {
        if (msg.message == WM_QUIT)
	    exit((int)msg.wParam);
	if (TranslateAccelerator(MWnd.hWnd,hAccel,(LPMSG)&msg) == 0) {
	    TranslateMessage((LPMSG)&msg);
	    DispatchMessage((LPMSG)&msg);
	}
    }
  /* otherwise if file is still open process it */
    else if (hFile > 0)
        ProcessFile();
}

/* main window procedure */
long FAR PASCAL MainWndProc(hWnd,message,wParam,lParam)
HWND hWnd;
unsigned message;
WORD wParam;
LONG lParam;
{

    PAINTSTRUCT ps;
    
    switch(message) {

      /* stop and start file display with the mouse button */
	case WM_LBUTTONDOWN:
	    if (Pause)
		SendMessage(hWnd, WM_COMMAND, IDM_RESUME,0L);
	    else
		SendMessage(hWnd, WM_COMMAND, IDM_PAUSE,0L);
	    break;

      /* adjust position of text display if window is resized */
	case WM_SIZE:
	    AdjustHeight(LOWORD(lParam), HIWORD(lParam));
	    break;

      /* menu commands */
	case WM_COMMAND:
	    WndCommand(hWnd, wParam);
	    break;

      /* display string from remote program */
	case WM_USER:
	    TTYDisplay((PTTYWND)GetWindowWord(hWnd,0),(short)wParam, 
				(char *)LOWORD(lParam));
	    break;

      /* initialize some things when window is created */
	case WM_CREATE:
	    WndCreate(hWnd,lParam);
	    break;

      /* quit */
	case WM_DESTROY:
	    PostQuitMessage(0);
	    break;

      /* Close any open files */
	case WM_CLOSE:
	    if (hFile > 0)
		close(hFile);
	    DestroyWindow(hWnd);
	    break;

      /* if exiting Windows, close any open files */
	case WM_ENDSESSION:
	    if (wParam)
	        if (hFile > 0)
		    close(hFile);
	    break;

      /* refresh the window */
	case WM_PAINT:
	    BeginPaint(hWnd, (LPPAINTSTRUCT)&ps);
	    MainWndPaint(hWnd, (LPPAINTSTRUCT)&ps);
	    EndPaint(hWnd, (LPPAINTSTRUCT)&ps);
	    break;

      /* all other messages are handled by windows */
	default:
	    return ((long)DefWindowProc(hWnd,message,wParam,lParam));
	    break;
    }
    return(0L);
}
