// rect.cls	Rectangle class.  uses two Points to define a rectangle.
//
// (c) Aspen Scientific 1989. All Rights Reserved.
// Author: Vaughn Vernon

#ifndef _RECTANGLE_CLASS

# define _RECTANGLE_CLASS	1

# include "point.cls"

// Rectangle class

class Rectangle {

protected:
	Point	op;	// origin Point
	Point	cp;	// corner Point
public:
	Rectangle(Point & o, Point & c) { op = o; cp = c; }
	Rectangle()		{ op = Point(0,0); cp = Point(0,0); }
	~Rectangle()		{ }

	Point &	origin()	{ return op; }
	Point & origin(Point &p){ return op = p; }
	Point & corner()	{ return cp; }
	Point & corner(Point &p){ return cp = p; }
	Point	extent()	{
		Point p(cp.x() - op.x(), cp.y() - op.y());
		return p;
	}
	int	height()	{ return cp.x() - op.x(); }
	int	width()		{ return cp.y() - op.y(); }

	// draw() is protocol: derived class responsibility
	virtual void draw()	{ }
};

#endif
