GSVER = 2.5
GSDATE = 30.Oct.95
#
#   Makefile for dvips.  Edit this first part of the file.
#
#   First, the things that absolutely must be edited for your system.

# modified for MSC 6.00A with dmake on OS/2.
#  by hankedr@mail.auburn.edu
# 17th February 1994
# from makefile.emx
#  by rjl@monu1.cc.monash.edu.au

# If using HPFS you may need to type 'nmake fixup' to truncate names.
# If using NDMAKE 4.5 under MS-DOS, PKPATH needs %% changed to %.
# If using Borland MAKER under MS-DOS, all paths need \\ changed to \\\\.

# compiler
CC = cl -nologo -AL

# Define BIND to create bound OS/2 and DOS executables
BIND= bind $@ /n DOSMAKEPIPE DOSCWAIT

# Utility programs for "make install"
CP = cp
RM = rm

# All DIRs must use a single \ as a directory separator.
# All PATHs must use \\ as a directory separator
DRIVE = c:
TEXDIR = $(DRIVE)\emtex
TEXPATH = $(DRIVE)\\emtex


# the default path to search for TFM files 
# (this usually is identical to TeX's defaultfontpath, which omits `.')
# (private fonts are given an explicit directory, which overrides the path)
# TFMPATH = c:\\emtex\\tfm
TFMPATH = $(TEXPATH)\\tfm!

# the default path to search for PK files (usually omits `.')
# Don't forget to add the directory that
# MakeTeXPK puts the files!  (In this case, /LocalLibrary/Fonts...)
# PKPATH = c:\\texfonts\\pixel.lj\\%ddpi\\%f.%p
#PKPATH = $(DRIVE)\\texfonts\\pixel.lj\\%ddpi\\%f.%p
PKPATH = $(DRIVE)\\texfonts\\pixel.lj\\%%ddpi\\%%f.%%p

# the default path to search for VF files (usually omits `.')
# VFPATH = c:\\texfonts\\vf
#VFPATH = $(DRIVE)\\texfonts\\vf
VFPATH = $(DRIVE)\\texfonts\\vf!

# additional directories in which to search for subdirectories to find
# both tfm and pk files
FONTSUBDIRPATH = 

# where the config files go
# CONFIGDIR = c:\emtex\ps
#CONFIGDIR = $(TEXDIR)\ps
CONFIGDIR = $(TEXDIR)\data\dvips

# the default path to search for config files
# CONFIGPATH = .;c:\\emtex\\ps
#CONFIGPATH = .;$(TEXPATH)\\ps
CONFIGPATH = $(TEXPATH)\\data\\dvips

# the name of your config file
# CONFIGFILE = config.ps
CONFIGFILE = config.ps

# where the header PS files go
# HEADERDIR = c:\emtex\ps
#HEADERDIR = $(TEXDIR)\ps
HEADERDIR = $(CONFIGDIR)

# the default path to search for header files
# HEADERPATH = .;c:\\emtex\\ps
#HEADERPATH = .;$(TEXPATH)\\ps
HEADERPATH = $(CONFIGPATH)

# where epsf.tex and rotate.tex go (usually the TeX macros directory)
# TEXMACRODIR = c:\emtex\texinput
TEXMACROPARENTDIR = $(TEXDIR)\texinput
TEXMACRODIR = $(TEXDIR)\texinput\dvips

# the default path to search for epsf and psfiles
# (usually the same as TeX's defaultinputpath)
# FIGPATH = .;..;c:\\emtex\\texinput
#FIGPATH = .;..;$(TEXPATH)\\texinput
FIGPATH = $(HEADERPATH);$(TEXPATH)\\texinput!

# the default path to search for emTeX font libraries
# FLIPATH = c:\\texfonts
FLIPATH = c:\\texfonts

# the names of emTeX font libraries
# FLINAME = lj_0;lj_h;lj_1;lj_2;lj_3;lj_4;lj_5a;lj_5b;lj_sli
#FLINAME = lj_0;lj_h;lj_1;lj_2;lj_3;lj_4;lj_5a;lj_5b;lj_sli
FLINAME = lj_base;lj_more

# change -DDEFRES=300 or whatever is required
#    if the default resolution is not 300 dpi,
# add -DDEBUG to turn on debugging capability
# add -DTPIC for tpic support
# add -DFONTLIB to search font libraries
# add -DSEARCH_SUBDIRECTORIES to search the FONTSUBDIRPATH.
# add -DHAVE_GETCWD if you have getcwd (relevant only for subdir searching)
# add -DCREATIONDATE if your system has a working time() and you want dated files
#   If you define FONTLIB, make sure to also give definitions to
#   FLIPATH and FLINAME.
#
DEFS= -DTPIC -DDEBUG -DFONTLIB -DDEFRES=300 -DHAVE_GETCWD -DHPS

# OPT = -J -W2 -Zi
OPT = -J 

# LFLAGS = -Lp -Zi -Od
LFLAGS = -Lp setargv$O -link /NOE

# If you are compiling dvips for suid or other privileges, you will
# definitely want to define the following symbol; else don't.
# SECURE = -DSECURE
SECURE =

# If you want EMTEX specials, define the following.
EMTEX = -DEMTEX -DEMTEXDIR


# define the c-compiler flag
# -DOS2 for OS/2 and MS-DOS with EMX extender or MSC
SYS = -DOS2 -UMSDOS

# where the installed binary goes
# BINDIR = c:\emtex
BINDIR = $(TEXDIR)

# where the manual page goes
# MANDIR = c:\emtex\doc
#MANDIR = $(TEXDIR)\doc
MANDIR = $(TEXDIR)\doc\dvips

PATHS = -DCREATIONDATE \
	-DSAWVER="\"(DVIPS16.EXE V$(GSVER) ($(GSDATE)))\"" \
	-DTFMPATH=\"$(TFMPATH)\" \
	-DPKPATH=\"$(PKPATH)\" \
	-DVFPATH=\"$(VFPATH)\" \
	-DHEADERPATH=\"$(HEADERPATH)\" \
	-DCONFIGPATH=\"$(CONFIGPATH)\" \
	-DCONFIGFILE=\"$(CONFIGFILE)\" \
	-DFONTSUBDIRPATH=\"$(FONTSUBDIRPATH)\" \
	-DFIGPATH=\"$(FIGPATH)\" \
	-DFLIPATH=\"$(FLIPATH)\" \
	-DFLINAME=\"$(FLINAME)\" 

CFLAGS = $(OPT) $(SYS) $(SECURE) $(EMTEX) $(DEFS)

SRC =   dospecia.c dviinput.c fontdef.c  loadfont.c dvips.c    tfmload.c \
	download.c prescan.c  scanpage.c skippage.c output.c   scalewid.c \
	dosectio.c dopage.c   resident.c search.c   unpack.c   drawPS.c \
	header.c   makefont.c repack.c   virtualf.c dpicheck.c finclude.c \
	pprescan.c papersiz.c flib.c     color.c    bbox.c     emspecia.c hps.c \
	emtexdir.c emdir.c

OBJ =   dospecia$O dviinput$O fontdef$O  loadfont$O dvips$O \
        tfmload$O  download$O prescan$O  scanpage$O skippage$O \
        output$O   scalewid$O dosectio$O dopage$O   resident$O \
        search$O   unpack$O   drawPS$O   header$O   makefont$O repack$O \
        virtualf$O dpicheck$O finclude$O hps$O \
        pprescan$O papersiz$O flib$O     color$O    bbox$O     emspecia$O \
	emtexdir$O emdir$O

all : afm2tfm.exe dvips16.exe tex.pro texps.pro texc.pro \
   special.pro finclude.pro color.pro crop.pro  hps.pro

# default rules

O = .obj 

.SUFFIXES: $O .c

.c$O: 
	$(CC) -c $(CFLAGS) $(PATHS) $<

dvips16.exe: $(OBJ)
	$(CC) -o $@ $(OBJ) pc\dvips16.def $(LFLAGS)
	$(BIND)


# The following may be useful in adapting this makefile to DOS
# LINK = link
# LINKOPT = /NOE /NOD:llibce.lib llibcep.lib, pc\dvips16.def
# 
# link.rsp: pc/makefile.msc
# 	echo dospecia$O + > link.rsp
# 	echo dviinput$O + >>link.rsp
# 	echo fontdef$O  + >>link.rsp
# 	echo loadfont$O + >>link.rsp
# 	echo dvips$O    + >>link.rsp
# 	echo tfmload$O  + >>link.rsp
# 	echo download$O + >>link.rsp
# 	echo prescan$O  + >>link.rsp
# 	echo scanpage$O + >>link.rsp
# 	echo skippage$O + >>link.rsp
# 	echo output$O   + >>link.rsp
# 	echo scalewid$O + >>link.rsp
# 	echo dosectio$O + >>link.rsp
# 	echo dopage$O   + >>link.rsp
# 	echo resident$O + >>link.rsp
# 	echo search$O   + >>link.rsp
# 	echo unpack$O   + >>link.rsp
# 	echo drawPS$O   + >>link.rsp
# 	echo header$O   + >>link.rsp
# 	echo makefont$O + >>link.rsp
# 	echo repack$O   + >>link.rsp
# 	echo virtualf$O + >>link.rsp
# 	echo dpicheck$O + >>link.rsp
# 	echo finclude$O + >>link.rsp
# 	echo pprescan$O + >>link.rsp
# 	echo papersiz$O + >>link.rsp
# 	echo flib$O     + >>link.rsp
# 	echo color$O    + >>link.rsp
# 	echo bbox$O     + >>link.rsp
# 	echo emspecia$O + >>link.rsp
# 	echo setargv$O, dvips16.exe,, + >>link.rsp
# 	echo $(LINKOPT) >>link.rsp

afm2tfm.exe: afm2tfm.c 
	$(CC) $(CFLAGS) afm2tfm.c -o $@ pc\afm2tfm.def $(LFLAGS)
	$(BIND)

$(OBJ) : dvips.h debug.h paths.h

squeeze.exe : squeeze.c
	$(CC) $(CFLAGS) squeeze.c -o $@ pc\squeeze.def $(LFLAGS)
	$(BIND)

tex.pro : tex.lpr squeeze.exe
	squeeze tex.lpr  tex.pro

texc.pro: texc.lpr squeeze.exe
	squeeze texc.lpr texc.pro

texc.lpr: tex.lpr
	@echo This does "texc.scr tex.lpro texc.lpro" on Unix
	@echo For MSDOS or OS/2, copy tex.lpro to texc.lpr
	@echo then edit texc.lpr to remove the code
	@echo for uncompressed fonts and uncomment the
	@echo code for unpacking compressed fonts


texps.pro : texps.lpr squeeze.exe
	squeeze texps.lpr texps.pro

special.pro : special.lpr squeeze.exe
	squeeze special.lpr special.pro

finclude.pro: finclude.lpr squeeze.exe
	squeeze finclude.lpr finclude.pro

color.pro: color.lpr squeeze.exe
	squeeze color.lpr color.pro

crop.pro: crop.lpr squeeze.exe
	squeeze crop.lpr crop.pro

install : afm2tfm.exe dvips16.exe pc/maketexp.bat pc/maketexp.cmd \
	tex.pro texc.pro texps.pro special.pro finclude.pro color.pro crop.pro \
	pc/config.ps psfonts.map epsf.tex epsf.sty rotate.tex rotate.sty \
	dvips.tex dvipsmac.tex colordvi.sty colordvi.tex blackdvi.sty \
	blackdvi.tex pc/dvips.doc pc/afm2tfm.doc
	-mkdir $(BINDIR)
	-mkdir $(HEADERDIR)
	-mkdir $(CONFIGDIR)
	-mkdir $(MANDIR)
	-mkdir $(TEXMACROPARENTDIR)
	-mkdir $(TEXMACRODIR)
	$(CP) afm2tfm.exe $(BINDIR)\afm2tfm.exe
	$(CP) dvips16.exe $(BINDIR)\dvips16.exe
	$(CP) pc\maketexp.bat $(BINDIR)\maketexp.bat
	$(CP) pc\maketexp.cmd $(BINDIR)\maketexp.cmd
	$(CP) tex.pro $(HEADERDIR)
	$(CP) texc.pro $(HEADERDIR)
	$(CP) texps.pro $(HEADERDIR)
	$(CP) special.pro $(HEADERDIR)
	$(CP) finclude.pro $(HEADERDIR)
	$(CP) color.pro $(HEADERDIR)
	$(CP) crop.pro $(HEADERDIR)
	$(CP) pc\config.ps $(CONFIGDIR)\$(CONFIGFILE)
	$(CP) psfonts.map $(CONFIGDIR)
	$(CP) epsf.tex $(TEXMACRODIR)
	$(CP) epsf.sty $(TEXMACRODIR)
	$(CP) rotate.tex $(TEXMACRODIR)
	$(CP) rotate.sty $(TEXMACRODIR)
	$(CP) colordvi.sty $(TEXMACRODIR)
	$(CP) colordvi.tex $(TEXMACRODIR)
	$(CP) blackdvi.sty $(TEXMACRODIR)
	$(CP) blackdvi.tex $(TEXMACRODIR)
	$(CP) dvips.tex $(TEXMACRODIR)
	$(CP) dvipsmac.tex $(TEXMACRODIR)
	$(CP) pc\dvips.doc $(MANDIR)
	$(CP) pc\afm2tfm.doc $(MANDIR)

veryclean :
	-$(RM) *.obj
	-$(RM) dvips16.exe
	-$(RM) squeeze.exe
	-$(RM) afm2tfm.exe
	-$(RM) *.pro

clean :
	-$(RM) *.obj
	-$(RM) squeeze.exe

	
fixup:
	-rename dosection.c   dosectio.c
	-rename dospecial.c   dospecia.c
	-rename emspecial.c   emspecia.c
	-rename scalewidth.c  scalewid.c
	-rename virtualfont.c virtualf.c
	-rename tex.lpro      tex.lpr
	-rename texc.lpro     texc.lpr
	-rename texps.lpro    texps.lpr
	-rename special.lpro  special.lpr
	-rename finclude.lpro finclude.lpr
	-rename color.lpro    color.lpr
	-rename crop.lpro     crop.lpr
