
/* ---------------------------------------------------------------------*/
/*									*/
/*	XMS Interface for Borland C/C++, Version 1.1			*/
/*	Developed by Tanescu A. Horatiu					*/
/*	April 1997							*/
/*									*/
/* ---------------------------------------------------------------------*/
/*	Test program							*/
/* ---------------------------------------------------------------------*/
/*									*/
/*	MDCOPY.CPP							*/
/*									*/
/*	Copy a file to multiple destinations using eXtended memory.	*/
/*									*/
/* ---------------------------------------------------------------------*/
/*									*/
/*	Release history							*/
/*	1.0	January 1997  - Initial coding				*/
/*	1.1	April 1997    - Fixed bug that, in some cases, caused	*/
/*				an incorrect copy of the source file.	*/
/*				This happened when the XMS copy		*/
/*				routines were called with an odd number	*/
/*				of bytes, causing them to operate	*/
/*				incorrectly.				*/
/*			      - Heavily tested. Appears to work just	*/
/*				fine.					*/
/*									*/
/* ---------------------------------------------------------------------*/

#include <dos.h>
#include <dir.h>
#include <io.h>
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <string.h>
#include <ctype.h>
#include "xms.h"

#define BUFLEN 4096*2			/* read/write buffer size	*/

char srcname[MAXPATH];			/* source file name		*/
char tname[MAXPATH];			/* destination file name	*/
xmhandle x;				/* handle to the XMS block	*/
char buf[BUFLEN];			/* read/write buffer		*/
unsigned long int fb = 0;		/* number of full buffers read	*/
int lastbuf = 0;			/* size of the last buffer read	*/
long int br;				/* source file length		*/
unsigned char sfp = 1;			/* first file parameter		*/
unsigned char hash = 0;			/* hash character		*/

/*--------------------------------------------------------------*/
/*	Displays a message and asks the user wheather to	*/
/*	continue the program or not. If the answers is negative	*/
/*	halts the program.					*/
/*								*/
/*	Return Value:	None					*/
/*--------------------------------------------------------------*/
void ask(const char *msg)
{
  int c;
  puts(msg); printf("Continue anyway?(Y/N)");	/* display message */

  /* Wait for the user to press 'Y' or 'N' */
  do {
    asm	mov	ah, 0x07	/* better to use this than to include	*/
    asm	int	0x21		/* conio.h and use getch		*/
    asm	xor	ah, ah
    asm	mov	c, ax
    c = toupper(c);
  } while (c != 'Y' && c != 'N');
  printf("%c\n", c); if (hash) putchar('\n');

  /* Halt program if the user pressed 'N' */
  if (c == 'N') {
    xmfree(x); exit(-3);
  }
}

/*--------------------------------------------------------------*/
/*	Reads the source file and stores it into XMS.		*/
/*								*/
/*	Return Value:	 0 on success				*/
/*			-1 if file can't be opened		*/
/*			-2 if out of XMS memory			*/
/*--------------------------------------------------------------*/
int readsource(void)
{
  int source;		/* source file handle */
  unsigned int xsize;   /* required XMS memory in KB to store the whole file */

  /* Display hash information */
  if (hash) printf("\nHash printing on ( %c = %d bytes )\n", hash, BUFLEN);

  /* Get source file name */
  strcpy(srcname, _argv[sfp]); strupr(srcname);
  printf("\nSource file: %s\n", srcname);

  /* Open source file for reading */
  if (_dos_open(srcname, O_RDONLY, &source) != 0)
  {
    perror("Can't open"); return (-1);
  }
  br = filelength(source);		/* source file size */
  xsize = (br/1024) + 1;		/* required XMS memory in KB */
  if (hash) putchar('\n');
  printf("Reading %ld bytes...\n", br);

  /* Init XMS library */
  if (!xmsinstalled)
  {
    puts("\nCan't use XMS: No XMS Driver Installed!"); return (-2);
  }

  /* Allocate XMS memory */
  if (!(x = xmalloc(xsize)))
  {
    /* If we can't allocate memory display an error message and exit */
    pxmserror("\nCan't use XMS:");
    return (-2);
  }

  /* Read source file */

  unsigned long xoff = 0;	/* offset in the XMS block where to write next */
  int code;			/* DOS read status */
  unsigned int bytes;   	/* the actual number of bytes read */

  do
  {
    code = _dos_read(source, buf, BUFLEN, &bytes);	/* read from file */
    if (bytes == BUFLEN) fb++;
    else lastbuf = bytes;
    /* copy buffer to extended memory		*/
    /* we must transfer an EVEN number of bytes	*/
    ctoxm(x, xoff, buf, bytes%2 ? bytes+1 : bytes);
    xoff += bytes;
    if (hash) putchar(hash);		/* put hash */
  }
  while (!code && (bytes == BUFLEN));

  _dos_close(source);			/* close source file */
  if (hash) puts("\n");

  if (fb*BUFLEN+bytes != br)		/* test number of bytes read */
    ask("Warning! The number of bytes read from file doesn't match the size of the file.");

  /* remove any drive or directory information from source file name */
  char drive[MAXDRIVE];
  char dir[MAXDIR];
  char file[MAXFILE];
  char ext[MAXEXT];
  int flags = fnsplit(srcname, drive, dir, file, ext);
  strcpy(srcname, file);
  if(flags & EXTENSION) strcat(srcname, ext);

  return 0;
}

/*--------------------------------------------------------------*/
/*	Writes the content of the source file from XMS to a	*/
/*	destination file.					*/
/*								*/
/*	Return Value:	None					*/
/*--------------------------------------------------------------*/
void copyto(int destnumber)
{
  int target;

  /* Get destination file name */
  strcpy(tname, _argv[destnumber]); strupr(tname);

  /* If destination is a drive specification (e.g C:) get the current */
  /* directory for the specified drive */
  unsigned int tlen = strlen(tname);
  if (tlen == 2 && *(tname+1) == ':')
  {
    char path[MAXPATH];
    strcpy(path, "X:\\");
    *path = toupper(*tname);
    int drive = *path-'A' + 1;
    if (!getcurdir(drive, path+3)) strcpy(tname, path);
    else
    {
      printf("Invalid drive specification - %s\n", tname);
      return;
    }
  }

  /* If destination is a directory append the source file name */
  tlen = strlen(tname);
  unsigned attrib;
  if (!_dos_getfileattr(tname, &attrib))
    if (attrib & _A_SUBDIR)
    {
      if (*(tname+tlen-1) != '\\') strcat(tname, "\\");
      strcat(tname, srcname);
    }

  /* Create destination file */
  printf("Writing %s...\n", tname);
  if (_dos_creat(tname, _A_NORMAL, &target) != 0)
  {
    perror("File creation error"); if (hash) putchar('\n'); return;
  }

  /* Write to destination file */

  unsigned long xoff = 0;  /* offset in the XMS block where to read from next */
  unsigned long fbc = 1;
  unsigned int bytes;
  long int bw = 0;

  do
  {
    if (fbc <= fb) bytes = BUFLEN;
    else bytes = lastbuf;
    /* retreive buffer from extended memory	*/
    /* we must transfer an EVEN number of bytes	*/
    xmtoc(buf, x, xoff, bytes%2 ? bytes+1 : bytes);
    _dos_write(target, buf, bytes, &bytes);	/* write to file	*/
    bw += bytes;
    fbc++;
    xoff += BUFLEN;
    if (hash) putchar(hash);		/* put hash			*/
  }
  while (fbc - 1 <= fb);

  _dos_close(target);			/* close destination file	*/
  if (hash) puts("\n");

  if (bw != br)				/* test number of bytes written	*/
    ask("Warning! The number of bytes written doesn't match the size of the source file.");
}

/*--------------------------------------------------------------*/
/*	Displays a small help screen.				*/
/*								*/
/*	Return Value:	None					*/
/*--------------------------------------------------------------*/
void dhelp(void)
{
  puts("\nInsufficient number of filespecs");
  puts("\nSyntax:  mdcopy [/hash] source destination1 [destination2...]");
  puts("\n  hash    A graphical character to use as a progress indicator.");
}

/*--------------------------------------------------------------*/
/*	Main function						*/
/*--------------------------------------------------------------*/

int main(void)
{
  /* Display program header */
  puts("\nC:\\>mdcopy x y");
  puts("MDCOPY: Copy a file to multiple destinations using extended memory.");
  puts("XMS Interface Library for C/C++ Test Program, by Tanescu A. Horatiu");

  if (_argv[1][0] == '/') {		/* test if the first parameter	*/
    hash = _argv[1][1]; sfp++;		/* is a hash character		*/
  }
  if (_argc <= sfp + 1) {		/* test if we have enough	*/
    dhelp(); return 0;			/* parameters (if not display	*/
  }					/* help)			*/

  int err = readsource(); if (err) return (err);/* read source file	*/
  for (int i=sfp+1; i<_argc; i++) copyto(i);	/* copy to destinations	*/
  xmfree(x);					/* free allocated XMS	*/

  return 0;					/* return success	*/
}