/*  Keys Definition Library.
 *  Version 2.0
 *
 *  From ver 1.0: Arrow keys have been redefined, many new keys added.
 *
 *  S_ represents Shift + key combination
 *  A_ represents Alt   + key combination
 *  C_ represents Ctrl  + key combination
 *  _K represents Keypad keys
 */

//Function-keys
#define ESC         0x011B
#define F1          0x3B00
#define F2          0x3C00
#define F3          0x3D00
#define F4          0x3E00
#define F5          0x3F00
#define F6          0x4000
#define F7          0x4100
#define F8          0x4200
#define F9          0x4300
#define F10         0x4400
#define F11         0x8500
#define F12         0x8600
#define C_F1        0x5E00
#define C_F2        0x5F00
#define C_F3        0x6000
#define C_F4        0x6100
#define C_F5        0x6200
#define C_F6        0x6300
#define C_F7        0x6400
#define C_F8        0x6500
#define C_F9        0x6600
#define C_F10       0x6700
#define C_F11       0x8900
#define C_F12       0x8A00
#define S_F1        0x5400
#define S_F2        0x5500
#define S_F3        0x5600
#define S_F4        0x5700
#define S_F5        0x5800
#define S_F6        0x5900
#define S_F7        0x5A00
#define S_F8        0x5B00
#define S_F9        0x5C00
#define S_F10       0x5D00
#define S_F11       0x8700
#define S_F12       0x8800
#define A_ESC       0x0100
#define A_F1        0x6800
#define A_F2        0x6900
#define A_F3        0x6A00
#define A_F4        0x6B00
#define A_F5        0x6C00
#define A_F6        0x6D00
#define A_F7        0x6E00
#define A_F8        0x6F00
#define A_F9        0x7000
#define A_F10       0x7100
#define A_F11       0x8B00
#define A_F12       0x8C00

//Misc. keys
#define ENTER       0x1C0D
#define C_ENTER     0x1C0A
#define A_ENTER     0x1C00
#define TAB         0x0F09
#define S_TAB       0x0F00
#define C_TAB       0x9400
#define A_TAB       0xA500
#define BCKSP       0x0E08
#define C_BCKSP     0x0E7F
#define A_BCKSP     0x0E00
#define SPACE       0x3920

//Movement & control keys
#define UP          0x48E0
#define DOWN        0x50E0
#define LEFT        0x4BE0
#define RIGHT       0x4DE0
#define INSERT      0x52E0
#define HOME        0x47E0
#define PGUP        0x49E0
#define DELETE      0x53E0
#define END         0x4FE0
#define PGDOWN      0x51E0
#define C_UP        0x8DE0
#define C_DOWN      0x91E0
#define C_LEFT      0x73E0
#define C_RIGHT     0x74E0
#define C_INSERT    0x92E0
#define C_HOME 	    0x77E0
#define C_PGUP 	    0x84E0
#define C_DELETE    0x93E0
#define C_END       0x75E0
#define C_PGDOWN    0x76E0
#define A_UP        0x9800
#define A_DOWN 	    0xA000
#define A_LEFT 	    0x9B00
#define A_RIGHT     0x9D00
#define A_INSERT    0xA200
#define A_HOME 	    0x9700
#define A_PGUP 	    0x9900
#define A_DELETE    0xA300
#define A_END       0x9F00
#define A_PGDOWN    0xA100

//Keypad keys
#define UP_K 	    0x4800
#define DOWN_K 	    0x5000
#define LEFT_K 	    0x4B00
#define RIGHT_K     0x4D00
#define INSERT_K    0x5200
#define HOME_K 	    0x4700
#define PGUP_K 	    0x4900
#define DELETE_K    0x5300
#define END_K 	    0x4F00
#define PGDOWN_K    0x5100
#define FIVE_K 	    0x4C00
#define SLASH_K     0xE02F
#define AST_K 	    0x372A
#define MIN_K 	    0x4A2D
#define PLUS_K 	    0x4E2B
#define ENTER_K     0xE00D
#define C_UP_K 	    0x8D00
#define C_DOWN_K    0x9100
#define C_LEFT_K    0x7300
#define C_RIGHT_K   0x7400
#define C_INSERT_K  0x9200
#define C_HOME_K    0x7700
#define C_PGUP_K    0x8400
#define C_DELETE_K  0x9300
#define C_END_K     0x7500
#define C_PGDOWN_K  0x7600
#define C_FIVE_K    0x8F00
#define C_SLASH_K   0x9500
#define C_AST_K     0x9600
#define C_MIN_K     0x8E00
#define C_PLUS_K    0x9000
#define C_ENTER_K   0xE00A
#define A_SLASH_K   0xA400  //Alt + movement keys on keypad do not exist
#define A_AST_K     0x3700
#define A_MIN_K     0x4A00
#define A_PLUS_K    0x4E00
#define A_ENTER_K   0xA600

//Special keys
#define Right_Shift 0x01
#define Left_Shift  0x02
#define Left_CTRL   0x0100
#define Right_CTRL  0x0400
#define ALT    	    0x0200
#define ALT_GR      0x0800
#define Scroll_ON   0x10
#define Num_ON      0x20
#define Caps_ON     0x40
#define Insert_ON   0x80
#define Scroll_PR   0x1000
#define Num_PR      0x2000
#define Caps_PR     0x4000
#define SysReq_PR   0x8000
