/*
 *  CLF.CPP - the function is a part of User library.
 *  Copyleft (l) Stanislav Sokolov, June 1998 and onwards
 *
 *  This library is subject to GNU General Library Public License ver. 2 of 
 *  June 1991 and any later version. See COPYING.LIB for details.
 *
 *  You may freely use this function, provided due credits are given.
 *
 *  Contact the author by e-mail: stanislavs@hotmail.com
 *
 *  Internet:  http://members.tripod.com/~stanislavs/prog/prog.htm
 */


#include <conio.h>
#include <dos.h>

#include "d:\tc\utils\user\user.h"

void clf(int ForeColor, int BackColor){
	unsigned char Cols, Rows, Page, ColorAttr = (BackColor << 4) | ForeColor;
	register unsigned char Row = 0;

	//Read video params
	asm{
		mov AH, 0x0F
		int 0x10
		mov Cols, AH
		mov Page, BH
	}

	do{
		Row++;
		gotoxy(1, Row);
	}while ((wherey() == Row) && (Row <= 200));
	Rows = Row - 1;

	//Erase
	for(Row = Rows / 2 + 1; Row >= 1; Row--){
		//Draw top line
		asm{
			mov AH, 0x02
			mov BH, Page
			mov DH, Row
			mov DL, 0       //Col
			int 0x10        //Set cursor
			mov AH, 0x09
			mov BH, Page
			mov AL, 32      //Write char 32 (space)
			mov CL, Cols    //Set CX to Screen width (Cols)
			mov CH, 0       //
			mov BL, 0       //Set color attribute (BLACK)
			int 0x10        //Set char
		}

		//Draw bottom line
		asm{
			mov AH, 0x02
			mov BH, Page

			mov DL, Row     //Set modified value of Row: ((Rows - 1) - Row)
			mov DH, Rows    //
			dec DH          //
			sub DH, DL      //

			mov DL, 0       //Col
			int 0x10        //Set cursor
			mov AH, 0x09
			mov BH, Page
			mov AL, 32
			mov CL, Cols
			mov CH, 0
			mov BL, 0
			int 0x10
		}
		delay(50);
	}

	//Draw
	for(Row = 0; Row < Rows / 2 + 1; Row++){
		//Draw top line
		asm{
			mov AH, 0x02
			mov BH, Page
			mov DH, Row
			mov DL, 0
			int 0x10
			mov AH, 0x09
			mov BH, Page
			mov AL, 32
			mov CL, Cols
			mov CH, 0
			mov BL, ColorAttr
			int 0x10
		}

		//Draw bottom line
		asm{
			mov AH, 0x02
			mov BH, Page

			mov DL, Row
			mov DH, Rows
			dec DH
			sub DH, DL

			mov DL, 0
			int 0x10
			mov AH, 0x09
			mov BH, Page
			mov AL, 32
			mov CL, Cols
			mov CH, 0
			mov BL, ColorAttr
			int 0x10
		}
		delay(50);
	}

	textcolor(ForeColor);
	textbackground(BackColor);

	asm{
		mov AH, 0x02
		mov BH, Page
		mov DH, 0       //Row
		mov DL, 0       //Col
		int 0x10        //Set cursor
	}

}


/*int main(void){
	char far *video = (char far *)MK_FP(0xB800, 0x0000);
	for(int i=0; i<50; i++){            // draw the text screen background
		for(int j=0; j<80; j++){
			*video++ = 0xDB+2*(j/10);       // write the character to video memory
			*video++ = 16*(j/10)+j/10+1;    // write the color
		}
	}

	clf(RED, GREEN);

	return 0;

}*/
