//  ____________________________________________________
// |                                                    |
// |  Project:     POWER VIEW INTERFACE                 |
// |  File:        PVHGR.H                              |
// |  Compiler:    WPP386 (10.6)                        |
// |                                                    |
// |  Subject:     Support for graphics-mode version    |
// |                                                    |
// |  Author:      Emil Dotchevski                      |
// |____________________________________________________|
//
// E-mail: zajo@geocities.com
// URL:    http://www.geocities.com/SiliconValley/Bay/3577

#ifndef _PVHGR_H
#define _PVHGR_H

  #define HGR_MAX_BUFFERS       16

  class Thgr : public Titem
  {
    public:
      int hgr_cols, hgr_rows; //width, height in pixels
      int hgr_max_x, hgr_max_y;
      char id; //attr identifier
      char *buffer; //image buffer
      size_t buf_size; //size of the image buffer
      char color; //current color
      Thgr( int _xl, int _yl );
      virtual ~Thgr( void );
      void set_color( char _color );
      virtual void clear( void ) = 0;
      virtual void set_pixel( int _x, int _y ) = 0;
      virtual void line( int x1, int y1, int x2, int y2 ) = 0;
      virtual void draw( char *screen, int l ) = 0;
      virtual void refresh( void )=0;

    protected:
      virtual size_t get_buf_size( int _xl, int _yl ) = 0; //calculate buffer size depending on the requested item size
      virtual boolean set_buf_size( int _xl, int _yl ) = 0; //realloc buffer as requested by _xl, _yl
      virtual void resize( int _xl, int _yl );
      virtual void set_palette( void );
      virtual void draw( void );
      virtual void initialize( void );
  };

  class Tplane : public Thgr
  {
    public:
      char *plane0; //plane0 data image
      char *plane1; //plane1 data image
      char *plane2; //plane2 data image
      char *plane3; //plane3 data image
      int *mul_table; //multiply table for buffer rows
      size_t plane_size; //size of a plane buffer
      Tplane( int _xl, int _yl );
      virtual void clear( void );
      virtual void set_pixel( int _x, int _y );
      virtual void line( int x1, int y1, int x2, int y2 );
      virtual void draw( char *screen, int l );

    protected:
      virtual size_t get_buf_size( int _xl, int _yl ); //calculate buffer size depending on the requested item size
      virtual boolean set_buf_size( int _xl, int _yl ); //realloc buffer as requested by _xl, _yl
  };

#endif

#ifdef DECLARE_PVHGR
  #define GLOBAL
#else
  #define GLOBAL extern
#endif

  GLOBAL Thgr *hgrs[HGR_MAX_BUFFERS];

#undef GLOBAL
