;       READENV.ASM -- Reads Environment Strings
;       --------------------------------------------------

;This program reads the Environment strings to demonstrate:
;   1. How to find and print each of the strings in the Environment
;   2. How to search for and find an Environment string by
;           means of its variable name

;Program structure:
;   1. Read the entire Environment in a loop
;           1. Copy each string to a buffer
;           2. 0 terminate it
;           3. Print it
;   2. Find a particular string by variable name
;   3. Print it

CSEG            Segment
                Assume  CS:CSEG, DS:CSEG, ES:CSEG, SS:CSEG
                Org     100h                    ; For COM file
Entry:          Jmp     Main

;All data is here:
notice                  db 'Copyright 1986 Ziff-Davis Publishing Co.'
notice2                 db 'Programmed by Richard Hale Shaw'
Environment_Offset      Equ     02ch
MAXIMUM_ENV_STRING      Equ     127
String_prefix           db      0Dh,0Ah
Env_String_Buffer       db      MAXIMUM_ENV_STRING+2 dup(1)
Env_Offset              dw      0
Environment             dw      0
Variable_to_find        db      'path',0

;
;---------------------------------------------------
;
Main:
                Call    Set     ; Call subroutine to imitate DOS SET

                ; Next, find "PATH" and display entire string if found
                ; "PATH" is stored at Variable_to_find

                Lea     SI,Variable_to_find     ; Address of variable name
                                                ; to find into SI
                Call    Getvar                  ; Get the variable
                Cmp     CX,0                    ; If CX is 0, not found, so
                Je      Exit                    ; Get out of program
                Call    Print_Env_string        ; Else print the string found

Exit:
                Int     20h                     ; Exit program


; Subroutines: ----------------------------------------------------------------


Set:            ; Like the DOS SET command, reads each environment string
                ; and prints each one out

                Mov     Word Ptr Env_offset,0   ; Set to search Environment
                                                ; From the beginning

Find_string:    Call    Find_Env_String         ; Find a string
                Cmp     CX,0                    ; If CX is 0
                Je      End_set                 ; No string found, go ahead
                Call    Print_Env_string        ; else Call Print Environment
                                                ; string routine
                Jmp     Find_string             ; Try for another string
End_Set:        Ret                             ; Return to caller


;-----------------------------------------------------------------------------
Getvar:
    ; requires SI to point to NULL-terminated variable to find
    ; if CX is 0 upon return, the string was not found

                Mov     Word Ptr Env_offset,0   ; Set to search Environment
                                                ; From the beginning

                Call    String_length   ;Get length of variable to find
                                        ; Pointed to by SI
                Cmp     CX,0            ; If length of string to compare is 0
                Je      End_getvar      ; No variable to compare
                Call    Upper           ; Upper case the variable

Another_string:
                Push    CX                      ; Save CX (length of variable)
                Push    SI                      ;Save SI (Address of variable)
                Call    Find_env_string         ; Find a string
                Pop     SI                      ; Get it back from stack
                Cmp     CX,0                    ; If CX is 0
                Pop     CX                      ; Restore CX from stack

                Je      Not_found               ; String not found

                Cld                             ; Clear direction flag
                Push    SI                      ; Save Address of variable
                Push    ES                      ; Save ES on stack
                Push    DS                      ; Save DS on stack
                Pop     ES                      ; Put DS into ES
                Lea     DI,Env_string_buffer    ; Address of buffer into DI
                Push    CX                      ; Save length on stack
                Repe Cmpsb                      ; Compare the two strings
                Pop     CX                      ; Restore length
                Pop     ES                      ; Restore ES
                Pop     SI                      ; Restore variable address
                Jne     Another_string
                Cmp     Byte Ptr[DI],'='        ; If '=' next character
                Je      End_getvar              ;Got it, length in CX, get out

Not_found:
                Xor     CX,CX                   ; Don't have it, clear CX

End_getvar:     Ret                             ; Return to caller

;-----------------------------------------------------------------------------
String_length:
    ; requires SI to point to string to get length of
    ; Length of string in CX on return
    ; String should be NULL-terminated

                Push    SI                      ; Save SI on stack
                Xor     CX,CX                   ; Clear CX to 0
Next_one:
                Cmp     Byte Ptr[SI],0          ; If 0 found
                Je      End_string              ; Go to End string
                Inc     CX                      ; Add 1 to count in CX
                Inc     SI                      ; Next byte to compare
                Jmp     Next_one                ; Compare next one
End_string:
                Pop     SI                      ; Restore SI from stack
                Ret                             ; Return to caller

;-----------------------------------------------------------------------------
Print_Env_string:
    ; Prints NULL-terminated Environment string pointed to by  
    ; Env_string_buffer
    ; Calls Int 21h function 2 to print each character
    ; Terminates when NULL-terminater is reached

                Push    SI                      ; Save SI on stack
                Lea     SI, String_prefix       ;Load address of buffer into AX
Print_another:

                Mov     DL,Byte Ptr[SI]         ; Character to print into DL
                Cmp     DL,0                    ; If character is Zero
                Je      End_Print_Env_string    ; Get out
                Mov     AH,2                    ; Function to print string
                Int     21h                     ; Call DOS
                Inc     SI                      ; Point to next character
                Jmp     Print_another           ; Loop back

End_Print_Env_string:
                Pop     SI                      ; Restore SI
                Ret                             ; Return to caller

;-----------------------------------------------------------------------
Find_Env_String:
    ; Finds an Environment string beginning with the first
    ; One.  Copies each to the Env_string_buffer.  If End
    ; of Environment found, places Zero in buffer, and CX
    ; is 0.

                Cmp     Word Ptr Environment,00 ; See if Environment address
                                                ; is available
                Ja      Get_Env_string          ; If Available, Get a string

                                                ; If not,
                Mov     AX,CS:[2Ch]             ; Get Environment address
                Mov     Word Ptr Environment,AX ; Store Environment address

Get_Env_string:
                Lea     DI,Env_string_buffer    ; Address of buffer into DI
                Mov     SI,Word Ptr Env_offset  ; Current Environment Offset
                                                ; into SI
                Mov     AX,DS                   ; Get DS into AX
                Mov     ES,AX                   ; And put it in ES
                Mov     AX,Word Ptr Environment ;Get Environment Segment Addr.
                Mov     DS,AX                   ; Put it into DS
                Xor     CX,CX                   ; Clear CX to 0
                Push    SI                      ; Save SI on stack

Next_byte:
                Cmp     Byte Ptr[SI],00         ; Check for End of Environment
                                                ; String
                Je      End_env_string          ; If found, break out of loop
                Inc     CX                      ; Add 1 to count
                Inc     SI                      ; Point to next byte
                Jmp     Next_byte               ; Loop back to check next byte

End_env_string:
                Pop     SI                      ; Restore SI from stack
                Cmp     CX,0                    ; If CX is 0
                Je      End_Find_Env_string     ; Nothing to move, goto finish

Move_bytes:
                Push    CX                      ; Save count on stack
                Mov     AX,SI                   ; Put SI offset into AX
                Add     AX,CX                   ; Add number of bytes found
                Inc     AX                      ; Add one

                Mov     Word Ptr ES:Env_offset,AX     ; Set Env_offset for
                                                ; current Environment offset

                Cld                     ; Clear direction flag for forward move
                Rep Movsb               ; Copy Bytes from Environment to buffer

                Mov     Byte Ptr ES:[DI],0      ; Set last byte to zero
                Pop     CX                      ; Restore count from stack

End_Find_Env_string:
                Mov     AX,ES                   ; Set Data Segment back into
                Mov     DS,AX                   ; DS
                Ret                             ; Return to caller

;-----------------------------------------------------------------------------
Upper:
    ; Uppercases the Null-terminated string pointed to by SI

                Push    SI                      ; Save SI Pointer

Upper_Another:  Cmp Byte Ptr[SI],0              ; If NULL
                Je      End_upper               ; Get out
                Xor     Byte Ptr[SI],32         ; Uppercase the character
                Inc     SI                      ;Increment SI to next character
                Jmp     Upper_Another           ; Uppercase the next character

End_upper:      Pop     SI                      ; Restore SI from stack
                Ret

;-----------------------------------------------------------------------------
EndProg         Label   Byte                    ; End of program
CSEG            Ends
                End Entry

; End of Readenv.asm
                                                                                                                                                             