//***************************************************************************
//
//  WndRgn.c
//
//***************************************************************************

#include <windows.h>

LRESULT CALLBACK WndProc (HWND, UINT, WPARAM, LPARAM);
HRGN ClipTextOutline (HDC, int, int, LPSTR);
void DoGradientFill (HDC, PRECT);

/////////////////////////////////////////////////////////////////////////////
// WinMain

int WINAPI WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance,
    LPSTR lpszCmdLine, int nCmdShow)
{
    static char szAppName[] = "Window Region Demo";
    WNDCLASS wc;
    HWND hwnd;
    MSG msg;

    wc.style = CS_HREDRAW | CS_VREDRAW;
    wc.lpfnWndProc = (WNDPROC) WndProc;
    wc.cbClsExtra = 0;
    wc.cbWndExtra = 0;
    wc.hInstance = hInstance;
    wc.hIcon = LoadIcon (NULL, IDI_APPLICATION);
    wc.hCursor = LoadCursor (NULL, IDC_ARROW);
    wc.hbrBackground = (HBRUSH) (COLOR_WINDOW + 1);
    wc.lpszMenuName = NULL;
    wc.lpszClassName = szAppName;

    RegisterClass (&wc);

    hwnd = CreateWindow (szAppName, szAppName,
        WS_OVERLAPPEDWINDOW, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT,
        CW_USEDEFAULT, HWND_DESKTOP, NULL, hInstance, NULL);

    ShowWindow (hwnd, nCmdShow);
    UpdateWindow (hwnd);

    while (GetMessage (&msg, NULL, 0, 0)) {
        TranslateMessage (&msg);
        DispatchMessage (&msg);
    }
    return msg.wParam;
}

/////////////////////////////////////////////////////////////////////////////
// Window procedure

LRESULT CALLBACK WndProc (HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
    HDC hdc;
    PAINTSTRUCT ps;
    HFONT hFont, hOldFont;
    HRGN hRgn;
    static TCHAR szText[2] = { (TCHAR) 0xFF, (TCHAR) 0x00 };
    int nHeight;
    RECT rect;
    SIZE size;
    LRESULT lHitTest;

    switch (msg) {

    case WM_CREATE:
        hdc = GetDC (hwnd);
        nHeight = -((GetDeviceCaps (hdc, LOGPIXELSY) * 144) / 72);
        hFont = CreateFont (nHeight, 0, 0, 0, FW_NORMAL, 0, 0, 0,
            DEFAULT_CHARSET, OUT_CHARACTER_PRECIS, CLIP_CHARACTER_PRECIS,
            DEFAULT_QUALITY, DEFAULT_PITCH | FF_DONTCARE, "Wingdings");
        hOldFont = (HFONT) SelectObject (hdc, hFont);

        GetTextExtentPoint32 (hdc, szText, lstrlen (szText), &size);
        SetWindowPos (hwnd, NULL, 0, 0, size.cx, -nHeight,
            SWP_NOMOVE | SWP_NOREDRAW | SWP_NOZORDER);

        hRgn = ClipTextOutline (hdc, 0, 0, szText);
        SetWindowRgn (hwnd, hRgn, FALSE);

        DeleteObject (SelectObject (hdc, hOldFont));
        ReleaseDC (hwnd, hdc);
        return 0;

    case WM_PAINT:
        hdc = BeginPaint (hwnd, &ps);
        GetClientRect (hwnd, &rect);
        DoGradientFill (hdc, &rect);
        EndPaint (hwnd, &ps);
        return 0;

    case WM_NCHITTEST:
        lHitTest = DefWindowProc (hwnd, WM_NCHITTEST, wParam, lParam);
        return (lHitTest == HTCLIENT) ? HTCAPTION : lHitTest;

    case WM_DESTROY:
        PostQuitMessage (0);
        return 0;
    }
    return DefWindowProc (hwnd, msg, wParam, lParam);
}

/////////////////////////////////////////////////////////////////////////////
// Helper routines

HRGN ClipTextOutline (HDC hdc, int x, int y, LPSTR pszText)
{
    HRGN hRgn1, hRgn2;
    RECT rect;

    BeginPath (hdc);
    TextOut (hdc, x, y, pszText, lstrlen (pszText));
    EndPath (hdc);

    hRgn1 = PathToRegion (hdc);
    GetRgnBox (hRgn1, &rect);
    hRgn2 = CreateRectRgnIndirect (&rect);
    CombineRgn (hRgn2, hRgn2, hRgn1, RGN_DIFF);

    DeleteObject (hRgn1);
    return hRgn2;
}

void DoGradientFill (HDC hdc, PRECT pRect)
{
    int i, nWidth, nHeight;
    HBRUSH hBrush[64];
    RECT rect;

    for (i=0; i<64; i++)
        hBrush[i] = CreateSolidBrush (RGB (255 - (i * 4), 0, 0));

    nWidth = pRect->right - pRect->left;
    nHeight = pRect->bottom - pRect->top;

    for (i=0; i<nHeight; i++) {
        SetRect (&rect, pRect->left, i + pRect->top, pRect->right,
            i + pRect->top + 1);
        FillRect (hdc, &rect, hBrush[(i * 63) / nHeight]);
    }

    for (i=0; i<64; i++)
        DeleteObject (hBrush[i]);
}
