//****************************************************************
//           EXPRESSION EVALUATOR                  
//****************************************************************
#include <stdio.h>
#include <math.h>

#define false 0
#define true 1

int NextChar;
int contin = true;

float Factor(void);
float Expression(void);
float Term(void);
//****************************************************************
// GetNextChar - Reads characters until a non-space char is found
//****************************************************************
void GetNextChar(void) {
	while ((NextChar = getchar()) == ' ');
}

//****************************************************************
// Expression - Recursive routine that evaluates an expression
//     EXPRESSION = <EXPRESSION> + <TERM> | <EXPRESSION> - <TERM>
//****************************************************************
float Expression(void) {
	float value;
	value = Term();

	for (;;)	{
   	switch (NextChar) {
			case ' ':
				GetNextChar(); 
				break;
			case '+':
				GetNextChar(); 
				value = value + Term(); 
				continue;
			case '-':
				GetNextChar(); 
				value = value - Term(); 
				continue;
			default:
				return value;
		}
	}
}

//****************************************************************
// Term - Handles multiplication and division
//  <TERM> = <TERM> * <FACTOR> | <TERM> DIV <FACTOR> | <FACTOR>
//****************************************************************
float Term(void) {
	float value, divisor;

	value = Factor();
	for(;;) {
		switch(NextChar) {
			case ' ': 
				GetNextChar(); 
				break;
			case '*':
				GetNextChar(); 
				value = value * Factor(); 
				continue;
			case '^':
				GetNextChar(); 
				value = pow(value, Factor()); 
				continue;
			case '/':
				GetNextChar();
				if ((divisor = Factor()) != 0) {
					value = value / divisor; 
					continue;
				} else {
					printf ("  DIVISION BY ZERO\n");
					exit(0);
				}
			default:
				return value;
		}
	}
}

//****************************************************************
// Factor - Handles numbers minus signs and parens
//  <FACTOR> = <EXPRESSION> | <VARIABLE> | <CONSTANT>
//****************************************************************
float Factor(void) {
	float value = 0;
	int count = 0;
	int i;
	int d_point = false;

	if ((NextChar <= '9') && (NextChar >= '0')) {
		while ((NextChar <= '9') && (NextChar >= '0')) {
			value = value * 10 + NextChar - '0';
			NextChar = getchar();
			if (d_point)
				count++;
			if (NextChar == '.') {
				NextChar = getchar();
				d_point = true;
			}
		}
		for (i = 0; i < count; i++)
			value = value / 10;
		return value;
	} else {
		switch(NextChar) {
			case '-':
				GetNextChar(); 
				return -1*Factor();
			case '(':
				GetNextChar(); 
				value = Expression(); 
				if (NextChar != ')') { 
					printf ("  MISMATCHED PARENTHES\n");
					exit(0);
				} else
					NextChar = getchar(); 
            return value;
			case '.': 
				d_point = true;
		   default:
				contin = false;
		}
	}	
	return 0;
}

//****************************************************************
// Main - Program entry point
//****************************************************************
void main () {
    float result;

    printf ("\nExpression must not contain any other symbols but:\n");
    printf("\n'+' - addition\n'-' - subtraction\n'*' - multiplication");
    printf("\n'/' - division\n'(' - left parenthesis\n')' - right parenthesis");
    printf("\n'.' - decimal point (must be preceeded by digit)");
    printf ("\n'^' - x^y means x to the power of y\n\n");
    printf ("\n\nENTER EXPRESSION:   ");

    GetNextChar ();
    result = Expression();

	 if ((NextChar == '\n') && (contin))
       printf ("THE RESULT IS:   %1.3f\n", result);
    else {
       printf ("  SYNTAX ERROR\n");
       exit(0);
    }
}
