{
TITLE:  Unit UTEST2.PAS
Caption:Figure 6:  The source code for TFileDlg, an OWL object that interfaces with and processes messages
for the Open File common dialog.
}


unit UTest2;

interface

uses winprocs, wintypes, wobjects, commdlg, windos, strings;

type
   PFileDlg = ^TFileDlg;
   TFileDlg = object(TDialog)
     OFN : TOpenFileName;
     constructor Init(AParent : PWindowsObject;
                      AFlags   : Longint;
                      AFileName : Pchar;
                      ANameLength : Integer);
		 destructor  Done;  virtual;
     function    Create : Boolean; virtual;
     function    Execute : Integer; virtual;
     procedure   OK(var Msg : TMessage);     virtual id_First+id_OK;
     procedure   Cancel(var Msg : TMessage); virtual id_First+id_Cancel;
   end;


implementation

constructor TFileDlg.Init(AParent : PWindowsObject;
                          AFlags   : Longint;
                          AFileName : Pchar;
                          ANameLength : Integer);
var
  TempName : array[0..fsFileName] of Char;
  TempExt  : array[0..fsExtension] of Char;

begin
   TDialog.Init(AParent,nil);
   FillChar(OFN,Sizeof(OFN),0);
   with OFN do
   begin
     lStructSize := SizeOf(OFN);
     hwndOwner := AParent^.hWindow;
     @lpfnHook := Instance;
     Flags     := AFlags or OFN_ENABLEHOOK;
     hInstance := System.hInstance;
     lpstrFileTitle  := nil;
     nMaxFileTitle   := 0 ;
     GetMem(lpstrInitialDir,Succ(fsDirectory));
     lpstrFile := AFileName;
     nMaxFile        := ANameLength;
     lpStrTitle := 'Open File';
     FileExpand(lpstrFile,AFileName);
     FileSplit(lpstrFile,lpstrInitialDir,TempName,TempExt);
     StrCat(StrCopy(lpstrFile,TempName),TempExt);
   end;
end;


destructor TFileDlg.Done;
begin
 FreeMem(OFN.lpstrInitialDir,Succ(fsDirectory));
 TDialog.Done;
end;



function    TFileDlg.Create : boolean;
begin
  Create := False;  { Cannot create a non-modal File Open dialog }
end;


function    TFileDlg.Execute : integer;
{ Basically, This is the code from TDialog.Execute with the call to
  DialogBoxParam changed to GetOpenFileName }
var
  CDError : Longint;
  OldKbHandler: PWindowsObject;
begin
  if Status = 0 then
  begin
    DisableAutoCreate;
    EnableKBHandler;
    IsModal := True;
    OldKbHandler := Application^.KBHandlerWnd;
    if GetOpenFileName(OFN) then
      Execute := id_ok
    else
    begin
      CDError := CommDlgExtendedError;
      if CDError = 0 then
        execute := id_Cancel
      else
      begin
        Status := -CdError;
        Execute := Status;
      end;
    end;
    Application^.KBHandlerWnd := OldKbHandler;
    HWindow := 0;
  end
  else Execute := Status;
end;


procedure   TFileDlg.OK(var Msg : TMessage);
{ COMMDLG requires that the hook function (ie: this method) does NOT
  call EndDlg() for it's modal dialogs.  Setting Msg.Result to 0 will
  allow COMMDLG to terminate the dialog.  A value of 1 will cause
  COMMDLG to ignore the OK button press. }
begin
  if CanClose then
    Msg.Result := 0
  else
    Msg.Result := 1;
end;

procedure   TFileDlg.Cancel(var Msg : TMessage);
begin
  Msg.Result := 0
end;


end.
