{
TITLE	:  TEST1.PAS
Caption	:  A small TPW program to display the normal and modified Font dialogs.  
}

program Test1;

{$R Test1}

uses wintypes, winprocs, wobjects, commdlg;

type

  TMyApp = object(TApplication)
    procedure InitMainWindow; virtual;
  end;

  PMyMainWindow = ^TMyMainWindow;
  TMyMainWindow = object(TMDIWindow)
    procedure cmChooseFont1(var Msg: TMessage); virtual cm_First + 101;
    procedure cmChooseFont2(var Msg: TMessage); virtual cm_First + 102;
  end;

procedure TMyMainWindow.cmChooseFont1(var Msg: TMessage);
var
  CF: TChooseFont;
  LF: TLogFont;
  FStyle: array [0..LF_FaceSize] of char;
begin
  FillChar(CF, Sizeof(CF), #0);
  FillChar(LF, Sizeof(LF), #0);
  FStyle[0] := #0;
  with CF do
  begin
    lStructSize := SizeOf(CF);
    HWndOwner := HWindow;
    lpLogFont := @LF;
    Flags := cf_TTOnly or cf_ScreenFonts;
    lpszStyle := @FStyle;
  end;

  ChooseFont(CF);
end;

procedure TMyMainWindow.cmChooseFont2(var Msg: TMessage);
var
  CF: TChooseFont;
  LF: TLogFont;
  FStyle: array [0..LF_FaceSize] of char;
begin
  FillChar(CF, Sizeof(CF), #0);
  FillChar(LF, Sizeof(LF), #0);
  FStyle[0] := #0;
  with CF do
  begin
    lStructSize := SizeOf(CF);
    HWndOwner := HWindow;
    lpLogFont := @LF;
    Flags := cf_TTOnly or cf_ScreenFonts or cf_EnableTemplate;
    lpTemplateName := 'MyFontDlg';
    CF.HInstance := System.HInstance; 
    lpszStyle := @FStyle;
  end;

  ChooseFont(CF);
end;

procedure TMyApp.InitMainWindow;
begin
  MainWindow := new(PMyMainWindow, Init('Test CommDlg',
                     LoadMenu(HInstance, 'MainMenu')));
end;

var MyApp: TMyApp;
begin
  MyApp.Init('TestCommDlg');
  MyApp.Run;
  MyApp.Done;
end.