UNIT EString;
(**) INTERFACE (**)
USES WObjects, Strings, OString;
TYPE
  PEString = ^TEString;
  TEString = OBJECT(TOString)
    Excess : Word;
    CONSTRUCTOR Init(WMaxSize : Word);
    PROCEDURE AddPChar(P : PChar); Virtual;
    FUNCTION ExpandTo(W : Word) : Boolean;
    FUNCTION GetExcess : Word;
  END;

(**) IMPLEMENTATION (**)
CONSTRUCTOR TEString.Init(WMaxSize : Word);
BEGIN
  TOString.Init(WMaxSize);
  IF vPChar = NIL THEN Fail;
  Excess := 0;
END;

PROCEDURE TEString.AddPChar(P : PChar);
BEGIN
  IF Len + StrLen(P) > MaxSize THEN
    Inc(Excess, Len + StrLen(P) - MaxSize)
  ELSE TOString.AddPChar(P);
END;

FUNCTION TEString.GetExcess : Word;
BEGIN
  GetExcess := Excess;
END;

FUNCTION TEString.ExpandTo(W : Word) : Boolean;
VAR P : PChar;
BEGIN
  ExpandTo := FALSE;
    {- don't SHRINK smaller than current contents! -}
  IF W < Len THEN Exit;
  GetMem(P, W+1);
    {- fail if can't allocate bigger PChar -}
  IF P = NIL THEN Exit;
    {- copy contents to new, bigger PChar -}
  StrCopy(P, vPChar);
    {- get rid of puny old PChar -}
  FreeMem(vPChar, MaxSize+1);
  vPChar   := P;
  MaxSize  := W;
  Excess   := 0;
  ExpandTo := TRUE;
END;

END.

