;RegPrint.asm
;Copyright (c) 1992 Jay Munro
;First Published in PC Magazine June 16, 1992

;Prints the current register status to the Monochrome screen
;preserves all registers

.286P
.Model Medium

 Public RegPrint
 Extrn   __B000H :ABS           ;selector for Mono monitor
.Code

RegPrint Proc Far
   Push BP                      ;save BP (original)
   Mov  BP,SP                   ;SP = BP + 2

;---- All reg's saved
   PushF                        ;BP - 2        ;flags
   Push Word Ptr [BP + 2]       ;original IP
   Sub  Word Ptr [BP-4],5       ;subtract 5 bytes for call to RegPrint
   Push Word Ptr [BP + 4]       ;original CS   ;CS
   Push SS                      ;BP - 6
   Push ES                      ;BP - 8
   Push DS                      ;BP - 10
   Push DI                      ;BP - 12
   Push SI                      ;BP - 14
   Push Word Ptr [BP]           ;original BP that was saved
   Push BP                      ;BP - 18 (sp)
   Inc  Word Ptr SS:[BP-18]     ;make SP by adding 2 to BP
   Inc  Word Ptr SS:[BP-18]
   Push DX                      ;BP - 20
   Push CX                      ;BP - 22
   Push BX                      ;BP - 24
   Push AX                      ;BP - 26

   Mov  BX,__B000h              ;segment of monochrome monitor
   Mov  ES,BX                   ;put mono selector into ES
   Xor  DI,DI                   ;clear DI
   Mov  AH,7                    ;white on black attribute
   Push CS
   Pop  DS                      ;get DS:SI pointing to templage
   Lea  SI,Template
   Mov  CX,160                  ;print 160 characters
   Cld                          ;forward direction
   Push DI                      ;save DI location

PLoop:                          ;print template
   LodSb
   StoSw
   Loop PLoop
   Pop  DI                      ;retrive DI

   Push DI                      ;save for second line
   Add  DI,6                    ;slide DI over to first column

;---Print AX - DI               ;
   Lea  SI,[BP-28]
   Push SS                      ;point DS at SS
   Pop  DS
   Mov  CX,8                    ;do 8 words
   Cld                          ;forward direction (up the stack)
   
DoFirstEight:
   LodSw
   Call Print2Bytes             ;print it
   Add  DI,10                   ;skip over template data
   Loop DoFirstEight

   Pop  DI
   Add  DI,166                  ;point to next line
   Mov  CX,5                    ;and do 5 variables
   
DoNextFive:
   LodSw
   Call Print2Bytes             ;print it
   Add  DI,10                   ;skip over template data
   Loop DoNextFive
   
DoFlags:
   Sub  DI,6                    ;we're currently 6 bytes overshooting
   LodSw                        ;get flag byte into AX
   Mov  BX,AX
   Push CS
   Pop  DS
   Lea  SI,FlagMnemonics        ;point DS:SI at flag mnemonics
   Mov  DX,SI                   ;save value in DX also
   Shl  BX,4                    ;skip over Nested task and IOP flags
   Mov  CX,3

First3:
   Clc                          ;clear carry first
   Shl  BX,1                    ;bump a bit off the end
   Jc   @F                      ;get clear word
   Add  SI,2                    ;
@@:
   Call PrintFlagMn
   Loop First3

   Shl  BX,1                    ;skip trap bit
   Mov  CX,2

Next2:                          ;print Sign and Zero
   Clc                          ;clear carry first
   Shl  BX,1                    ;bump a bit off the end
   Jc   @F                      ;get clear word
   Add  SI,2                    ;
@@:
   Call PrintFlagMn
   Loop Next2
   
   Mov  CX,2
   
Last3:
   Clc                          ;clear carry first
   Shl  BX,2                    ;skip space, and get AC
   Jc   @F                      ;get Aux carry
   Add  SI,2                    ;
@@:
   Call PrintFlagMn
   Loop Last3

Exit:           ;retrieve registers
   Pop  AX
   Pop  BX
   Pop  CX
   Pop  DX
   Add  SP,4    ;skip over SP & BP
   Pop  SI
   Pop  DI
   Pop  DS
   Pop  ES
   Add  SP,6    ;skip over SS & CS
   PopF

   Mov  SP,BP
   Pop  BP
   Ret

;entry with   ES:DI pointing toward screen location
;             BX = Word to print
;             CX trashed

Print2Bytes:
   Mov   BX,AX          ;make copy of word
   Shr   AX,12          ;get left most nibble
   Call  HexOut
   Mov   AL,BH          ;get next nibble
   And   AL,0Fh         ;
   Call  HexOut
   Mov   AL,BL          ;get next byte
   Shr   AL,4           ;and next nibble
   Call  HexOut         ;printit
   Mov   AL,BL          ;and last nibble
   And   AL,0Fh         ;

HexOut:
   Cmp  AL,10
   Jae  NotNumber
   Add  AL,"0"          ;make it an ascii digit
   Jmp  Short SendIt
NotNumber:
   Add  AL,55           ;make it a hex letter

SendIt:
   StoSb                ;store byte
   Inc  DI              ;and skip attribute
   RetN
   
PrintFlagMn:
   LodSb
   StoSb
   Inc  DI              ;skip attribute
   LodSb
   StoSb
   Add DI,3             ;skip attribute and on to next character

   Add DX,4             ;point to next two bytes
   Mov SI,DX            ;retread SI
   RetN
   
   

Template DB  'AX=0000  BX=0000  CX=0000  DX=0000  SP=0000  BP=0000  SI=0000  DI=0000          '
         DB  'DS=0000  ES=0000  SS=0000  CS=0000  IP=0000  NV UP EI PL NZ NA PO NC            '
             ;0123456789012345678901234567890123456789012345678901234567890123456789

FlagMnemonics DB 'OVNVDNUPEIDINGPLZRNZACNAPEPOCYNC'

RegPrint EndP
End
