// DEMO2.C  Minimally pen-aware Windows application that demonstrates 
// simple text input or handwritten input via a dialog, then displays 
// same text in main window.
// Copyright (C) 1991 Ray Duncan

#define WIN31

#include "windows.h"
#include "penwin.h"
#include "demo2.h"

HANDLE hInst;                               // instance handle
HWND hWnd;                                  // main window handle

HANDLE hPenWin = NULL;                      // Pen Windows module handle

#define INPUTSIZE 80                        // max length of input
#define OUTPUTSIZE 256                      // max length of output

char buf1[INPUTSIZE];                       // user's input buffer
char buf2[OUTPUTSIZE];                      // formatted output buffer

//
// WinMain - entry point from Windows.  Registers window class,
// creates main window, processes messages until WM_QUIT received.
//
int PASCAL WinMain(HANDLE hInstance, 
    HANDLE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
    MSG msg;                     

    VOID (FAR PASCAL *RegisterPenApp)(WORD, BOOL) = NULL;

    hInst = hInstance;                      // save this instance handle

    strcpy(buf1, "Nothing yet!");           // initialize output text

    if(!hPrevInstance)                      // if first instance,
        if(!InitApplication(hInstance))     // register window class
            return (FALSE);                 // exit if couldn't register

    if(!InitInstance(hInstance, nCmdShow))  // create this instance's window
        return (FALSE);

    if(hPenWin = GetSystemMetrics(SM_PENWINDOWS))   // Pen Windows running?
    {                                       // if so, register as Pen app
        if(RegisterPenApp = GetProcAddress(hPenWin, "RegisterPenApp"))
            (*RegisterPenApp)(RPA_DEFAULT, TRUE);
    }

    while(GetMessage(&msg, NULL, 0, 0))     // while message != WM_QUIT
    {
        TranslateMessage(&msg);             // translate virtual key codes
        DispatchMessage(&msg);              // dispatch message to window
    }
    return (msg.wParam);                    // return code = WM_QUIT value
}

//
//  InitApplication - registers window class for this application
//
BOOL InitApplication(HANDLE hInstance)
{
    WNDCLASS  wc;

                                            // set class parameters
    wc.style = NULL;                        // class style
    wc.lpfnWndProc = MainWndProc;           // class callback function
    wc.cbClsExtra = 0;                      // extra per-class data
    wc.cbWndExtra = 0;                      // extra per-window data
    wc.hInstance = hInstance;               // handle of class owner
    wc.hIcon = LoadIcon(NULL, IDI_APPLICATION);     // default icon
    wc.hCursor = LoadCursor(NULL, IDC_ARROW);       // default cursor
    wc.hbrBackground = GetStockObject(WHITE_BRUSH); // background color 
    wc.lpszMenuName =  "DemoMenu";          // name of menu resource
    wc.lpszClassName = "DemoWinClass";      // name of window class

    return (RegisterClass(&wc));            // register class, return flag
}

//
// InitInstance - creates main window for this application instance
//
BOOL InitInstance(HANDLE hInstance, int nCmdShow)
{
    hWnd = CreateWindow(                    // create frame window
        "DemoWinClass",                     // window class name
        "Pen Windows Demo #2",              // text for title bar
        WS_OVERLAPPEDWINDOW,                // window style
        CW_USEDEFAULT,                      // default horizontal position
        CW_USEDEFAULT,                      // default vertical position
        CW_USEDEFAULT,                      // default width
        CW_USEDEFAULT,                      // default height
        NULL,                               // no parent window
        NULL,                               // use class default menu
        hInstance,                          // window owner
        NULL                                // unused pointer
    );

    if (!hWnd) return (FALSE);              // error, can't create window

    ShowWindow(hWnd, nCmdShow);             // make window visible
    UpdateWindow(hWnd);                     // force WM_PAINT message
    return (TRUE);                          // return success flag
}

//
// MainWndProc - callback function for main application window
//
long FAR PASCAL MainWndProc(HWND hWnd, WORD wMsg, WORD wParam, LONG lParam)
{
    HDC hdc;                                // device context handle
    PAINTSTRUCT ps;                         // painting info structure
    RECT rect;                              // receives client rectangle

    switch (wMsg) 
    {
        case WM_COMMAND:                    // menu command received,
            DoCommand(hWnd, wParam);
            break;

        case WM_PAINT:                      // window needs repainting
            hdc = BeginPaint(hWnd, &ps);    // get device context
            GetClientRect(hWnd, &rect);     // get client rectangle
            wsprintf(buf2, "You entered: %s", (LPSTR) buf1);
            DrawText(hdc, buf2, -1, &rect,  // display formatted text
                DT_SINGLELINE | DT_CENTER | DT_VCENTER);
            EndPaint(hWnd, &ps);            // release device context
            break;

        case WM_SIZE:                       // window resized
            InvalidateRect(hWnd, NULL, TRUE);   // repaint everything
            UpdateWindow(hWnd);             // force WM_PAINT message
            break;

        case WM_DESTROY:                    // window being destroyed
            PostQuitMessage(0);
            break;

        default:                            // let Windows handle it
            return(DefWindowProc(hWnd, wMsg, wParam, lParam));
    }

    return(0);
}

//
// DoCommand - handles menu command messages
//
void DoCommand(HWND hWnd, WORD wParam)
{
    FARPROC lpProc;                         // far pointer to callback 

    switch(wParam)                          // decode it
    {
        case IDM_EXIT:                      // user picked File-Quit
            SendMessage (hWnd, WM_CLOSE, 0, 0L);
            break;

        case IDM_ENTER:                     // user picked Edit-Enter
            lpProc = MakeProcInstance(EntryDlgProc, hInst);
            DialogBox(hInst, "TextEntryBox", hWnd, lpProc);
            InvalidateRect(hWnd, NULL, TRUE);   // repaint everything
            UpdateWindow(hWnd);             // force WM_PAINT message
            FreeProcInstance(lpProc);
            break;

        default:                            // unknown command, ignore it
            break;
    }
}

//
// EntryDlgProc - callback function for "Text Entry..." dialog
//
BOOL FAR PASCAL EntryDlgProc(HWND hDlg, WORD wMsg, WORD wParam, LONG lParam)
{
    switch (wMsg) 
    {
        case WM_INITDIALOG:                 // dialog box initialization
            return (TRUE);                  // signal message processed

        case WM_COMMAND:                    // command received
            if(wParam == IDOK)              // OK button clicked?
            {                               // yes, retrieve text
                GetDlgItemText(hDlg, IDD_EDITTEXT, buf1, INPUTSIZE-1);
                EndDialog(hDlg, TRUE);      // signal text accepted
            }
            else if(wParam == IDD_CANCEL)   // Cancel button clicked?
            {
                strcpy(buf1, "Input was cancelled!");
                EndDialog(hDlg, FALSE);     // signal text not accepted
            }
    }
    return(FALSE);                          // signal message not processed
}
