PROGRAM EmptyWin;
Uses WinTypes, WinProcs, WObjects;
{$R EMPTYWIN}
{$D Copyright (c) 1991 by Neil J. Rubenking}
CONST
  AppName : PChar = 'EmptyWin';
TYPE
  TMyApplication = object(TApplication)
    PROCEDURE InitMainWindow; virtual;
  END;

  PTestWindow = ^TTestWindow;
  TTestWindow = OBJECT(TWindow)
    CONSTRUCTOR Init(AParent : PWindowsObject; AName : PChar);
    DESTRUCTOR Done; Virtual;
    PROCEDURE SetUpWindow; Virtual;
    FUNCTION GetClassName : PChar; Virtual;
    PROCEDURE GetWindowClass(var AWndClass: TWndClass); virtual;
    PROCEDURE Paint(pDC : hDC; VAR PS : TPaintStruct); Virtual;
  END;

{--------------------------------------------------}
{ TTestWindow's methods                            }
{--------------------------------------------------}
  CONSTRUCTOR TTestWindow.Init(AParent : PWindowsObject; AName : PChar);
  BEGIN
    TWindow.Init(AParent, AName);
    Attr.Menu := LoadMenu(hInstance, AppName);
  END;

  PROCEDURE TTestWindow.SetUpWindow;
  BEGIN TWIndow.SetUpWindow; END;

  DESTRUCTOR TTestWindow.Done;
  BEGIN TWindow.Done; END;

  FUNCTION TTestWindow.GetClassName;
  BEGIN GetClassName := AppName; END;

  PROCEDURE TTestWindow.GetWindowClass(VAR AWndClass :
    TWndClass);
  BEGIN
    TWindow.GetWindowClass(AWndClass);
    AWndClass.hIcon := LoadIcon(HInstance, AppName);
  END;

  PROCEDURE TTestWindow.Paint(pDC : hDC; VAR PS : TPaintStruct);
  BEGIN TWindow.Paint(pDC, PS); END;

{--------------------------------------------------}
{ TMyApplication's method implementations:         }
{--------------------------------------------------}
  PROCEDURE TMyApplication.InitMainWindow;
  BEGIN MainWindow := New(PTestWindow, Init(Nil, AppName)); END;

{--------------------------------------------------}
{ Main program:                                    }
{--------------------------------------------------}
VAR MyApp: TMyApplication;
BEGIN
  MyApp.Init(AppName);
  MyApp.Run;
  MyApp.Done;
END.
