        title   ITRIG - Integer Trig Lookup
        page    55,132

; ITRIG.ASM -- Integer Trig Lookup Routines
; Copyright (C) 1991 Ray Duncan
;
_DATA   segment word public 'DATA'

table   dw      0                       ; 0 degrees
        dw      175                     ; 1 
        dw      349                     ; 2
        dw      523                     ; 3
        dw      698                     ; 4
        dw      872                     ; 5
        dw      1045                    ; 6
        dw      1219                    ; 7
        dw      1392                    ; 8
        dw      1564                    ; 9
        dw      1736                    ; 10
        dw      1908                    ; 11
        dw      2079                    ; 12
        dw      2250                    ; 13
        dw      2419                    ; 14
        dw      2588                    ; 15
        dw      2756                    ; 16
        dw      2924                    ; 17
        dw      3090                    ; 18
        dw      3256                    ; 19
        dw      3420                    ; 20
        dw      3584                    ; 21
        dw      3746                    ; 22
        dw      3907                    ; 23
        dw      4067                    ; 24
        dw      4226                    ; 25
        dw      4384                    ; 26
        dw      4540                    ; 27
        dw      4695                    ; 28
        dw      4848                    ; 29
        dw      5000                    ; 30
        dw      5150                    ; 31
        dw      5299                    ; 32
        dw      5446                    ; 33
        dw      5592                    ; 34
        dw      5736                    ; 35
        dw      5878                    ; 36
        dw      6018                    ; 37
        dw      6157                    ; 38
        dw      6293                    ; 39
        dw      6428                    ; 40
        dw      6561                    ; 41
        dw      6691                    ; 42
        dw      6820                    ; 43
        dw      6947                    ; 44
        dw      7071                    ; 45
        dw      7193                    ; 46
        dw      7314                    ; 47
        dw      7431                    ; 48
        dw      7547                    ; 49
        dw      7660                    ; 50
        dw      7771                    ; 51
        dw      7880                    ; 52
        dw      7986                    ; 53
        dw      8090                    ; 54
        dw      8192                    ; 55
        dw      8290                    ; 56
        dw      8387                    ; 57
        dw      8480                    ; 58
        dw      8572                    ; 59
        dw      8660                    ; 60
        dw      8746                    ; 61
        dw      8829                    ; 62
        dw      8910                    ; 63
        dw      8988                    ; 64
        dw      9063                    ; 65
        dw      9135                    ; 66
        dw      9205                    ; 67
        dw      9272                    ; 68
        dw      9336                    ; 69
        dw      9397                    ; 70
        dw      9455                    ; 71
        dw      9511                    ; 72
        dw      9563                    ; 73
        dw      9613                    ; 74
        dw      9659                    ; 75
        dw      9703                    ; 76
        dw      9744                    ; 77
        dw      9781                    ; 78
        dw      9816                    ; 79
        dw      9848                    ; 80
        dw      9877                    ; 81
        dw      9903                    ; 82
        dw      9925                    ; 83
        dw      9945                    ; 84
        dw      9962                    ; 85
        dw      9976                    ; 86
        dw      9986                    ; 87
        dw      9994                    ; 88
        dw      9998                    ; 89
        dw      10000                   ; 90 degrees

_DATA   ends

_TEXT   segment word public 'CODE'

        assume  cs:_TEXT,ds:_DATA

;
; TRIG:         Worker routine for SINE and COSINE
; Call with:    AX = degrees 0-180
; Returns:      AX = function value
; Destroys:     BX
;
trig    proc    near
        mov     bx,ax                   ; bx <- degrees
        cmp     bx,90                   ; degrees = 90-180?
        jle     trig1                   ; no, jump
        sub     bx,180                  ; yes, reduce the angle
        neg     bx                      ; to range 0-90
trig1:  sal     bx,1                    ; bx <- degrees * 2
        mov     ax,[bx+table]           ; extract function value
        ret                             ; back to caller
trig    endp

;
; COSINE        Return cosine of angle
; Call with:    AX = degrees 0-359
; Returns:      AX = cosine of angle * 10000
; Destroys:     Nothing
;
        public  cosine
cosine  proc    near                    ; add 90 degrees to angle and
        add     ax,90                   ; fall through to sine routine
cosine  endp

;
; SINE          Return sine of angle
; Call with:    AX = degrees 0-359
; Returns:      AX = sine of angle * 10000
; Destroys:     Nothing
;
        public  sine
sine    proc    near
        push    bx                      ; save registers
        push    dx
        cwd                             ; degrees -> double precision
        mov     bx,360                  ; reduce angle to 0-359 degrees
        idiv    bx
        mov     ax,dx                   ; AX <- reduced angle
        or      ax,ax                   ; is angle negative?
        jns     sine2                   ; no, jump
        add     ax,360                  ; yes, make it positive
sine2:  cmp     ax,180                  ; is angle >180 degrees?
        jle     sine3                   ; no, jump
        sub     ax,180                  ; yes, reduce to 0-179 degrees
        call    trig                    ; and look up function value
        neg     ax                      ; negate result and return
        jmp     sine4
sine3:  call    trig                    ; angle was <= 180
sine4:  pop     dx                      ; restore registers
        pop     bx
        ret                             ; return to caller
sine    endp

_TEXT   ends

        end     

