***********************************************************************
*   Name: POPDATE.PRG
* Author: Andrew Coupe
*  Usage: <expD>=POPDATE(<row>,<col>,[<default>])
*  Notes: UDF to popup a date selection box in FoxPRO 1.02
***********************************************************************
FUNCTION POPDATE
PARAMETER row,col,default

thismsg = SET("MESSAGE",1)            && Record current message line
thisdate =_diarydate                  && Save original date
*
* --- If default date is passed, use it, else use _dairydate
*
DEFAULT = IIF( PARAMETERS()=3, default, _diarydate)
_diarydate = default

DEFINE WINDOW CAL FROM row,col TO row+16,col+22 ;
DOUBLE TITLE "[CALENDAR]"
*
* --- Need SET STATUS ON to see the following message
*
SET MESSAGE TO ;
"Change date with arrow keys. [T]oday, Month:[PgUp/PgDn] Year:[^PgUp/^PgDn]"

ACTIVATE WINDOW cal
ACTIVATE WINDOW calendar IN cal
MOVE WINDOW calendar TO -1,-1        && Center calendar in window

DO WHILE LASTKEY() # 27              && While ESCAPE not HIT

   i=INKEY(0,"H")                    && Get keystroke
   DO CASE
    CASE i=13 .OR. i==27             && Enter or Esc
      EXIT

    CASE i=84.OR. i=116              && 'T' for Today
      _diarydate=DATE()

    CASE i =24                       && Down arrow
      _diarydate=_diarydate+7

    CASE i= 5                        && Up arrow
      _diarydate=_diarydate-7

    CASE i=19                        && Left arrow
      _diarydate=_diarydate-1

    CASE i=4                         && Right arrow
      _diarydate=_diarydate+1

    CASE i=3                         && Page down
      _diarydate=gomonth(_diarydate,1)

    CASE i=18                        && Page up
      _diarydate=gomonth(_diarydate,-1)

    CASE I= 30                       && ^Page down
      _diarydate=gomonth(_diarydate,12)

    CASE I= 31                       && ^Page Up
      _diarydate=gomonth(_diarydate,-12)
   ENDCASE
ENDDO

SET MESSAGE TO (thismsg)             && Restore message
RELEASE WINDOWS cal                  && Release CAL windows
*
* --- Return default date if ESC was pressed
*
newdate = ;
IIF( LASTKEY()=27, default, _diarydate)

_diarydate = thisdate                && Set system variable back

RETURN newdate                       && Return the selected date


