(* Copyright (C) 1998, 1999 Stuart King. All rights reserved. *)

(***************************************************************************
** Operating systems vary in how they represent end-of-line in text files.
** For example Unix and it's variants (such as Linux) use a line feed
** character to represent end-of-line. DOS, OS/2, Windows use two characters
** carriage return, and line feed together to represent end-of-line.
** Irie Pascal can read text files with any combination of carriage return,
** line feed characters as end-of-line, but it writes text files in the
** native file format. So converting text files with Irie Pascal is
** very easy all that is necessary is to read each line of text using
** "readln" and write out each line using "writeln".
****************************************************************************)
program text(output);
var
   param : integer;
   OutDir : filename;
   mode : integer;

   procedure DisplayError(msg : string);
   begin
      writeln('ERROR: ', msg);
      halt
   end;

   procedure syntax;
   begin
      writeln('Text - Converts text files into the native format');
      writeln('Syntax: ivm text filespec .. filespec output_directory');
      writeln('        The wildcards ''?'' and ''*'' may be used');
      writeln('For example:');
      writeln('        ivm text *.pas ' + dirsep + 'temp' + dirsep);
      halt
   end;

   procedure ConvertFile(InName, OutName : filename);
   const
      MaxLine = 1024;   (* Maximum length of a line in the text file to be converted *)
   var
      f, g : text;
      line : string[MaxLine];
   begin
      writeln(InName, ' -> ', OutName);
      reset(f, InName);
      rewrite(g, OutName);
      while not eof(f) do
         begin
            readln(f, line);
            writeln(g, line)
         end;
      close(g);
      close(f)
   end;

   procedure ConvertTextFiles(f : filename);
   var
      DirPart, NamePart, ExtPart : filename;
      fname : filename;
      d : Dir;

   begin (* ConvertTextFiles *)
      f := fexpand(f);
      writeln(f);
      fsplit(f, DirPart, NamePart, ExtPart);
      NamePart := NamePart + ExtPart;
      OpenDir(d, DirPart);
      repeat
         ReadDir(d, fname);
         if fname <> '' then    (* if there are more files in directory *)
            begin
               if FileMatch(NamePart, fname) then
                  begin
                     ConvertFile(DirPart+fname, OutDir+fname)
                  end
            end
      until fname = '';
      CloseDir(d)
   end; (* ConvertTextFiles *)

begin
   if paramcount < 2 then
      syntax;
   OutDir := fexpand(paramstr(paramcount));
   getfilemode(OutDir, mode);
   if (mode and dir_bit) = 0 then
      DisplayError("'" + paramstr(paramcount) + "' is not a directory");
      (* fsplit(OutDir, OutDir, , ); *)
   if copy(OutDir, length(OutDir), 1) <> dirsep then
      OutDir := OutDir + dirsep;
   for param := 1 to paramcount-1 do
      ConvertTextFiles(paramstr(param));
end.
