/*--------------------------------------------------------------------------*
 * Gregory Stevens                                                   7/1/93 *
 *                              NNEVOLVE.C                                  *
 *                                                                          *
 *                                                                          *
 *--------------------------------------------------------------------------*/
#include "nnbkprop.c"                /* to chain it to the nn*.c utilities  */

#define NUM_ITS 1000                 /* iterations before it stops training */

void main()
{
  int Patr;
  int Pattern;                          /* for looping through patterns   */
  int Layer;                            /* for looping through layers     */
  int LCV;                              /* for looping training sets      */
  FILE *outputfile, *HidActFile;        /* for saving activations         */
  NNETtype Net;                         /* for the network itself         */
  PATTERNtype InPatterns, OutPattern;   /* for the training patterns      */

  HidActFile = fopen( "hidacts.out", "wt" );
  outputfile = fopen( "outnodes.out", "wt" );

  Net = InitNet( NUMNODES );           /* initializes the network        */
  InPatterns = InitInPatterns(0);       /* loads input patterns from file */
  OutPattern = InitOutPatterns();       /* loads output patterns from file*/

  printf("\n\n\n\n\n");                 /* gets screen ready for output   */

  printf( "BEGINNING TRAINING:\n\n" );

  for (LCV=0; (LCV < NUM_ITS); ++LCV)   /* loop through a training set    */
    {
      for (Pattern=0; (Pattern<10); ++Pattern)  /* each pattern */
         {
            /* FORWARD PROPAGATION */
            Patr = (rand() % 16);           /* chose a pattern btw. 0, 15 */

            Net = UpDateInputAct( InPatterns, Patr, Net );
            for (Layer=1; (Layer<NUMLAYERS); ++Layer)
              {
                 Net = UpDateLayerAct( Net, Layer );
              }

            DisplayLayer( Net, 0, 4 );             /* display input layer */
            printf( "   " );
            DisplayLayer( Net, (NUMLAYERS-1), 4);  /* display output layer*/
            printf( "\n" );                        /* new line            */

            /* BACKWARD PROPAGATION */
            Net = UpDateWeightandThresh( Net, OutPattern, Patr );
         }
    }

  for (LCV=0; (LCV<16); ++LCV)
    {
      /* FORWARD PROPAGATION */
      Net = UpDateInputAct( InPatterns, LCV, Net );
      for (Layer=1; (Layer<NUMLAYERS); ++Layer)
        {
           Net = UpDateLayerAct( Net, Layer );
        }

      for (Layer=0; (Layer<NUMNODES[1]); ++Layer)
        fprintf( HidActFile, "%2.2f ", Net.unit[1][Layer].state );
      fprintf( HidActFile, "\n" );

      fprintf( outputfile, "%2.2f ", Net.unit[2][0].state );
      fprintf( outputfile, "%2.2f ", Net.unit[2][1].state );
      fprintf( outputfile, "%2.2f ", Net.unit[2][2].state );
      fprintf( outputfile, "%2.2f \n", Net.unit[2][3].state );
    }

  {
   FILE *WeightFile;
   WeightFile = fopen( "weights.out", "wt" );

   for (Layer=1; (Layer<=NUMLAYERS); ++Layer)
   {
    for (LCV=0; (LCV<NUMNODES[Layer]); ++LCV)
    {
     for (Pattern=0; (Pattern<NUMNODES[Layer-1]); ++Pattern)
     {
      fprintf( WeightFile, "%4.4f ", Net.unit[Layer][LCV].weights[Pattern] );
     }
     fprintf( WeightFile, "\n");
    }
   fprintf( WeightFile, "\n\n");
   }

   fclose( WeightFile );
  }

  fclose( HidActFile );
  fclose( outputfile );
}
