/*
  Local resource failure handler.

  Function: This procedure make notifying of a conversation partner
            about the failure of the local resources.

 CopyRight 1995. Nicholas Poljakov all rights reserved.

 */

#include <lucb.h>
#include <rcb.h>
#include <scb.h>
#include <include.h>
#include <state1.h>

extern struct rcb *wait_rcb;
extern struct lucb lu6;
int sk_r_wt(void *);
int SendBlock(void *, void *);
int setrc(void *, void *);
int sendhsf(void *);
int sendhs(void *);
int sendbm(void *, void *);
int sendat(void *);
int rtsend(void *);
unsigned long rmfmh5(void *, void *);
int recwait(void *);
int rcvru(void *, void *);
int rcvhs(void *, void *, void *, void *);
int ralloc(void *, void *);
int psrm(int, void *, void *);
int ps_conv(int, void *);
int proterr(void *, unsigned long);
int preptrcv(void *, void *);
int post_rcb(void *);
struct repass *postopen(void *);
int phsrec(void *);
int pfmh5(void *);
int opndst(void *);
int obtsess(void *, unsigned char);
int get_sess(void *, void *);
int get_attr(void *);
int fsm_error(unsigned char, void *);
int fsm_conv(unsigned char, unsigned char, void *);
int flush (void *);
int dcp(void *);
int dealloc(void *);
int crtp(void *);
int conv(void *);
int chkparm(void *, void *);
int check_end(unsigned int, void *);
struct rqb *call_appl(void *);
int buffmng(unsigned char, void *, void *, void *, unsigned, unsigned char, unsigned);
unsigned long attltck(void *);
unsigned long attacheck(void *);
char *cgetmem(int, int);
int sendhsf(void *);
int opndst(void *);
int alloc_rcb(void *, void *);
int allocate(void *);
int clsdst(void *);
int bldfmh7(void *, unsigned long);

Lrf_handler(s_ptr)
struct rqb *s_ptr;
{
     struct scb *p_scb;
     struct rcb *p_rcb;
     register int i;
     unsigned long sense;
     unsigned char p1;

    /*
     * Search for the SCB
     */
    p_scb = lu6.scb_list;
    while (p_scb != NULL) {
        for (i = 0; i < 8; i++) {
            if (s_ptr -> th.ra.wa.area[i] != p_scb -> lu_name[i]) {
                goto N_scb;
            }
        }
        break;
        N_scb:
               p_scb = p_scb -> next;
    }
    if (p_scb == NULL) {
        return; /* the SCB was not found */
    }

    p_rcb = p_scb -> p_rcb;
    wait_rcb = p_rcb;
#if OS_TYPE == 0 /* MS-DOS */
    post_rcb(p_rcb);
#endif
    p1 = ALLOC_FAIL_RETRY;
    fsm_error(p1, p_rcb);
    sense = 0x000107ff;  /* user sense code - local_resource_failure */
    bldfmh7(p_rcb, sense);
}
