/*******************************************************************/
/*                                                                 */
/*                                                                 */
/*     ATTACH_LENGTH_CHECK                                         */
/*                                                                 */
/* Function: this procedure checks the lengths of the fields in    */
/* the ATTACH header                                               */
/*                                                                 */
/* input :   the FMH-5 attach header                               */
/*                                                                 */
/* output:   return code :                                         */
/*                x'00000000'  no error                             */
/*                x'10086000'  fmh length not corrected             */
/*  not used      x'10086005'  access security information length   */
/*                             is invalid                           */
/*                x'10086009'  an invalid parameter length          */
/*   not used     x'10086011'  an invalid value for the "logical    */
/*                                             unit of work"        *
 *                                                                  *
 * CopyRight 1995. Nicholas Poljakov all rights reserved.           *
 *                                                                  *
 ********************************************************************/
#include <fmh5.h>
#include <state1.h>
#include <string.h>

unsigned long attltck(att_ptr)
char *att_ptr;
{
struct FMH5 *a_ptr;
unsigned long code;
unsigned offset;

#if OS_TYPE == 1
/*********  Trace facility **********/
unsigned int rtype;   /* type of record */
unsigned int pnum;    /* point number */
char pname[8];        /* name of module */
char *drec;       /* record for dump */
int  lenr;            /* record length */

rtype = INPROC;
strcpy(pname, "attlnck");
pnum = 1;
drec = att_ptr;
lenr = 200;
gtf(rtype, pname, pnum, drec, lenr);
/***********************************/
#endif


code = 0;
a_ptr = (struct FMH5 *)att_ptr;
offset=5;
if (a_ptr -> length <= offset)
    {
       code=0x10086000;  /*fmh  length is invalid*/
       goto exit_pgn;
    }

     if  (a_ptr -> lnflp < 3)
     {
     code=0x10086009;   /*invalid param length*/
     goto exit_pgn;
     }

     offset += (a_ptr -> lnflp) + 1;   /*+value of the fixed length*/
                                       /*the tp name length field*/
if   (a_ptr -> length <= offset)
     {
     code=0x10086000;                  /*fmh length is invalid   */
     goto exit_pgn;
     }

     offset += (a_ptr -> lntpn) + 1;   /*+tp name length field */
                                       /*access  securuty  field*/

 if  (a_ptr -> length < offset)
      {
      code=0x10086000;                 /*fmh length is invalid  */
      goto exit_pgn;
      }
 /* Here we not use an "access security" and a "logical unit of work" */
exit_pgn :
  return(code);
}
